/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.ui.ISVNRepositorySourceProvider;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.ConfigurationWizardMainPage;
import org.tigris.subversion.subclipse.ui.wizards.ConfigurationWizardRepositorySourceProviderPage;
import org.tigris.subversion.subclipse.ui.wizards.SVNRepositoryProviderWizardPage;

public class NewLocationWizard
extends Wizard {
    private ConfigurationWizardRepositorySourceProviderPage repositorySourceProviderPage;
    private ConfigurationWizardMainPage mainPage;
    private Map<ISVNRepositorySourceProvider, SVNRepositoryProviderWizardPage> wizardPageMap = new HashMap<ISVNRepositorySourceProvider, SVNRepositoryProviderWizardPage>();
    private Properties properties = null;

    public NewLocationWizard() {
        IDialogSettings workbenchSettings = SVNUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewLocationWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewLocationWizard");
        }
        this.setDialogSettings(section);
        this.setWindowTitle(Policy.bind("NewLocationWizard.title"));
    }

    public NewLocationWizard(Properties initialProperties) {
        this();
        this.properties = initialProperties;
    }

    public void addPages() {
        ISVNRepositorySourceProvider[] repositorySourceProviders = null;
        try {
            repositorySourceProviders = SVNUIPlugin.getRepositorySourceProviders();
        }
        catch (Exception exception) {}
        if (repositorySourceProviders != null && repositorySourceProviders.length > 0) {
            this.repositorySourceProviderPage = new ConfigurationWizardRepositorySourceProviderPage("source", Policy.bind("NewLocationWizard.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.gif"), repositorySourceProviders);
            this.repositorySourceProviderPage.setDescription(Policy.bind("NewLocationWizard.0"));
            this.addPage((IWizardPage)this.repositorySourceProviderPage);
            ISVNRepositorySourceProvider[] iSVNRepositorySourceProviderArray = repositorySourceProviders;
            int n = 0;
            int n2 = iSVNRepositorySourceProviderArray.length;
            while (n < n2) {
                ISVNRepositorySourceProvider repositorySourceProvider = iSVNRepositorySourceProviderArray[n];
                SVNRepositoryProviderWizardPage wizardPage = repositorySourceProvider.getWizardPage();
                this.addPage((IWizardPage)wizardPage);
                this.wizardPageMap.put(repositorySourceProvider, wizardPage);
                ++n;
            }
        }
        this.mainPage = new ConfigurationWizardMainPage("main", Policy.bind("NewLocationWizard.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.gif"));
        if (this.properties != null) {
            this.mainPage.setProperties(this.properties);
        }
        this.mainPage.setDescription(Policy.bind("NewLocationWizard.description"));
        this.mainPage.setDialogSettings(this.getDialogSettings());
        this.addPage((IWizardPage)this.mainPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.repositorySourceProviderPage) {
            ISVNRepositorySourceProvider selectedRepositorySourceProvider = this.repositorySourceProviderPage.getSelectedRepositorySourceProvider();
            if (selectedRepositorySourceProvider != null) {
                return (IWizardPage)this.wizardPageMap.get(selectedRepositorySourceProvider);
            }
            return this.mainPage;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        SVNRepositoryProviderWizardPage wizardPage;
        ISVNRepositorySourceProvider selectedRepositorySourceProvider;
        this.mainPage.finish((IProgressMonitor)new NullProgressMonitor());
        Properties properties = this.mainPage.getProperties();
        if (this.repositorySourceProviderPage != null && (selectedRepositorySourceProvider = this.repositorySourceProviderPage.getSelectedRepositorySourceProvider()) != null && (wizardPage = this.wizardPageMap.get(selectedRepositorySourceProvider)) != null) {
            properties.setProperty("url", wizardPage.getSelectedUrl());
        }
        final ISVNRepositoryLocation[] root = new ISVNRepositoryLocation[1];
        SVNProviderPlugin provider = SVNProviderPlugin.getPlugin();
        try {
            block13: {
                root[0] = provider.getRepositories().createRepository(properties);
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException {
                            try {
                                root[0].validateConnection(monitor);
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (!(t instanceof TeamException)) break block13;
                    throw (TeamException)t;
                }
            }
            provider.getRepositories().addOrUpdateRepository(root[0]);
            return true;
        }
        catch (TeamException e) {
            if (root[0] == null) {
                SVNUIPlugin.openError(this.getContainer().getShell(), Policy.bind("NewLocationWizard.exception"), null, e);
                return false;
            }
            IStatus error = e.getStatus();
            if (error.isMultiStatus() && error.getChildren().length == 1) {
                error = error.getChildren()[0];
            }
            boolean keep = false;
            if (error.isMultiStatus()) {
                SVNUIPlugin.openError(this.getContainer().getShell(), Policy.bind("NewLocationWizard.validationFailedTitle"), null, e);
            } else {
                keep = MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)Policy.bind("NewLocationWizard.validationFailedTitle"), (String)Policy.bind("NewLocationWizard.validationFailedText", new Object[]{error.getMessage()}));
            }
            try {
                if (keep) {
                    provider.getRepositories().addOrUpdateRepository(root[0]);
                    return keep;
                }
                provider.getRepositories().disposeRepository(root[0]);
                return keep;
            }
            catch (TeamException e1) {
                SVNUIPlugin.openError(this.getContainer().getShell(), Policy.bind("exception"), null, e1);
                return false;
            }
        }
    }

    public boolean canFinish() {
        if (this.repositorySourceProviderPage != null) {
            ISVNRepositorySourceProvider selectedSourceProvider = this.repositorySourceProviderPage.getSelectedRepositorySourceProvider();
            if (selectedSourceProvider == null) {
                return this.mainPage.isPageComplete();
            }
            SVNRepositoryProviderWizardPage wizardPage = this.wizardPageMap.get(selectedSourceProvider);
            if (wizardPage != null) {
                return wizardPage.isPageComplete();
            }
        }
        return super.canFinish();
    }
}

