/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.directclickthrough.ui;

import com.atlassian.connector.eclipse.internal.core.jobs.JobWithStatus;
import com.atlassian.connector.eclipse.internal.directclickthrough.servlet.DirectClickThroughServlet;
import com.atlassian.connector.eclipse.internal.directclickthrough.ui.JettyLogger;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;
import org.osgi.framework.BundleContext;

public class DirectClickThroughUiPlugin
extends AbstractUIPlugin {
    private Server embeddedServer;
    public static final String PLUGIN_ID = "com.atlassian.connector.eclipse.directclickthrough.ui";
    private static DirectClickThroughUiPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                DirectClickThroughUiPlugin.this.stopEmbeddedServer();
                if (DirectClickThroughUiPlugin.this.getPreferenceStore().getBoolean("com.atlassian.connector.eclipse.directclickthrough.ui.enabled")) {
                    DirectClickThroughUiPlugin.this.startEmbeddedServer();
                }
            }
        });
        if (this.getPreferenceStore().getBoolean("com.atlassian.connector.eclipse.directclickthrough.ui.enabled")) {
            this.startEmbeddedServer();
        }
    }

    private void startEmbeddedServer() {
        if (this.embeddedServer != null) {
            this.stopEmbeddedServer();
        }
        final JobWithStatus serverJob = new JobWithStatus("Start Embedded Web Server"){

            protected void runImpl(IProgressMonitor monitor) {
                try {
                    DirectClickThroughUiPlugin.this.embeddedServer = new Server();
                    SocketConnector connector = new SocketConnector();
                    connector.setHost("127.0.0.1");
                    connector.setPort(DirectClickThroughUiPlugin.this.getPortNumber());
                    DirectClickThroughUiPlugin.this.embeddedServer.addConnector((Connector)connector);
                    Context context = new Context((HandlerContainer)DirectClickThroughUiPlugin.this.embeddedServer, "/", 0);
                    context.addServlet(new ServletHolder((Servlet)new DirectClickThroughServlet()), "/*");
                    DirectClickThroughUiPlugin.this.embeddedServer.start();
                }
                catch (Exception e) {
                    this.setStatus((IStatus)new Status(1, DirectClickThroughUiPlugin.PLUGIN_ID, "Unable to run embedded web server, Direct Click Through will not be available", (Throwable)e));
                }
            }
        };
        serverJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!serverJob.getStatus().isOK()) {
                    StatusHandler.log((IStatus)serverJob.getStatus());
                }
            }
        });
        serverJob.schedule();
    }

    public int getPortNumber() {
        return this.getPreferenceStore().getInt("com.atlassian.connector.eclipse.directclickthrough.ui.port_number");
    }

    public void stop(BundleContext context) throws Exception {
        if (this.getPreferenceStore().getBoolean("com.atlassian.connector.eclipse.directclickthrough.ui.enabled")) {
            this.stopEmbeddedServer();
        }
        plugin = null;
        super.stop(context);
    }

    private void stopEmbeddedServer() {
        try {
            if (this.embeddedServer != null) {
                this.embeddedServer.stop();
                this.embeddedServer = null;
            }
        }
        catch (Exception exception) {
            StatusHandler.log((IStatus)new Status(2, PLUGIN_ID, "Unabled to stop embedded Direct Click Through server"));
        }
    }

    public static DirectClickThroughUiPlugin getDefault() {
        return plugin;
    }

    public static class EarlyStartup
    implements IStartup {
        public void earlyStartup() {
            Log.setLog((Logger)new JettyLogger());
        }
    }
}

