/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.monitor.core;

import com.atlassian.connector.eclipse.monitor.core.AbstractMonitorLog;
import com.atlassian.connector.eclipse.monitor.core.InteractionEvent;
import com.atlassian.connector.eclipse.monitor.core.MonitorCorePlugin;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.Sun14ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.JDomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionEventLogger
extends AbstractMonitorLog {
    private final List<InteractionEvent> queue = new CopyOnWriteArrayList<InteractionEvent>();
    private final XStream xs;

    public InteractionEventLogger(File outputFile) {
        this.outputFile = outputFile;
        this.xs = new XStream((ReflectionProvider)new Sun14ReflectionProvider(), (HierarchicalStreamDriver)new JDomDriver());
        this.xs.aliasType("interactionEvent", InteractionEvent.class);
    }

    public synchronized void interactionObserved(InteractionEvent event) {
        if (MonitorCorePlugin.getDefault() == null) {
            StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.monitor.core", "Attempted to log event before usage monitor start"));
        }
        try {
            if (this.started) {
                String xml = this.getXmlForEvent(event);
                this.outputStream.write(xml.getBytes());
            } else if (event != null) {
                this.queue.add(event);
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.monitor.core", "Could not log interaction event", t));
        }
    }

    @Override
    public void startMonitoring() {
        super.startMonitoring();
        for (InteractionEvent queuedEvent : this.queue) {
            this.interactionObserved(queuedEvent);
        }
        this.queue.clear();
    }

    @Override
    public void stopMonitoring() {
        super.stopMonitoring();
    }

    private String getXmlForEvent(InteractionEvent event) {
        try {
            return this.xs.toXML((Object)event);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", "Could not write event", t));
            return "";
        }
    }

    public synchronized void clearInteractionHistory() throws IOException {
        this.clearInteractionHistory(true);
    }

    public synchronized void clearInteractionHistory(boolean startMonitoring) throws IOException {
        this.stopMonitoring();
        this.outputStream = new FileOutputStream(this.outputFile, false);
        this.outputStream.flush();
        this.outputStream.close();
        this.outputFile.delete();
        this.outputFile.createNewFile();
        if (startMonitoring) {
            this.startMonitoring();
        }
    }

    public List<InteractionEvent> getHistoryFromFile(File file) {
        ArrayList<InteractionEvent> events = new ArrayList<InteractionEvent>();
        try {
            if (file.getName().endsWith(".zip")) {
                ZipFile zip = new ZipFile(file);
                if (zip.entries().hasMoreElements()) {
                    ZipEntry entry = zip.entries().nextElement();
                    this.getHistoryFromStream(zip.getInputStream(entry), events);
                }
            } else {
                FileInputStream reader = new FileInputStream(file);
                this.getHistoryFromStream(reader, events);
                ((InputStream)reader).close();
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.monitor.core", "Could not read interaction history", (Throwable)e));
        }
        return events;
    }

    private void getHistoryFromStream(InputStream reader, List<InteractionEvent> events) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write("<list>".getBytes());
        IOUtils.copy((InputStream)reader, (OutputStream)out);
        out.write("</list>".getBytes());
        List list = (List)this.xs.fromXML(out.toString());
        if (list != null) {
            for (Object e : list) {
                if (!(e instanceof InteractionEvent)) continue;
                events.add((InteractionEvent)e);
            }
        }
    }
}

