/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.monitor.core;

import com.atlassian.connector.eclipse.internal.monitor.core.Messages;
import com.atlassian.connector.eclipse.internal.monitor.core.operations.UploadMonitoringStatusJob;
import com.atlassian.connector.eclipse.internal.monitor.core.operations.UsageDataUploadJob;
import com.atlassian.connector.eclipse.internal.ui.AtlassianBundlesInfo;
import com.atlassian.connector.eclipse.monitor.core.InteractionEvent;
import com.atlassian.connector.eclipse.monitor.core.InteractionEventLogger;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class MonitorCorePlugin
extends Plugin {
    private static final String SYSTEM_INFO_PREFIX = "system info: ";
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    public static final long DELAY_BETWEEN_TRANSMITS = 86400000L;
    public static final String MONITOR_LOG_NAME_OLD = "monitor-log.xml";
    public static final String MONITOR_LOG_NAME = "usage-data.xml";
    public static final String ID_PLUGIN = "com.atlassian.connector.eclipse.monitor.core";
    private static final long SIX_HOURS_IN_MS = 21600000L;
    private InteractionEventLogger interactionLogger;
    private static MonitorCorePlugin plugin;
    public static final String UPLOAD_URL = "https://update.atlassian.com/atlassian-eclipse-plugin/usage-collector/upload-2";
    public static final String HELP_URL = "http://confluence.atlassian.com/display/IDEPLUGIN/Collecting+Usage+Statistics+for+the+Eclipse+Connector";
    private UsageDataUploadJob scheduledStatisticsUploadJob;

    public MonitorCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    private void logPlatformDetails(InteractionEventLogger log) {
        log.interactionObserved(InteractionEvent.makePreference(ID_PLUGIN, "system info: os-arch", Platform.getOSArch()));
        log.interactionObserved(InteractionEvent.makePreference(ID_PLUGIN, "system info: os", Platform.getOS()));
        log.interactionObserved(InteractionEvent.makePreference(ID_PLUGIN, "system info: org.eclipse.core.runtime", ((String)Platform.getBundle((String)"org.eclipse.core.runtime").getHeaders().get("Bundle-Version")).toString()));
        log.interactionObserved(InteractionEvent.makePreference(ID_PLUGIN, "system info: connector-version", ((String)MonitorCorePlugin.getDefault().getBundle().getHeaders().get("Bundle-Version")).toString()));
    }

    private void logInstalledFeatures(InteractionEventLogger log) {
        log.interactionObserved(InteractionEvent.makePreference(ID_PLUGIN, "system info: plugins", AtlassianBundlesInfo.getAllInstalledBundles().toString()));
    }

    public void startMonitoring() {
        this.getInteractionLogger().startMonitoring();
        this.logPlatformDetails(this.interactionLogger);
        this.logInstalledFeatures(this.interactionLogger);
        this.startUploadStatisticsJob();
    }

    public void stopMonitoring() {
        this.stopUploadStatisticsJob();
        if (this.interactionLogger != null) {
            this.interactionLogger.stopMonitoring();
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public File getLogFilesRootDir() {
        File rootDir = new File(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + "/.metadata/.atlassian-connector-for-eclipse");
        if (!rootDir.exists()) {
            rootDir.mkdirs();
        }
        return rootDir;
    }

    public File getMonitorLogFile() {
        File rootDir = this.getLogFilesRootDir();
        File file = new File(rootDir, MONITOR_LOG_NAME);
        if (!file.exists() || !file.canWrite()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, Messages.MonitorCorePlugin_cant_create_log_file, (Throwable)e));
            }
        }
        return file;
    }

    public static MonitorCorePlugin getDefault() {
        return plugin;
    }

    public Job startUploadStatisticsJob() {
        this.scheduledStatisticsUploadJob = new UsageDataUploadJob(false);
        this.scheduledStatisticsUploadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                MonitorCorePlugin.this.scheduledStatisticsUploadJob.schedule(21600000L);
            }
        });
        this.scheduledStatisticsUploadJob.schedule();
        return this.scheduledStatisticsUploadJob;
    }

    public void stopUploadStatisticsJob() {
        if (this.scheduledStatisticsUploadJob != null) {
            this.scheduledStatisticsUploadJob.cancel();
        }
    }

    public InteractionEventLogger getInteractionLogger() {
        if (this.interactionLogger == null) {
            File oldMonitorFile = new File(this.getLogFilesRootDir(), MONITOR_LOG_NAME_OLD);
            if (oldMonitorFile.exists() && oldMonitorFile.canWrite()) {
                oldMonitorFile.delete();
            }
            try {
                this.interactionLogger = new InteractionEventLogger(this.getMonitorLogFile());
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, Messages.MonitorCorePlugin_failed_to_start, t));
            }
        }
        return this.interactionLogger;
    }

    public IEclipsePreferences getPreferenceStore() {
        return new InstanceScope().getNode(ID_PLUGIN);
    }

    public String getUserId() {
        IEclipsePreferences prefs = this.getPreferenceStore();
        String uid = prefs.get("com.atlassian.connector.eclipse.monitor.usage.user_id", null);
        if (uid == null) {
            uid = UUID.randomUUID().toString();
            prefs.put("com.atlassian.connector.eclipse.monitor.usage.user_id", uid);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return uid;
    }

    public Date getPreviousTransmitDate() {
        IEclipsePreferences prefs = this.getPreferenceStore();
        if (prefs.get("com.atlassian.connector.eclipse.monitor.usage.upload.previousTransmit", null) != null) {
            return new Date(prefs.getLong("com.atlassian.connector.eclipse.monitor.usage.upload.previousTransmit", new Date().getTime()));
        }
        return null;
    }

    public void setPreviousTransmitDate(Date lastTransmit) {
        IEclipsePreferences prefs = this.getPreferenceStore();
        prefs.putLong("com.atlassian.connector.eclipse.monitor.usage.upload.previousTransmit", lastTransmit.getTime());
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public void monitoringDisabled() {
        UploadMonitoringStatusJob job = new UploadMonitoringStatusJob(false);
        job.schedule();
    }

    public void monitoringEnabled() {
        UploadMonitoringStatusJob job = new UploadMonitoringStatusJob(true);
        job.schedule();
    }
}

