/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.googleanalytics;

import java.io.UnsupportedEncodingException;
import org.tigris.subversion.subclipse.tools.usage.googleanalytics.GoogleAnalyticsCookie;
import org.tigris.subversion.subclipse.tools.usage.googleanalytics.IGoogleAnalyticsParameters;
import org.tigris.subversion.subclipse.tools.usage.reporting.SubclipseComponents;
import org.tigris.subversion.subclipse.tools.usage.tracker.IURLBuildingStrategy;
import org.tigris.subversion.subclipse.tools.usage.tracker.internal.IFocusPoint;
import org.tigris.subversion.subclipse.tools.usage.util.HttpEncodingUtils;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class GoogleAnalyticsUrlStrategy
implements IURLBuildingStrategy {
    private static final String TRACKING_URL = "http://www.google-analytics.com/__utm.gif";
    private IGoogleAnalyticsParameters googleParameters;

    public GoogleAnalyticsUrlStrategy(IGoogleAnalyticsParameters googleAnalyticsParameters) {
        this.googleParameters = googleAnalyticsParameters;
    }

    public String build(IFocusPoint focusPoint) throws UnsupportedEncodingException {
        String svnInterface;
        String keyword;
        StringBuffer builder = new StringBuffer(TRACKING_URL).append('?');
        this.appendParameter("utmwv", "4.7.2", builder);
        this.appendParameter("utmn", this.getRandomNumber(), builder);
        this.appendParameter("utmhn", this.googleParameters.getHostname(), builder);
        this.appendParameter("utmcs", "UTF-8", builder);
        this.appendParameter("utmsr", this.googleParameters.getScreenResolution(), builder);
        this.appendParameter("utmsc", this.googleParameters.getScreenColorDepth(), builder);
        this.appendParameter("utmul", this.googleParameters.getBrowserLanguage(), builder);
        String cookies = this.getCookies();
        StringBuffer page = new StringBuffer("Subclipse");
        if (SubclipseComponents.getSubclipseVersion() != null) {
            page.append("_" + SubclipseComponents.getSubclipseVersion());
        }
        if ((keyword = this.googleParameters.getKeyword()) != null && keyword.indexOf("MERGE") != -1) {
            page.append("_MergeClientInstalled");
        }
        this.appendParameter("utmdt", page.toString(), builder);
        this.appendParameter("utmfl", this.googleParameters.getFlashVersion(), builder);
        this.appendParameter("utmr", this.googleParameters.getReferral(), builder);
        StringBuffer pageRequest = new StringBuffer("/Subclipse");
        if (SubclipseComponents.getSubclipseVersion() != null) {
            pageRequest.append("/" + SubclipseComponents.getSubclipseVersion());
        }
        if ((svnInterface = SVNUIPlugin.getPlugin().getPreferenceStore().getString("pref_svninterface")) != null) {
            pageRequest.append("/" + svnInterface);
        }
        String encodedPageRequest = HttpEncodingUtils.checkedEncodeUtf8(pageRequest.toString());
        this.appendParameter("utmp", encodedPageRequest, builder);
        this.appendParameter("utmac", this.googleParameters.getAccountName(), builder);
        this.appendParameter("utmcc", cookies, builder);
        this.appendParameter("gaq", "1", false, builder);
        this.googleParameters.visit();
        return builder.toString();
    }

    private String getCookies() {
        StringBuffer builder = new StringBuffer();
        char[] plusDelimiter = new char[]{'+'};
        new GoogleAnalyticsCookie("__utma", new StringBuffer().append("999.").append(this.googleParameters.getUserId()).append('.').append(this.googleParameters.getFirstVisit()).append('.').append(this.googleParameters.getLastVisit()).append('.').append(this.googleParameters.getCurrentVisit()).append('.').append(this.googleParameters.getVisitCount()).append(';'), plusDelimiter).appendTo(builder);
        new GoogleAnalyticsCookie("__utmz", new StringBuffer().append("999.").append(this.googleParameters.getFirstVisit()).append('.').append("1.1.")).appendTo(builder);
        char[] pipeDelimiter = new char[]{'|'};
        new GoogleAnalyticsCookie("utmcsr", "(direct)", pipeDelimiter).appendTo(builder);
        new GoogleAnalyticsCookie("utmccn", "(direct)", pipeDelimiter).appendTo(builder);
        new GoogleAnalyticsCookie("utmcmd", "(none)", pipeDelimiter).appendTo(builder);
        new GoogleAnalyticsCookie("utmctr", this.googleParameters.getKeyword(), pipeDelimiter).appendTo(builder);
        char[] blankDelimiter = new char[]{' '};
        new GoogleAnalyticsCookie("__utmv", String.valueOf(this.getRandomNumber()) + '.' + this.googleParameters.getUserDefined(), blankDelimiter).appendTo(builder);
        builder.append(';');
        return HttpEncodingUtils.checkedEncodeUtf8(builder.toString());
    }

    private String getRandomNumber() {
        return Integer.toString((int)(Math.random() * 2.147483647E9));
    }

    private void appendParameter(String name, String value, StringBuffer builder) {
        this.appendParameter(name, value, true, builder);
    }

    private void appendParameter(String name, String value, boolean appendAmpersand, StringBuffer builder) {
        builder.append(name).append('=').append(value);
        if (appendAmpersand) {
            builder.append('&');
        }
    }
}

