/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.springframework.ide.eclipse.webflow.core.internal.model.Mapping;
import org.springframework.ide.eclipse.webflow.core.internal.model.OutputAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IMapping;
import org.springframework.ide.eclipse.webflow.core.model.IOutputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IOutputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ModelTableLabelProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.TableCellModifier;

public class OutputMapperComposite {
    private IOutputMapper state;
    private List<IOutputAttribute> outputAttributes;
    private Button attributeRemoveButton;
    private Button attributeAddButton;
    private Button attributeEditButton;
    private Button mappingRemoveButton;
    private Button mappingAddButton;
    private Button mappingEditButton;
    private TableViewer attributeViewer;
    private TableViewer mappingViewer;
    private IDialogValidator validator;
    private Shell parentShell;
    private List<IMapping> mappings;

    public OutputMapperComposite(IDialogValidator validator, TabItem item, Shell parentShell, List<IOutputAttribute> outputAttributes, List<IMapping> mappings, IOutputMapper state) {
        this.state = state;
        this.outputAttributes = outputAttributes;
        this.mappings = mappings;
        item.setText("Output Mapping");
        item.setToolTipText("Define element's output mapping");
        item.setImage(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.output_obj.gif"));
        this.parentShell = parentShell;
    }

    protected Control createDialogArea(Composite superParent) {
        Composite parent = new Composite(superParent, 0);
        GridLayout layoutPropMap = new GridLayout();
        layoutPropMap.marginWidth = 0;
        layoutPropMap.marginHeight = 0;
        parent.setLayout((Layout)layoutPropMap);
        parent.setLayoutData((Object)new GridData(1808));
        Group groupPropertyType = new Group(parent, 0);
        layoutPropMap = new GridLayout();
        layoutPropMap.marginWidth = 3;
        layoutPropMap.marginHeight = 3;
        groupPropertyType.setLayout((Layout)layoutPropMap);
        groupPropertyType.setText(" Output Attributes ");
        groupPropertyType.setLayoutData((Object)new GridData(768));
        Composite tableAndButtons = new Composite((Composite)groupPropertyType, 0);
        tableAndButtons.setLayoutData((Object)new GridData(768));
        GridLayout layout2 = new GridLayout();
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout2);
        Table configsTable = new Table(tableAndButtons, 68354);
        GridData data = new GridData(1808);
        data.heightHint = 75;
        configsTable.setLayoutData((Object)data);
        TableColumn columnName = new TableColumn(configsTable, 0);
        columnName.setText("Name");
        columnName.setWidth(150);
        TableColumn columnValue = new TableColumn(configsTable, 0);
        columnValue.setText("Scope");
        columnValue.setWidth(120);
        TableColumn columnType = new TableColumn(configsTable, 0);
        columnType.setText("Required");
        columnType.setWidth(80);
        configsTable.setHeaderVisible(true);
        this.attributeViewer = new TableViewer(configsTable);
        String[] columnNames = new String[]{"Name", "Value", "Required"};
        this.attributeViewer.setColumnProperties(columnNames);
        this.attributeViewer.setContentProvider((IContentProvider)new OutputMapperContentProvider(this.outputAttributes));
        this.attributeViewer.setCellEditors(new CellEditor[0]);
        this.attributeViewer.setLabelProvider((IBaseLabelProvider)new ModelTableLabelProvider());
        this.attributeViewer.setCellModifier((ICellModifier)new TableCellModifier());
        this.attributeViewer.setInput((Object)this.state);
        configsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputMapperComposite.this.handleAttributeTableSelectionChanged();
            }
        });
        Composite buttonArea = new Composite(tableAndButtons, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.attributeAddButton = new Button(buttonArea, 8);
        this.attributeAddButton.setText("Add");
        GridData data1 = new GridData(256);
        this.attributeAddButton.setLayoutData((Object)data1);
        this.attributeAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputAttribute attr = new OutputAttribute();
                attr.createNew((IWebflowModelElement)OutputMapperComposite.this.state);
                if (DialogUtils.openPropertiesDialog((IWebflowModelElement)OutputMapperComposite.this.state, (IWebflowModelElement)attr, true) == 0) {
                    OutputMapperComposite.this.outputAttributes.add(attr);
                    OutputMapperComposite.this.attributeViewer.refresh();
                }
            }
        });
        this.attributeEditButton = new Button(buttonArea, 8);
        this.attributeEditButton.setText("Edit");
        data1 = new GridData(256);
        this.attributeEditButton.setLayoutData((Object)data1);
        this.attributeEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)OutputMapperComposite.this.attributeViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IOutputAttribute && DialogUtils.openPropertiesDialog((IWebflowModelElement)OutputMapperComposite.this.state, (IWebflowModelElement)((IOutputAttribute)selection.getFirstElement()), true) == 0) {
                    OutputMapperComposite.this.attributeViewer.refresh(true);
                }
            }
        });
        this.attributeRemoveButton = new Button(buttonArea, 8);
        this.attributeRemoveButton.setText("Delete");
        GridData data2 = new GridData(256);
        this.attributeRemoveButton.setLayoutData((Object)data2);
        this.attributeRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)OutputMapperComposite.this.attributeViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IOutputAttribute) {
                    OutputMapperComposite.this.outputAttributes.remove(selection.getFirstElement());
                    OutputMapperComposite.this.attributeViewer.refresh(true);
                }
            }
        });
        this.attributeRemoveButton.setEnabled(false);
        this.attributeEditButton.setEnabled(false);
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.state)) {
            Group groupPropertyType2 = new Group(parent, 0);
            layoutPropMap = new GridLayout();
            layoutPropMap.marginWidth = 3;
            layoutPropMap.marginHeight = 3;
            groupPropertyType2.setLayout((Layout)layoutPropMap);
            groupPropertyType2.setText(" Mapping ");
            groupPropertyType2.setLayoutData((Object)new GridData(768));
            Composite tableAndButtons2 = new Composite((Composite)groupPropertyType2, 0);
            tableAndButtons2.setLayoutData((Object)new GridData(768));
            layout2 = new GridLayout();
            layout2.marginHeight = 0;
            layout2.marginWidth = 0;
            layout2.numColumns = 2;
            tableAndButtons2.setLayout((Layout)layout2);
            Table mappingConfigsTable = new Table(tableAndButtons2, 68354);
            data = new GridData(1808);
            data.heightHint = 75;
            mappingConfigsTable.setLayoutData((Object)data);
            TableColumn mcolumnName = new TableColumn(mappingConfigsTable, 0);
            mcolumnName.setText("Source");
            mcolumnName.setWidth(250);
            mappingConfigsTable.setHeaderVisible(true);
            this.mappingViewer = new TableViewer(mappingConfigsTable);
            String[] mcolumnNames = new String[]{"Source"};
            this.mappingViewer.setColumnProperties(mcolumnNames);
            this.mappingViewer.setContentProvider((IContentProvider)new MappingContentProvider(this.mappings));
            this.mappingViewer.setCellEditors(new CellEditor[0]);
            this.mappingViewer.setLabelProvider((IBaseLabelProvider)new ModelTableLabelProvider());
            this.mappingViewer.setCellModifier((ICellModifier)new TableCellModifier());
            this.mappingViewer.setInput((Object)this.state);
            mappingConfigsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OutputMapperComposite.this.handleMappingTableSelectionChanged();
                }
            });
            Composite buttonArea2 = new Composite(tableAndButtons2, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            buttonArea2.setLayout((Layout)layout);
            buttonArea2.setLayoutData((Object)new GridData(1040));
            this.mappingAddButton = new Button(buttonArea2, 8);
            this.mappingAddButton.setText("Add");
            data1 = new GridData(256);
            this.mappingAddButton.setLayoutData((Object)data1);
            this.mappingAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Mapping attr = new Mapping();
                    attr.createNew((IWebflowModelElement)OutputMapperComposite.this.state);
                    if (DialogUtils.openPropertiesDialog((IWebflowModelElement)OutputMapperComposite.this.state, (IWebflowModelElement)attr, true) == 0) {
                        OutputMapperComposite.this.mappings.add(attr);
                        OutputMapperComposite.this.mappingViewer.refresh(true);
                    }
                }
            });
            this.mappingEditButton = new Button(buttonArea2, 8);
            this.mappingEditButton.setText("Edit");
            data1 = new GridData(256);
            this.mappingEditButton.setLayoutData((Object)data1);
            this.mappingEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)OutputMapperComposite.this.mappingViewer.getSelection();
                    if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IMapping && DialogUtils.openPropertiesDialog((IWebflowModelElement)OutputMapperComposite.this.state, (IWebflowModelElement)((IMapping)selection.getFirstElement()), false) == 0) {
                        OutputMapperComposite.this.mappingViewer.refresh(true);
                    }
                }
            });
            this.mappingRemoveButton = new Button(buttonArea2, 8);
            this.mappingRemoveButton.setText("Delete");
            data2 = new GridData(256);
            this.mappingRemoveButton.setLayoutData((Object)data2);
            this.mappingRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)OutputMapperComposite.this.mappingViewer.getSelection();
                    if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IMapping) {
                        OutputMapperComposite.this.mappings.remove(selection.getFirstElement());
                        OutputMapperComposite.this.mappingViewer.refresh(true);
                    }
                }
            });
            this.mappingRemoveButton.setEnabled(false);
            this.mappingEditButton.setEnabled(false);
        }
        return parent;
    }

    private void handleAttributeTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.attributeViewer.getSelection();
        if (selection.isEmpty()) {
            this.attributeRemoveButton.setEnabled(false);
            this.attributeEditButton.setEnabled(false);
        } else {
            this.attributeRemoveButton.setEnabled(true);
            this.attributeEditButton.setEnabled(true);
        }
    }

    private void handleMappingTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.mappingViewer.getSelection();
        if (selection.isEmpty()) {
            this.mappingRemoveButton.setEnabled(false);
            this.mappingEditButton.setEnabled(false);
        } else {
            this.mappingRemoveButton.setEnabled(true);
            this.mappingEditButton.setEnabled(true);
        }
    }

    private class MappingContentProvider
    implements IStructuredContentProvider {
        private List<IMapping> actions;

        public MappingContentProvider(List<IMapping> actions) {
            this.actions = actions;
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return this.actions.toArray();
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private class OutputMapperContentProvider
    implements IStructuredContentProvider {
        private List<IOutputAttribute> actions;

        public OutputMapperContentProvider(List<IOutputAttribute> actions) {
            this.actions = actions;
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return this.actions.toArray();
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }
}

