/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.policies;

import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IInlineFlowState;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.ISubflowState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.DeleteActionCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.DeleteAttributeMapperCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.DeleteCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.DeleteExceptionHandlerCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.DeleteIfCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.DeleteStatePropertyCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.EditPropertiesCommand;

public class StateEditPolicy
extends ComponentEditPolicy {
    protected Command createDeleteCommand(GroupRequest deleteRequest) {
        if (this.getHost().getModel() instanceof IAttribute && this.getHost().getParent().getModel() instanceof IAttributeEnabled) {
            IAttributeEnabled parent = (IAttributeEnabled)this.getHost().getParent().getModel();
            DeleteStatePropertyCommand deleteCmd = new DeleteStatePropertyCommand();
            deleteCmd.setParent(parent);
            deleteCmd.setChild((IAttribute)this.getHost().getModel());
            return deleteCmd;
        }
        if (this.getHost().getModel() instanceof IAttributeMapper && this.getHost().getParent().getModel() instanceof ISubflowState) {
            ISubflowState parent = (ISubflowState)this.getHost().getParent().getModel();
            DeleteAttributeMapperCommand deleteCmd = new DeleteAttributeMapperCommand();
            deleteCmd.setParent(parent);
            deleteCmd.setChild((IAttributeMapper)this.getHost().getModel());
            return deleteCmd;
        }
        if (!(this.getHost().getParent().getModel() instanceof IAttributeMapper)) {
            if (this.getHost().getParent().getModel() instanceof IWebflowState || this.getHost().getParent().getModel() instanceof IInlineFlowState) {
                IWebflowModelElement parent = (IWebflowModelElement)this.getHost().getParent().getModel();
                DeleteCommand deleteCmd = new DeleteCommand();
                deleteCmd.setParent(parent);
                deleteCmd.setChild((IState)this.getHost().getModel());
                return deleteCmd;
            }
            if (this.getHost().getModel() instanceof IActionElement) {
                DeleteActionCommand deleteCmd = new DeleteActionCommand();
                deleteCmd.setChild((IActionElement)this.getHost().getModel());
                return deleteCmd;
            }
            if (this.getHost().getModel() instanceof IExceptionHandler) {
                DeleteExceptionHandlerCommand deleteCmd = new DeleteExceptionHandlerCommand();
                deleteCmd.setChild((IExceptionHandler)this.getHost().getModel());
                return deleteCmd;
            }
            if (this.getHost().getParent().getModel() instanceof IDecisionState && this.getHost().getModel() instanceof IIf) {
                IDecisionState parent = (IDecisionState)this.getHost().getParent().getModel();
                DeleteIfCommand deleteCmd = new DeleteIfCommand();
                deleteCmd.setParent(parent);
                deleteCmd.setChild((IIf)this.getHost().getModel());
                return deleteCmd;
            }
        }
        return null;
    }

    public Command getCommand(Request request) {
        if ("Start_state".equals(request.getType())) {
            return this.getSetAsStartStateCommand();
        }
        if ("Edit_propeties".equals(request.getType())) {
            return this.getEditPropertiesCommand();
        }
        return super.getCommand(request);
    }

    protected Command getSetAsStartStateCommand() {
        SetAsStartStateCommand command = new SetAsStartStateCommand();
        command.setChild((IState)this.getHost().getModel());
        return command;
    }

    protected Command getEditPropertiesCommand() {
        EditPropertiesCommand command = new EditPropertiesCommand();
        if (this.getHost().getModel() instanceof IAttributeMapper) {
            command.setChild((ICloneableModelElement<IWebflowModelElement>)((ICloneableModelElement)((IAttributeMapper)this.getHost().getModel()).getElementParent()));
        } else {
            command.setChild((ICloneableModelElement<IWebflowModelElement>)((ICloneableModelElement)this.getHost().getModel()));
        }
        return command;
    }

    static class SetAsStartStateCommand
    extends Command {
        IState child = null;
        IState oldChild = null;
        int index = -1;

        public SetAsStartStateCommand() {
            super("Set as start state");
        }

        public void setChild(IState child) {
            this.child = child;
        }

        public void execute() {
            if (this.child.getElementParent() instanceof IWebflowState) {
                IWebflowState state = (IWebflowState)this.child.getElementParent();
                this.oldChild = state.getStartState();
                this.index = state.getStates().indexOf(this.child);
                state.setStartState(this.child);
            }
        }

        public void undo() {
            if (this.child.getElementParent() instanceof IWebflowState) {
                IWebflowState state = (IWebflowState)this.child.getElementParent();
                state.setStartState(this.oldChild);
                state.moveState(this.child, this.index);
            }
        }

        public void redo() {
            this.execute();
        }
    }
}

