/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.lang.reflect.Modifier;
import java.util.Map;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceLocation;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeFieldBinding;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeMemberFinder;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeMethodBinding;
import org.aspectj.ajdt.internal.compiler.lookup.IntertypeMemberTypeFinder;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NewConstructorTypeMunger;
import org.aspectj.weaver.NewFieldTypeMunger;
import org.aspectj.weaver.NewMemberClassTypeMunger;
import org.aspectj.weaver.NewMethodTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

public class EclipseTypeMunger
extends ConcreteTypeMunger {
    private ResolvedType targetTypeX;
    public AbstractMethodDeclaration sourceMethod;
    private EclipseFactory world;
    private ISourceLocation sourceLocation;

    public EclipseTypeMunger(EclipseFactory world, ResolvedTypeMunger munger, ResolvedType aspectType, AbstractMethodDeclaration sourceMethod) {
        super(munger, aspectType);
        this.world = world;
        this.sourceMethod = sourceMethod;
        if (sourceMethod != null) {
            this.sourceLocation = new EclipseSourceLocation(sourceMethod.compilationResult, sourceMethod.sourceStart, sourceMethod.sourceEnd);
            munger.setSourceLocation(this.sourceLocation);
        }
        this.targetTypeX = munger.getDeclaringType().resolve(world.getWorld());
        if (this.targetTypeX.isParameterizedType() || this.targetTypeX.isRawType()) {
            this.targetTypeX = this.targetTypeX.getGenericType();
        }
    }

    public static boolean supportsKind(ResolvedTypeMunger.Kind kind) {
        return kind == ResolvedTypeMunger.Field || kind == ResolvedTypeMunger.Method || kind == ResolvedTypeMunger.Constructor || kind == ResolvedTypeMunger.InnerClass;
    }

    public String toString() {
        return "(EclipseTypeMunger " + this.getMunger() + ")";
    }

    public boolean munge(SourceTypeBinding sourceType, ResolvedType onType) {
        boolean isExactTargetType;
        ResolvedType rt = onType;
        if (rt.isRawType() || rt.isParameterizedType()) {
            rt = rt.getGenericType();
        }
        if (!(isExactTargetType = rt.equals((Object)this.targetTypeX))) {
            if (this.munger.getKind() != ResolvedTypeMunger.Method) {
                return false;
            }
            if (onType.isInterface()) {
                return false;
            }
            if (!this.munger.needsAccessToTopmostImplementor()) {
                return false;
            }
            if (!onType.isTopmostImplementor(this.targetTypeX)) {
                return false;
            }
            if (!Modifier.isPublic(this.munger.getSignature().getModifiers())) {
                return false;
            }
        }
        if (this.munger.getKind() == ResolvedTypeMunger.Field) {
            this.mungeNewField(sourceType, (NewFieldTypeMunger)this.munger);
        } else {
            if (this.munger.getKind() == ResolvedTypeMunger.Method) {
                return this.mungeNewMethod(sourceType, onType, (NewMethodTypeMunger)this.munger, isExactTargetType);
            }
            if (this.munger.getKind() == ResolvedTypeMunger.Constructor) {
                this.mungeNewConstructor(sourceType, (NewConstructorTypeMunger)this.munger);
            } else if (this.munger.getKind() == ResolvedTypeMunger.InnerClass) {
                this.mungeNewInnerClass(sourceType, onType, (NewMemberClassTypeMunger)this.munger, isExactTargetType);
            } else {
                throw new RuntimeException("unimplemented: " + this.munger.getKind());
            }
        }
        return true;
    }

    private boolean mungeNewMethod(SourceTypeBinding sourceType, ResolvedType onType, NewMethodTypeMunger munger, boolean isExactTargetType) {
        ResolvedMember existingMember;
        InterTypeMethodBinding binding = new InterTypeMethodBinding(this.world, (ResolvedTypeMunger)munger, (UnresolvedType)this.aspectType, this.sourceMethod);
        if (!isExactTargetType && (existingMember = onType.lookupMemberIncludingITDsOnInterfaces((Member)this.getSignature())) != null) {
            if (onType == existingMember.getDeclaringType() && Modifier.isFinal(munger.getSignature().getModifiers()) && !(sourceType instanceof BinaryTypeBinding)) {
                CompilationUnitScope cuScope = sourceType.scope.compilationUnitScope();
                MethodBinding offendingBinding = sourceType.getExactMethod(binding.selector, binding.parameters, cuScope);
                sourceType.scope.problemReporter().finalMethodCannotBeOverridden(offendingBinding, binding);
            }
            this.findOrCreateInterTypeMemberFinder(sourceType);
            return false;
        }
        if (sourceType.isInterface()) {
            boolean isAbstract = (binding.modifiers & 0x400) != 0;
            binding.modifiers &= 7;
            if (isAbstract) {
                binding.modifiers |= 0x400;
            }
        }
        if (munger.getSignature().isVarargsMethod()) {
            binding.modifiers |= 0x80;
        }
        this.findOrCreateInterTypeMemberFinder(sourceType).addInterTypeMethod(binding);
        return true;
    }

    private boolean mungeNewInnerClass(SourceTypeBinding sourceType, ResolvedType onType, NewMemberClassTypeMunger munger, boolean isExactTargetType) {
        SourceTypeBinding aspectTypeBinding = (SourceTypeBinding)this.world.makeTypeBinding((UnresolvedType)this.aspectType);
        char[] mungerMemberTypeName = ("$" + munger.getMemberTypeName()).toCharArray();
        ReferenceBinding innerTypeBinding = null;
        for (ReferenceBinding innerType : aspectTypeBinding.memberTypes) {
            char[] compounded = CharOperation.concatWith(innerType.compoundName, '.');
            if (!CharOperation.endsWith(compounded, mungerMemberTypeName)) continue;
            innerTypeBinding = innerType;
            break;
        }
        if (innerTypeBinding instanceof UnresolvedReferenceBinding) {
            innerTypeBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(innerTypeBinding, this.world.getLookupEnvironment(), true);
        }
        this.findOrCreateInterTypeMemberClassFinder(sourceType).addInterTypeMemberType(innerTypeBinding);
        return true;
    }

    private void mungeNewConstructor(SourceTypeBinding sourceType, NewConstructorTypeMunger munger) {
        if (this.shouldTreatAsPublic()) {
            int i;
            MethodBinding binding = this.world.makeMethodBinding(munger.getSignature(), munger.getTypeVariableAliases());
            this.findOrCreateInterTypeMemberFinder(sourceType).addInterTypeMethod(binding);
            TypeVariableBinding[] typeVariables = binding.typeVariables;
            for (i = 0; i < typeVariables.length; ++i) {
                TypeVariableBinding tv = typeVariables[i];
                String name = new String(tv.sourceName);
                TypeVariableBinding[] tv2 = this.sourceMethod.binding.typeVariables;
                for (int j = 0; j < tv2.length; ++j) {
                    if (!new String(tv2[j].sourceName).equals(name)) continue;
                    typeVariables[i].declaringElement = binding;
                }
            }
            for (i = 0; i < typeVariables.length; ++i) {
                if (typeVariables[i].declaringElement != null) continue;
                throw new RuntimeException("Declaring element not set");
            }
        } else {
            InterTypeMethodBinding binding = new InterTypeMethodBinding(this.world, (ResolvedTypeMunger)munger, (UnresolvedType)this.aspectType, this.sourceMethod);
            this.findOrCreateInterTypeMemberFinder(sourceType).addInterTypeMethod(binding);
        }
    }

    private void mungeNewField(SourceTypeBinding sourceType, NewFieldTypeMunger munger) {
        if (this.shouldTreatAsPublic() && !this.targetTypeX.isInterface()) {
            FieldBinding binding = this.world.makeFieldBinding(munger);
            this.findOrCreateInterTypeMemberFinder(sourceType).addInterTypeField(binding);
        } else {
            InterTypeFieldBinding binding = new InterTypeFieldBinding(this.world, (ResolvedTypeMunger)munger, (UnresolvedType)this.aspectType, this.sourceMethod);
            InterTypeMemberFinder finder = this.findOrCreateInterTypeMemberFinder(sourceType);
            if (finder.definesField(munger.getSignature().getName())) {
                munger.version = 1;
            }
            finder.addInterTypeField(binding);
        }
    }

    private boolean shouldTreatAsPublic() {
        return Modifier.isPublic(this.munger.getSignature().getModifiers());
    }

    private InterTypeMemberFinder findOrCreateInterTypeMemberFinder(SourceTypeBinding sourceType) {
        InterTypeMemberFinder finder = (InterTypeMemberFinder)sourceType.memberFinder;
        if (finder == null) {
            finder = new InterTypeMemberFinder();
            sourceType.memberFinder = finder;
            finder.sourceTypeBinding = sourceType;
        }
        return finder;
    }

    private IntertypeMemberTypeFinder findOrCreateInterTypeMemberClassFinder(SourceTypeBinding sourceType) {
        IntertypeMemberTypeFinder finder = (IntertypeMemberTypeFinder)sourceType.typeFinder;
        if (finder == null) {
            finder = new IntertypeMemberTypeFinder();
            sourceType.typeFinder = finder;
            finder.targetTypeBinding = sourceType;
            sourceType.tagBits &= 0xFFFFFFFFFFFEFFFFL;
        }
        return finder;
    }

    public ISourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(ISourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public AbstractMethodDeclaration getSourceMethod() {
        return this.sourceMethod;
    }

    public ConcreteTypeMunger parameterizedFor(ResolvedType target) {
        return new EclipseTypeMunger(this.world, this.munger.parameterizedFor(target), this.aspectType, this.sourceMethod);
    }

    public ConcreteTypeMunger parameterizeWith(Map m, World w) {
        return new EclipseTypeMunger(this.world, this.munger.parameterizeWith(m, w), this.aspectType, this.sourceMethod);
    }
}

