/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ajdt.ui.xref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.contribution.xref.core.IXReference;
import org.eclipse.contribution.xref.core.IXReferenceProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.springframework.ide.eclipse.ajdt.ui.xref.AopReferenceModelNode;
import org.springframework.ide.eclipse.ajdt.ui.xref.CrossReferenceViewPreferenceUtils;
import org.springframework.ide.eclipse.aop.core.Activator;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IAopReferenceModel;

public class AopReferenceModelReferenceProvider
implements IXReferenceProvider {
    private static final Class[] CLASSES = new Class[]{IJavaElement.class};

    public Class[] getClasses() {
        return CLASSES;
    }

    public IJavaElement[] getExtraChildren(IJavaElement je) {
        return null;
    }

    public void setCheckedFilters(List l) {
        CrossReferenceViewPreferenceUtils.setCheckedFilters(l);
    }

    public List getFilterCheckedList() {
        List<Object> checked = CrossReferenceViewPreferenceUtils.getFilterCheckedList();
        if (checked != null) {
            return checked;
        }
        return this.getFilterDefaultList();
    }

    public void setCheckedInplaceFilters(List l) {
        CrossReferenceViewPreferenceUtils.setCheckedInplaceFilters(l);
    }

    public List getFilterCheckedInplaceList() {
        List<Object> checked = CrossReferenceViewPreferenceUtils.getFilterCheckedInplaceList();
        if (checked != null) {
            return checked;
        }
        return this.getFilterDefaultList();
    }

    public List getFilterList() {
        ArrayList<String> populatingList = new ArrayList<String>();
        populatingList.add("advises");
        populatingList.add("advised by");
        populatingList.add("declared on");
        populatingList.add("aspect declarations");
        return populatingList;
    }

    public List getFilterDefaultList() {
        ArrayList defaultFilterList = new ArrayList();
        return defaultFilterList;
    }

    public String getProviderDescription() {
        return "Provides Spring crosscutting structure references";
    }

    public Collection<IXReference> getXReferences(Object o, List checkedRelNames) {
        if (!(o instanceof IJavaElement)) {
            return Collections.EMPTY_SET;
        }
        IJavaElement je = (IJavaElement)o;
        ArrayList<IXReference> xrefs = new ArrayList<IXReference>();
        IAopReferenceModel model = Activator.getModel();
        List references = model.getAllReferences();
        HashMap<IMember, XRef> refsAdvised = new HashMap<IMember, XRef>();
        HashMap<IMember, XRef> refsAdvises = new HashMap<IMember, XRef>();
        HashMap<IMember, XRef> refsDeclaredOn = new HashMap<IMember, XRef>();
        HashMap<IMember, XRef> refsAspectDeclarations = new HashMap<IMember, XRef>();
        for (IAopReference reference : references) {
            AopReferenceModelNode associate;
            XRef ref;
            if (reference.getAdviceType() != IAopReference.ADVICE_TYPE.DECLARE_PARENTS) {
                if (this.checkFilter(checkedRelNames, "advises") && reference.getSource() != null && reference.getSource().equals(je)) {
                    ref = null;
                    if (refsDeclaredOn.containsKey(reference.getSource())) {
                        ref = (XRef)refsDeclaredOn.get(reference.getSource());
                    } else {
                        ref = new XRef("advises", new HashSet<IAdaptable>());
                        refsDeclaredOn.put(reference.getSource(), ref);
                        xrefs.add(ref);
                    }
                    associate = new AopReferenceModelNode(AopReferenceModelNode.TYPE.TARGET, reference);
                    if (ref.getAssociatesList().contains(associate)) continue;
                    ref.getAssociatesList().add(associate);
                    continue;
                }
                if (!this.checkFilter(checkedRelNames, "advised by") || !reference.getTarget().equals(je)) continue;
                ref = null;
                if (refsAspectDeclarations.containsKey(reference.getTarget())) {
                    ref = (XRef)refsAspectDeclarations.get(reference.getTarget());
                } else {
                    ref = new XRef("advised by", new HashSet<IAdaptable>());
                    refsAspectDeclarations.put(reference.getTarget(), ref);
                    xrefs.add(ref);
                }
                associate = new AopReferenceModelNode(AopReferenceModelNode.TYPE.SOURCE, reference);
                if (ref.getAssociatesList().contains(associate)) continue;
                ref.getAssociatesList().add(associate);
                continue;
            }
            if (this.checkFilter(checkedRelNames, "declared on") && reference.getSource() != null && reference.getSource().equals(je)) {
                ref = null;
                if (refsAdvises.containsKey(reference.getSource())) {
                    ref = (XRef)refsAdvises.get(reference.getSource());
                } else {
                    ref = new XRef("declared on", new HashSet<IAdaptable>());
                    refsAdvises.put(reference.getSource(), ref);
                    xrefs.add(ref);
                }
                associate = new AopReferenceModelNode(AopReferenceModelNode.TYPE.TARGET, reference);
                if (ref.getAssociatesList().contains(associate)) continue;
                ref.getAssociatesList().add(associate);
                continue;
            }
            if (!this.checkFilter(checkedRelNames, "aspect declarations") || !reference.getTarget().equals(je) || reference.getSource() == null) continue;
            ref = null;
            if (refsAdvised.containsKey(reference.getTarget())) {
                ref = (XRef)refsAdvised.get(reference.getTarget());
            } else {
                ref = new XRef("aspect declarations", new HashSet<IAdaptable>());
                refsAdvised.put(reference.getTarget(), ref);
                xrefs.add(ref);
            }
            associate = new AopReferenceModelNode(AopReferenceModelNode.TYPE.SOURCE, reference);
            if (ref.getAssociatesList().contains(associate)) continue;
            ref.getAssociatesList().add(associate);
        }
        return xrefs;
    }

    private boolean checkFilter(List checkedRelNames, String relName) {
        return checkedRelNames == null || checkedRelNames != null && !checkedRelNames.contains(relName);
    }

    private static class XRef
    implements IXReference {
        private String name;
        private Set<IAdaptable> associates;

        public XRef(String name, Set<IAdaptable> associates) {
            this.name = name;
            this.associates = associates;
        }

        public String getName() {
            return this.name;
        }

        public Iterator<IAdaptable> getAssociates() {
            return this.associates.iterator();
        }

        public Set<IAdaptable> getAssociatesList() {
            return this.associates;
        }
    }
}

