/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinder;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.HoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.IPropertyHoverInfoProvider;
import org.springframework.ide.eclipse.boot.properties.editor.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.util.SpringPropertyIndexProvider;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.ast.NodeRef;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.ast.YamlASTProvider;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.ast.YamlFileAST;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.YamlAssistContext;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.path.YamlPath;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.path.YamlPathSegment;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.scanner.ScannerException;

public class YamlHoverInfoProvider
implements IPropertyHoverInfoProvider {
    private YamlASTProvider astProvider;
    private SpringPropertyIndexProvider indexProvider;
    private DocumentContextFinder contextFinder;

    public YamlHoverInfoProvider(YamlASTProvider astProvider, SpringPropertyIndexProvider indexProvider, DocumentContextFinder contextFinder) {
        this.astProvider = astProvider;
        this.indexProvider = indexProvider;
        this.contextFinder = contextFinder;
    }

    public HoverInfo getHoverInfo(IDocument doc, IRegion r) {
        YamlFileAST ast = this.getAst(doc);
        if (ast != null) {
            List<NodeRef<?>> astPath;
            YamlPath path;
            IJavaProject jp = this.contextFinder.getJavaProject(doc);
            FuzzyMap index = this.indexProvider.getIndex(doc);
            if (index != null && (path = YamlPath.fromASTPath(astPath = ast.findPath(r.getOffset()))) != null) {
                YamlAssistContext assistContext;
                if (path.pointsAtKey()) {
                    String key = path.getLastSegment().toPropString();
                    path = path.dropLast().append(YamlPathSegment.valueAt(key));
                }
                if ((assistContext = YamlAssistContext.forPath(path, (FuzzyMap<PropertyInfo>)index, null, new TypeUtil(jp))) != null) {
                    return assistContext.getHoverInfo();
                }
            }
        }
        return null;
    }

    public IRegion getHoverRegion(IDocument document, int offset) {
        Node n;
        YamlFileAST ast = this.getAst(document);
        if (ast != null && (n = ast.findNode(offset)) != null && n.getNodeId() == NodeId.scalar) {
            int start = n.getStartMark().getIndex();
            int end = n.getEndMark().getIndex();
            return new Region(start, end - start);
        }
        return null;
    }

    private YamlFileAST getAst(IDocument doc) {
        try {
            return this.astProvider.getAST(doc);
        }
        catch (ParserException parserException) {
        }
        catch (ScannerException scannerException) {}
        return null;
    }
}

