/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.completions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.HoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertyHoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.completions.DocumentEdits;
import org.springframework.ide.eclipse.boot.properties.editor.completions.LazyProposalApplier;
import org.springframework.ide.eclipse.boot.properties.editor.completions.PropertyCompletionFactory;
import org.springframework.ide.eclipse.boot.properties.editor.completions.ProposalApplier;
import org.springframework.ide.eclipse.boot.properties.editor.completions.TypeNavigationHoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.util.FuzzyMatcher;
import org.springframework.ide.eclipse.boot.properties.editor.util.PrefixFinder;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeParser;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypedProperty;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.YamlDocument;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.YamlPathEdits;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.path.YamlPath;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.path.YamlPathSegment;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile.IndexNavigator;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.structure.YamlStructureParser;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.utils.CollectionUtil;

public abstract class YamlAssistContext {
    private boolean preferLowerCasedEnums = true;
    protected int documentSelector;
    protected final YamlPath contextPath;
    protected final TypeUtil typeUtil;
    private static PrefixFinder prefixfinder = new PrefixFinder(){

        protected boolean isPrefixChar(char c) {
            return !Character.isWhitespace(c) && c != ':';
        }
    };

    public YamlAssistContext(int documentSelector, YamlPath contextPath, TypeUtil typeUtil) {
        this.documentSelector = documentSelector;
        this.contextPath = contextPath;
        this.typeUtil = typeUtil;
    }

    protected String appendTextFor(Type type) {
        if (TypeUtil.isMap((Type)type)) {
            return "\n";
        }
        if (TypeUtil.isSequencable((Type)type)) {
            return "\n- ";
        }
        if (this.typeUtil.isAtomic(type)) {
            return " ";
        }
        return "\n";
    }

    protected abstract Type getType();

    public abstract Collection<ICompletionProposal> getCompletions(YamlDocument var1, int var2) throws Exception;

    public static YamlAssistContext global(int documentSelector, FuzzyMap<PropertyInfo> index, PropertyCompletionFactory completionFactory, TypeUtil typeUtil) {
        return new IndexContext(documentSelector, YamlPath.EMPTY, IndexNavigator.with(index), completionFactory, typeUtil);
    }

    public static YamlAssistContext forPath(YamlPath contextPath, FuzzyMap<PropertyInfo> index, PropertyCompletionFactory completionFactory, TypeUtil typeUtil) {
        YamlPathSegment documentSelector = contextPath.getSegment(0);
        if (documentSelector != null) {
            contextPath = contextPath.dropFirst(1);
            YamlAssistContext context = YamlAssistContext.global(documentSelector.toIndex(), index, completionFactory, typeUtil);
            YamlPathSegment[] yamlPathSegmentArray = contextPath.getSegments();
            int n = yamlPathSegmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                YamlPathSegment s = yamlPathSegmentArray[n2];
                if (context == null) {
                    return null;
                }
                context = context.navigate(s);
                ++n2;
            }
            return context;
        }
        return null;
    }

    protected abstract YamlAssistContext navigate(YamlPathSegment var1);

    private static void deleteQueryAndLine(YamlDocument doc, String query, int queryOffset, YamlPathEdits edits) throws Exception {
        edits.delete(queryOffset, query);
        String wholeLine = doc.getLineTextAtOffset(queryOffset);
        if (wholeLine.trim().equals(query.trim())) {
            edits.deleteLineBackwardAtOffset(queryOffset);
        }
    }

    public abstract HoverInfo getHoverInfo();

    protected YamlStructureParser.SNode getContextNode(YamlDocument file) throws Exception {
        return this.contextPath.traverse(this.getContextRoot(file));
    }

    protected YamlStructureParser.SDocNode getContextRoot(YamlDocument file) throws Exception {
        YamlStructureParser.SRootNode root = file.getStructure();
        return (YamlStructureParser.SDocNode)root.getChildren().get(this.documentSelector);
    }

    private static class IndexContext
    extends YamlAssistContext {
        private IndexNavigator indexNav;
        PropertyCompletionFactory completionFactory;

        public IndexContext(int documentSelector, YamlPath contextPath, IndexNavigator indexNav, PropertyCompletionFactory completionFactory, TypeUtil typeUtil) {
            super(documentSelector, contextPath, typeUtil);
            this.indexNav = indexNav;
            this.completionFactory = completionFactory;
        }

        @Override
        public Collection<ICompletionProposal> getCompletions(YamlDocument doc, int offset) throws Exception {
            String query = prefixfinder.getPrefix(doc.getDocument(), offset);
            List<FuzzyMap.Match<PropertyInfo>> matchingProps = this.indexNav.findMatching(query);
            if (!matchingProps.isEmpty()) {
                ArrayList<ICompletionProposal> completions = new ArrayList<ICompletionProposal>();
                for (FuzzyMap.Match match : matchingProps) {
                    ProposalApplier edits = this.createEdits(doc, offset, query, (FuzzyMap.Match<PropertyInfo>)match);
                    PropertyCompletionFactory.ScoreableProposal completion = this.completionFactory.property(doc.getDocument(), edits, match, this.typeUtil);
                    if (this.getContextRoot(doc).exists(YamlPath.fromProperty(((PropertyInfo)match.data).getId()))) {
                        completion.deemphasize();
                    }
                    completions.add((ICompletionProposal)completion);
                }
                return completions;
            }
            return Collections.emptyList();
        }

        protected ProposalApplier createEdits(final YamlDocument file, final int offset, final String query, final FuzzyMap.Match<PropertyInfo> match) throws Exception {
            return new LazyProposalApplier(){

                protected ProposalApplier create() throws Exception {
                    YamlPathEdits edits = new YamlPathEdits(file);
                    int queryOffset = offset - query.length();
                    edits.delete(queryOffset, query);
                    YamlPath propertyPath = YamlPath.fromProperty(((PropertyInfo)match.data).getId());
                    YamlPath relativePath = propertyPath.dropFirst(IndexContext.this.contextPath.size());
                    YamlPathSegment nextSegment = relativePath.getSegment(0);
                    YamlStructureParser.SNode contextNode = IndexContext.this.getContextNode(file);
                    YamlStructureParser.SNode existingNode = contextNode.traverse(nextSegment);
                    String appendText = IndexContext.this.appendTextFor(TypeParser.parse((String)((PropertyInfo)match.data).getType()));
                    if (existingNode == null) {
                        edits.createPathInPlace(contextNode, relativePath, queryOffset, appendText);
                    } else {
                        String wholeLine = file.getLineTextAtOffset(queryOffset);
                        if (wholeLine.trim().equals(query.trim())) {
                            edits.deleteLineBackwardAtOffset(queryOffset);
                        }
                        edits.createPath(IndexContext.this.getContextRoot(file), YamlPath.fromProperty(((PropertyInfo)match.data).getId()), appendText);
                    }
                    return edits;
                }
            };
        }

        @Override
        protected YamlAssistContext navigate(YamlPathSegment s) {
            if (s.getType() == YamlPathSegment.YamlPathSegmentType.VAL_AT_KEY) {
                IndexNavigator subIndex = this.indexNav.selectSubProperty(s.toPropString());
                if (subIndex.getExtensionCandidate() != null) {
                    return new IndexContext(this.documentSelector, this.contextPath.append(s), subIndex, this.completionFactory, this.typeUtil);
                }
                if (subIndex.getExactMatch() != null) {
                    IndexContext asIndexContext = new IndexContext(this.documentSelector, this.contextPath.append(s), subIndex, this.completionFactory, this.typeUtil);
                    PropertyInfo prop = subIndex.getExactMatch();
                    return new TypeContext(asIndexContext, this.contextPath.append(s), TypeParser.parse((String)prop.getType()), this.completionFactory, this.typeUtil);
                }
            }
            return null;
        }

        public String toString() {
            return "YamlAssistIndexContext(" + this.indexNav + ")";
        }

        @Override
        protected Type getType() {
            PropertyInfo match = this.indexNav.getExactMatch();
            if (match != null) {
                return TypeParser.parse((String)match.getType());
            }
            return null;
        }

        @Override
        public HoverInfo getHoverInfo() {
            PropertyInfo prop = this.indexNav.getExactMatch();
            if (prop != null) {
                return new SpringPropertyHoverInfo(this.typeUtil.getJavaProject(), prop);
            }
            return null;
        }
    }

    public class TypeContext
    extends YamlAssistContext {
        private PropertyCompletionFactory completionFactory;
        private Type type;
        private YamlAssistContext parent;

        public TypeContext(YamlAssistContext parent, YamlPath contextPath, Type type, PropertyCompletionFactory completionFactory, TypeUtil typeUtil) {
            super(parent.documentSelector, contextPath, typeUtil);
            this.parent = parent;
            this.completionFactory = completionFactory;
            this.type = type;
        }

        @Override
        public Collection<ICompletionProposal> getCompletions(YamlDocument doc, int offset) throws Exception {
            TypeUtil.EnumCaseMode enumCaseMode;
            String query = prefixfinder.getPrefix(doc.getDocument(), offset);
            List<ICompletionProposal> valueCompletions = this.getValueCompletions(doc, offset, query, enumCaseMode = this.enumCaseMode(query));
            if (!valueCompletions.isEmpty()) {
                return valueCompletions;
            }
            return this.getKeyCompletions(doc, offset, query, enumCaseMode);
        }

        private TypeUtil.EnumCaseMode enumCaseMode(String query) {
            if (query.isEmpty()) {
                return YamlAssistContext.this.preferLowerCasedEnums ? TypeUtil.EnumCaseMode.LOWER_CASE : TypeUtil.EnumCaseMode.ORIGNAL;
            }
            return TypeUtil.EnumCaseMode.ALIASED;
        }

        public List<ICompletionProposal> getKeyCompletions(YamlDocument doc, int offset, String query, TypeUtil.EnumCaseMode enumCaseMode) throws Exception {
            int queryOffset = offset - query.length();
            List properties = this.typeUtil.getProperties(this.type, enumCaseMode);
            if (CollectionUtil.hasElements(properties)) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>(properties.size());
                YamlStructureParser.SNode contextNode = this.getContextNode(doc);
                Set<String> definedProps = this.getDefinedProperties(contextNode);
                for (TypedProperty p : properties) {
                    String name = p.getName();
                    double score = FuzzyMatcher.matchScore((String)query, (String)name);
                    if (score == 0.0) continue;
                    YamlPath relativePath = YamlPath.fromSimpleProperty(name);
                    YamlPathEdits edits = new YamlPathEdits(doc);
                    if (!definedProps.contains(name)) {
                        Type type = p.getType();
                        edits.delete(queryOffset, query);
                        edits.createPathInPlace(contextNode, relativePath, queryOffset, this.appendTextFor(type));
                        proposals.add((ICompletionProposal)this.completionFactory.beanProperty(doc.getDocument(), this.contextPath.toPropString(), this.getType(), query, p, score, (ProposalApplier)edits, this.typeUtil));
                        continue;
                    }
                    YamlAssistContext.deleteQueryAndLine(doc, query, queryOffset, edits);
                    edits.createPath((YamlStructureParser.SChildBearingNode)contextNode, relativePath, "");
                    proposals.add((ICompletionProposal)this.completionFactory.beanProperty(doc.getDocument(), this.contextPath.toPropString(), this.getType(), query, p, score, (ProposalApplier)edits, this.typeUtil).deemphasize());
                }
                return proposals;
            }
            return Collections.emptyList();
        }

        private Set<String> getDefinedProperties(YamlStructureParser.SNode contextNode) {
            try {
                List<YamlStructureParser.SNode> children;
                if (contextNode instanceof YamlStructureParser.SChildBearingNode && CollectionUtil.hasElements(children = ((YamlStructureParser.SChildBearingNode)contextNode).getChildren())) {
                    HashSet<String> keys = new HashSet<String>(children.size());
                    for (YamlStructureParser.SNode c : children) {
                        if (!(c instanceof YamlStructureParser.SKeyNode)) continue;
                        keys.add(((YamlStructureParser.SKeyNode)c).getKey());
                    }
                    return keys;
                }
            }
            catch (Exception e) {
                BootActivator.log((Throwable)e);
            }
            return Collections.emptySet();
        }

        private List<ICompletionProposal> getValueCompletions(YamlDocument doc, int offset, String query, TypeUtil.EnumCaseMode enumCaseMode) {
            String[] values = this.typeUtil.getAllowedValues(this.type, enumCaseMode);
            if (values != null) {
                ArrayList<ICompletionProposal> completions = new ArrayList<ICompletionProposal>();
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    double score = FuzzyMatcher.matchScore((String)query, (String)value);
                    if (score != 0.0 && !value.equals(query)) {
                        DocumentEdits edits = new DocumentEdits(doc.getDocument());
                        edits.delete(offset - query.length(), offset);
                        edits.insert(offset, value);
                        completions.add((ICompletionProposal)this.completionFactory.valueProposal(value, this.type, score, (ProposalApplier)edits));
                    }
                    ++n2;
                }
                return completions;
            }
            return Collections.emptyList();
        }

        @Override
        protected YamlAssistContext navigate(YamlPathSegment s) {
            if (s.getType() == YamlPathSegment.YamlPathSegmentType.VAL_AT_KEY) {
                if (TypeUtil.isSequencable((Type)this.type) || TypeUtil.isMap((Type)this.type)) {
                    return this.contextWith(s, TypeUtil.getDomainType((Type)this.type));
                }
                String key = s.toPropString();
                Map subproperties = this.typeUtil.getPropertiesMap(this.type, TypeUtil.EnumCaseMode.ALIASED);
                if (subproperties != null) {
                    return this.contextWith(s, (Type)subproperties.get(key));
                }
            } else if (s.getType() == YamlPathSegment.YamlPathSegmentType.VAL_AT_INDEX && TypeUtil.isSequencable((Type)this.type)) {
                return this.contextWith(s, TypeUtil.getDomainType((Type)this.type));
            }
            return null;
        }

        private YamlAssistContext contextWith(YamlPathSegment s, Type nextType) {
            if (nextType != null) {
                return new TypeContext(this, this.contextPath.append(s), nextType, this.completionFactory, this.typeUtil);
            }
            return null;
        }

        public String toString() {
            return "TypeContext(" + this.contextPath.toPropString() + "::" + this.type + ")";
        }

        @Override
        public HoverInfo getHoverInfo() {
            if (this.parent instanceof IndexContext) {
                return this.parent.getHoverInfo();
            }
            return new TypeNavigationHoverInfo(this.contextPath.toPropString(), this.contextPath.getBeanPropertyName(), this.parent.getType(), this.getType(), this.typeUtil);
        }

        @Override
        protected Type getType() {
            return this.type;
        }
    }
}

