/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.completions;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinder;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.ICompletionEngine;
import org.springframework.ide.eclipse.boot.properties.editor.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.completions.PropertyCompletionFactory;
import org.springframework.ide.eclipse.boot.properties.editor.util.SpringPropertyIndexProvider;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtilProvider;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.IndentUtil;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.YamlAssistContext;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.YamlDocument;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.path.YamlPath;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.structure.YamlStructureParser;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.structure.YamlStructureProvider;
import org.yaml.snakeyaml.Yaml;

public class YamlCompletionEngine
implements ICompletionEngine {
    private SpringPropertyIndexProvider indexProvider;
    private DocumentContextFinder contextFinder;
    private YamlStructureProvider structureProvider;
    private PropertyCompletionFactory completionFactory;
    private TypeUtilProvider typeUtilProvider;

    public YamlCompletionEngine(Yaml yaml, SpringPropertyIndexProvider indexProvider, DocumentContextFinder documentContextFinder, YamlStructureProvider structureProvider, TypeUtilProvider typeUtilProvider) {
        this.indexProvider = indexProvider;
        this.contextFinder = documentContextFinder;
        this.structureProvider = structureProvider;
        this.completionFactory = new PropertyCompletionFactory(this.contextFinder);
        this.typeUtilProvider = typeUtilProvider;
    }

    public Collection<ICompletionProposal> getCompletions(IDocument _doc, int offset) throws Exception {
        YamlStructureParser.SRootNode root;
        YamlStructureParser.SNode current;
        YamlAssistContext context;
        FuzzyMap index;
        YamlDocument doc = new YamlDocument(_doc, this.structureProvider);
        if (!doc.isCommented(offset) && (index = this.indexProvider.getIndex(doc.getDocument())) != null && !index.isEmpty() && (context = this.getContext(doc, current = (root = doc.getStructure()).find(offset), offset, (FuzzyMap<PropertyInfo>)index)) != null) {
            return context.getCompletions(doc, offset);
        }
        return Collections.emptyList();
    }

    private YamlAssistContext getContext(YamlDocument doc, YamlStructureParser.SNode node, int offset, FuzzyMap<PropertyInfo> index) throws Exception {
        TypeUtil typeUtil = this.typeUtilProvider.getTypeUtil(doc.getDocument());
        if (node == null) {
            return YamlAssistContext.forPath(YamlPath.EMPTY, index, this.completionFactory, typeUtil);
        }
        if (node.getNodeType() == YamlStructureParser.SNodeType.KEY) {
            YamlStructureParser.SKeyNode keyNode = (YamlStructureParser.SKeyNode)node;
            if (keyNode.isInValue(offset)) {
                return YamlAssistContext.forPath(keyNode.getPath(), index, this.completionFactory, typeUtil);
            }
            return YamlAssistContext.forPath(keyNode.getParent().getPath(), index, this.completionFactory, typeUtil);
        }
        if (node.getNodeType() == YamlStructureParser.SNodeType.RAW) {
            int cursorIndent = doc.getColumn(offset);
            int nodeIndent = node.getIndent();
            int currentIndent = IndentUtil.minIndent(cursorIndent, nodeIndent);
            while (node.getIndent() == -1 || node.getIndent() >= currentIndent && node.getNodeType() != YamlStructureParser.SNodeType.DOC) {
                node = node.getParent();
            }
            return YamlAssistContext.forPath(node.getPath(), index, this.completionFactory, typeUtil);
        }
        if (node.getNodeType() == YamlStructureParser.SNodeType.SEQ) {
            YamlStructureParser.SSeqNode seqNode = (YamlStructureParser.SSeqNode)node;
            if (seqNode.isInValue(offset)) {
                return YamlAssistContext.forPath(seqNode.getPath(), index, this.completionFactory, typeUtil);
            }
            return YamlAssistContext.forPath(seqNode.getParent().getPath(), index, this.completionFactory, typeUtil);
        }
        if (node.getNodeType() == YamlStructureParser.SNodeType.DOC) {
            return YamlAssistContext.forPath(node.getPath(), index, this.completionFactory, typeUtil);
        }
        throw new IllegalStateException("Missing case");
    }
}

