/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.IReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyProblem;

public class BadWordReconcileEngine
implements IReconcileEngine {
    private final String[] BADWORDS = new String[]{"bar", "foo"};

    public void reconcile(IDocument doc, SpringPropertiesReconcileEngine.IProblemCollector problemCollector, IProgressMonitor mon) {
        String text = doc.get();
        System.out.println(">>>> reconciling for bad words ==========");
        System.out.println(text);
        System.out.println("<<<< reconciling for bad words ==========");
        problemCollector.beginCollecting();
        try {
            String[] stringArray = this.BADWORDS;
            int n = this.BADWORDS.length;
            int n2 = 0;
            while (n2 < n) {
                String badword = stringArray[n2];
                int pos = 0;
                while (pos >= 0 && pos < text.length()) {
                    int badPos = text.indexOf(badword, pos);
                    if (badPos >= 0) {
                        if (badword.equals(this.BADWORDS[0])) {
                            problemCollector.accept(SpringPropertyProblem.error((String)("'" + badword + "' is a bad word"), (int)badPos, (int)badword.length()));
                        } else {
                            problemCollector.accept(SpringPropertyProblem.warning((String)("'" + badword + "' is a bad word"), (int)badPos, (int)badword.length()));
                        }
                        pos = badPos + 1;
                        continue;
                    }
                    pos = badPos;
                }
                ++n2;
            }
        }
        finally {
            problemCollector.endCollecting();
        }
    }
}

