/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.bamboo;

import com.atlassian.connector.commons.api.BambooServerFacade2;
import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.theplugin.commons.ServerType;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BambooBuildInfo;
import com.atlassian.theplugin.commons.bamboo.BambooPlan;
import com.atlassian.theplugin.commons.bamboo.BambooProject;
import com.atlassian.theplugin.commons.bamboo.BambooSessionFactory;
import com.atlassian.theplugin.commons.bamboo.BuildDetails;
import com.atlassian.theplugin.commons.bamboo.BuildIssue;
import com.atlassian.theplugin.commons.bamboo.BuildStatus;
import com.atlassian.theplugin.commons.bamboo.api.AutoRenewBambooSession;
import com.atlassian.theplugin.commons.bamboo.api.BambooSession;
import com.atlassian.theplugin.commons.bamboo.api.BambooSessionImpl;
import com.atlassian.theplugin.commons.bamboo.api.LoginBambooSession;
import com.atlassian.theplugin.commons.cfg.SubscribedPlan;
import com.atlassian.theplugin.commons.exception.ServerPasswordNotProvidedException;
import com.atlassian.theplugin.commons.remoteapi.ProductSession;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiLoginException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiLoginFailedException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiMalformedUrlException;
import com.atlassian.theplugin.commons.remoteapi.rest.HttpSessionCallback;
import com.atlassian.theplugin.commons.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public final class BambooServerFacadeImpl
implements BambooServerFacade2 {
    private final Map<String, BambooSession> sessions = new WeakHashMap<String, BambooSession>();
    private final Logger logger;
    private final BambooSessionFactory bambooSessionFactory;
    private final HttpSessionCallback callback;

    public BambooServerFacadeImpl(Logger loger, @NotNull BambooSessionFactory factory, @NotNull HttpSessionCallback callback) {
        this.logger = loger;
        this.callback = callback;
        this.bambooSessionFactory = factory;
    }

    public BambooServerFacadeImpl(Logger loger, HttpSessionCallback callback) {
        this(loger, new SimpleBambooSessionFactory(loger), callback);
    }

    @Override
    public ServerType getServerType() {
        return ServerType.BAMBOO_SERVER;
    }

    @Override
    public synchronized BambooSession getSession(ConnectionCfg server) throws RemoteApiException {
        String key = String.valueOf(server.getUsername()) + server.getUrl() + server.getPassword() + server.getId();
        BambooSession session = this.sessions.get(key);
        if (session == null) {
            session = this.bambooSessionFactory.createSession(server, this.callback);
            this.sessions.put(key, session);
        }
        if (!session.isLoggedIn()) {
            session.login(server.getUsername(), server.getPassword().toCharArray());
        }
        return session;
    }

    @Override
    public void testServerConnection(ConnectionCfg httpConnectionCfg) throws RemoteApiException {
        ProductSession apiHandler = this.bambooSessionFactory.createLoginSession(httpConnectionCfg, this.callback);
        apiHandler.login(httpConnectionCfg.getUsername(), httpConnectionCfg.getPassword().toCharArray());
        apiHandler.logout();
    }

    @Override
    public Collection<BambooProject> getProjectList(ConnectionCfg bambooServer) throws ServerPasswordNotProvidedException, RemoteApiException {
        try {
            return this.getSession(bambooServer).listProjectNames();
        }
        catch (RemoteApiException e) {
            this.logger.error("Bamboo exception: " + e.getMessage(), e);
            throw e;
        }
    }

    @Override
    public Collection<BambooPlan> getPlanList(ConnectionCfg bambooServer) throws ServerPasswordNotProvidedException, RemoteApiException {
        BambooSession api = this.getSession(bambooServer);
        return api.getPlanList();
    }

    /*
     * Unable to fully structure code
     */
    Collection<BambooBuild> getSubscribedPlansResultsOld(ConnectionCfg bambooServer, Collection<SubscribedPlan> plans, boolean isUseFavourities, int timezoneOffset) throws ServerPasswordNotProvidedException, RemoteApiException {
        block6: {
            block7: {
                builds = new ArrayList<BambooBuild>();
                api = null;
                try {
                    api = this.getSession(bambooServer);
                    connectionError = null;
                    break block6;
                }
                catch (RemoteApiLoginFailedException e) {
                    if (bambooServer.getPassword().length() > 0) {
                        this.logger.error("Bamboo login exception: " + e.getMessage());
                        connectionError = e;
                        throw e;
                    }
                    throw new ServerPasswordNotProvidedException(e);
                }
                catch (RemoteApiLoginException e) {
                    throw e;
                }
                catch (RemoteApiException e) {
                    this.logger.error("Bamboo exception: " + e.getMessage());
                    connectionError = e;
                    if (isUseFavourities) break block7;
                    ** for (plan : plans)
                }
lbl-1000:
                // 1 sources

                {
                    builds.add(this.constructBuildErrorInfo(bambooServer, plan.getKey(), null, connectionError == null ? "" : connectionError.getMessage(), connectionError));
                    continue;
                }
            }
            return builds;
        }
        return api.getSubscribedPlansResults(plans, isUseFavourities, timezoneOffset);
    }

    @Override
    public Collection<BambooBuild> getSubscribedPlansResults(ConnectionCfg connectionCfg, Collection<SubscribedPlan> plans, boolean isUseFavourities, boolean isShowBranches, boolean myBranchesOnly, int timezoneOffset) throws ServerPasswordNotProvidedException, RemoteApiException {
        BambooSession session = this.getSession(connectionCfg);
        if (session.getBamboBuildNumber() >= 1401) {
            return this.getSubscribedPlansResultsNew(connectionCfg, plans, isUseFavourities, isShowBranches && session.getBamboBuildNumber() >= 3600, myBranchesOnly, timezoneOffset);
        }
        return this.getSubscribedPlansResultsOld(connectionCfg, plans, isUseFavourities, timezoneOffset);
    }

    Collection<BambooBuild> getSubscribedPlansResultsNew(ConnectionCfg bambooServer, Collection<SubscribedPlan> plans, boolean isUseFavourities, boolean isShowBranches, boolean myBranchesOnly, int timezoneOffset) throws ServerPasswordNotProvidedException, RemoteApiLoginException {
        ArrayList<BambooBuild> builds;
        block20: {
            Collection<BambooPlan> plansForServer;
            RemoteApiException connectionError;
            BambooSession api;
            block19: {
                builds = new ArrayList<BambooBuild>();
                api = null;
                try {
                    api = this.getSession(bambooServer);
                    connectionError = null;
                }
                catch (RemoteApiLoginFailedException e) {
                    if (bambooServer.getPassword().length() > 0) {
                        this.logger.error("Bamboo login exception: " + e.getMessage());
                        RemoteApiLoginFailedException connectionError2 = e;
                        throw e;
                    }
                    throw new ServerPasswordNotProvidedException(e);
                }
                catch (RemoteApiLoginException e) {
                    throw e;
                }
                catch (RemoteApiException e) {
                    this.logger.error("Bamboo exception: " + e.getMessage());
                    connectionError = e;
                }
                plansForServer = null;
                try {
                    plansForServer = this.getPlanList(bambooServer);
                }
                catch (RemoteApiException remoteApiException) {
                    this.logger.warn("Cannot fetch plan list from Bamboo server [" + bambooServer.getUrl() + "]");
                }
                if (!isUseFavourities) break block19;
                if (plansForServer == null) break block20;
                for (BambooPlan bambooPlan : plansForServer) {
                    if (!bambooPlan.isFavourite()) continue;
                    String key = bambooPlan.getKey();
                    if (api != null && api.isLoggedIn()) {
                        try {
                            if (isShowBranches) {
                                Collection<String> branches = api.getBranchKeys(key, isUseFavourities, myBranchesOnly);
                                branches.add(key);
                                Iterator<String> iterator = branches.iterator();
                                while (iterator.hasNext()) {
                                    String branch;
                                    BambooBuild buildInfo = api.getLatestBuildForPlanNew(branch, key.equals(branch = iterator.next()) ? null : key, bambooPlan.isEnabled(), timezoneOffset);
                                    builds.add(buildInfo);
                                }
                                continue;
                            }
                            BambooBuild buildInfo = api.getLatestBuildForPlanNew(key, null, bambooPlan.isEnabled(), timezoneOffset);
                            builds.add(buildInfo);
                        }
                        catch (RemoteApiException remoteApiException) {
                            this.logger.warn("Cannot fetch latest build for plan [" + key + "] from Bamboo server [" + bambooServer.getUrl() + "]");
                        }
                        continue;
                    }
                    builds.add(this.constructBuildErrorInfo(bambooServer, key, bambooPlan.getName(), connectionError == null ? "" : connectionError.getMessage(), connectionError));
                }
                break block20;
            }
            for (SubscribedPlan plan : plans) {
                String key = plan.getKey();
                if (api != null && api.isLoggedIn()) {
                    try {
                        Boolean planEnabled;
                        Boolean bl = planEnabled = plansForServer != null ? BambooSessionImpl.isPlanEnabled(plansForServer, key) : null;
                        if (isShowBranches) {
                            Collection<String> branches = api.getBranchKeys(key, isUseFavourities, myBranchesOnly);
                            branches.add(key);
                            Iterator<String> iterator = branches.iterator();
                            while (iterator.hasNext()) {
                                String branch;
                                BambooBuild buildInfo = api.getLatestBuildForPlanNew(branch, key.equals(branch = iterator.next()) ? null : key, planEnabled != null && planEnabled != false, timezoneOffset);
                                builds.add(buildInfo);
                            }
                            continue;
                        }
                        BambooBuild buildInfo = api.getLatestBuildForPlanNew(key, null, planEnabled != null && planEnabled != false, timezoneOffset);
                        builds.add(buildInfo);
                    }
                    catch (RemoteApiException remoteApiException) {
                        this.logger.warn("Cannot fetch latest build for plan [" + key + "] from Bamboo server [" + bambooServer.getUrl() + "]");
                    }
                    continue;
                }
                builds.add(this.constructBuildErrorInfo(bambooServer, key, null, connectionError == null ? "" : connectionError.getMessage(), connectionError));
            }
        }
        return builds;
    }

    @Override
    public Collection<BambooBuild> getRecentBuildsForPlans(ConnectionCfg bambooServer, String planKey, int timezoneOffset) throws ServerPasswordNotProvidedException {
        BambooSession api;
        ArrayList<BambooBuild> builds = new ArrayList<BambooBuild>();
        try {
            api = this.getSession(bambooServer);
        }
        catch (RemoteApiLoginFailedException e) {
            if (bambooServer.getPassword().length() > 0) {
                this.logger.error("Bamboo login exception: " + e.getMessage());
                builds.add(this.constructBuildErrorInfo(bambooServer, planKey, null, e.getMessage(), e));
                return builds;
            }
            throw new ServerPasswordNotProvidedException(e);
        }
        catch (RemoteApiException e) {
            this.logger.error("Bamboo exception: " + e.getMessage());
            builds.add(this.constructBuildErrorInfo(bambooServer, planKey, null, e.getMessage(), e));
            return builds;
        }
        try {
            builds.addAll(api.getRecentBuildsForPlan(planKey, timezoneOffset));
        }
        catch (RemoteApiException e) {
            this.logger.error("Bamboo exception: " + e.getMessage());
            builds.add(this.constructBuildErrorInfo(bambooServer, planKey, null, e.getMessage(), e));
        }
        return builds;
    }

    @Override
    public Collection<BambooBuild> getRecentBuildsForUser(ConnectionCfg bambooServer, int timezoneOffset) throws ServerPasswordNotProvidedException {
        BambooSession api;
        ArrayList<BambooBuild> builds = new ArrayList<BambooBuild>();
        try {
            api = this.getSession(bambooServer);
        }
        catch (RemoteApiLoginFailedException e) {
            if (bambooServer.getPassword().length() > 0) {
                this.logger.error("Bamboo login exception: " + e.getMessage());
                builds.add(this.constructBuildErrorInfo(bambooServer, "", null, e.getMessage(), e));
                return builds;
            }
            throw new ServerPasswordNotProvidedException(e);
        }
        catch (RemoteApiException e) {
            this.logger.error("Bamboo exception: " + e.getMessage());
            builds.add(this.constructBuildErrorInfo(bambooServer, "", null, e.getMessage(), e));
            return builds;
        }
        try {
            builds.addAll(api.getRecentBuildsForUser(timezoneOffset));
        }
        catch (RemoteApiException e) {
            this.logger.error("Bamboo exception: " + e.getMessage());
            builds.add(this.constructBuildErrorInfo(bambooServer, "", null, e.getMessage(), e));
        }
        return builds;
    }

    @Override
    public BuildDetails getBuildDetails(ConnectionCfg bambooServer, @NotNull String planKey, int buildNumber) throws ServerPasswordNotProvidedException, RemoteApiException {
        try {
            BambooSession api = this.getSession(bambooServer);
            return api.getBuildResultDetails(planKey, buildNumber);
        }
        catch (RemoteApiException e) {
            this.logger.info("Bamboo exception: " + e.getMessage());
            throw e;
        }
    }

    @Override
    public BambooBuild getBuildForPlanAndNumber(ConnectionCfg bambooServer, @NotNull String planKey, int buildNumber, int timezoneOffset) throws ServerPasswordNotProvidedException, RemoteApiException {
        try {
            BambooSession api = this.getSession(bambooServer);
            return api.getBuildForPlanAndNumber(planKey, buildNumber, timezoneOffset);
        }
        catch (RemoteApiException e) {
            this.logger.info("Bamboo exception: " + e.getMessage());
            throw e;
        }
    }

    @Override
    public void addLabelToBuild(ConnectionCfg bambooServer, @NotNull String planKey, int buildNumber, String buildLabel) throws ServerPasswordNotProvidedException, RemoteApiException {
        try {
            BambooSession api = this.getSession(bambooServer);
            api.addLabelToBuild(planKey, buildNumber, buildLabel);
        }
        catch (RemoteApiException e) {
            this.logger.info("Bamboo exception: " + e.getMessage());
            throw e;
        }
    }

    @Override
    public void addCommentToBuild(ConnectionCfg bambooServer, @NotNull String planKey, int buildNumber, String buildComment) throws ServerPasswordNotProvidedException, RemoteApiException {
        try {
            BambooSession api = this.getSession(bambooServer);
            api.addCommentToBuild(planKey, buildNumber, buildComment);
        }
        catch (RemoteApiException e) {
            this.logger.info("Bamboo exception: " + e.getMessage());
            throw e;
        }
    }

    @Override
    public void executeBuild(ConnectionCfg bambooServer, @NotNull String buildKey) throws ServerPasswordNotProvidedException, RemoteApiException {
        try {
            BambooSession api = this.getSession(bambooServer);
            api.executeBuild(buildKey);
        }
        catch (RemoteApiException e) {
            this.logger.info("Bamboo exception: " + e.getMessage());
            throw e;
        }
    }

    @Override
    public String getBuildLogs(ConnectionCfg bambooServer, @NotNull String planKey, int buildNumber) throws ServerPasswordNotProvidedException, RemoteApiException {
        try {
            BambooSession api = this.getSession(bambooServer);
            return api.getBuildLogs(planKey, buildNumber);
        }
        catch (RemoteApiException e) {
            this.logger.info("Bamboo exception: " + e.getMessage());
            throw e;
        }
    }

    @Override
    public Collection<BuildIssue> getIssuesForBuild(ConnectionCfg bambooServer, @NotNull String planKey, int buildNumber) throws ServerPasswordNotProvidedException, RemoteApiException {
        try {
            BambooSession api = this.getSession(bambooServer);
            return api.getIssuesForBuild(planKey, buildNumber);
        }
        catch (RemoteApiException e) {
            this.logger.info("Bamboo exception: " + e.getMessage());
            throw e;
        }
    }

    public Collection<String> getFavouritePlans(ConnectionCfg bambooServer) throws ServerPasswordNotProvidedException, RemoteApiException {
        try {
            return this.getSession(bambooServer).getFavouriteUserPlans();
        }
        catch (RemoteApiException e) {
            this.logger.error("Bamboo exception: " + e.getMessage());
            throw e;
        }
    }

    private BambooBuild constructBuildErrorInfo(ConnectionCfg server, @NotNull String planKey, String planName, String message, Throwable exception) {
        return new BambooBuildInfo.Builder(planKey, null, server, planName, null, BuildStatus.UNKNOWN).errorMessage(message, exception).pollingTime(new Date()).build();
    }

    private static class SimpleBambooSessionFactory
    implements BambooSessionFactory {
        private final Logger logger;

        SimpleBambooSessionFactory(Logger logger) {
            this.logger = logger;
        }

        public BambooSession createSession(ConnectionCfg serverData, HttpSessionCallback callback) throws RemoteApiException {
            return new AutoRenewBambooSession(serverData, callback, this.logger);
        }

        public ProductSession createLoginSession(ConnectionCfg serverData, HttpSessionCallback callback) throws RemoteApiMalformedUrlException {
            return new LoginBambooSession(serverData, callback);
        }
    }
}

