/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.bamboo.api;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BambooJobImpl;
import com.atlassian.theplugin.commons.bamboo.BambooPlan;
import com.atlassian.theplugin.commons.bamboo.BambooProject;
import com.atlassian.theplugin.commons.bamboo.BuildDetails;
import com.atlassian.theplugin.commons.bamboo.BuildIssue;
import com.atlassian.theplugin.commons.bamboo.api.BambooSession;
import com.atlassian.theplugin.commons.bamboo.api.BambooSessionImpl;
import com.atlassian.theplugin.commons.cfg.SubscribedPlan;
import com.atlassian.theplugin.commons.exception.ServerPasswordNotProvidedException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiLoginException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiSessionExpiredException;
import com.atlassian.theplugin.commons.remoteapi.rest.HttpSessionCallback;
import com.atlassian.theplugin.commons.util.Logger;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoRenewBambooSession
implements BambooSession {
    private final BambooSession delegate;
    private String userName;
    private char[] password;

    public AutoRenewBambooSession(ConnectionCfg serverCfg, HttpSessionCallback callback, Logger logger) throws RemoteApiException {
        this.delegate = new BambooSessionImpl(serverCfg, callback, logger);
    }

    AutoRenewBambooSession(BambooSession bambooSession) throws RemoteApiException {
        this.delegate = bambooSession;
    }

    @Override
    public void addCommentToBuild(@NotNull String planKey, int buildNumber, String buildComment) throws RemoteApiException {
        try {
            this.delegate.addCommentToBuild(planKey, buildNumber, buildComment);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            this.delegate.addCommentToBuild(planKey, buildNumber, buildComment);
        }
    }

    @Override
    public void executeBuild(@NotNull String buildKey) throws RemoteApiException {
        try {
            this.delegate.executeBuild(buildKey);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            this.delegate.executeBuild(buildKey);
        }
    }

    @Override
    public void addLabelToBuild(@NotNull String planKey, int buildNumber, String buildLabel) throws RemoteApiException {
        try {
            this.delegate.addLabelToBuild(planKey, buildNumber, buildLabel);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            this.delegate.addLabelToBuild(planKey, buildNumber, buildLabel);
        }
    }

    @Override
    @NotNull
    public BuildDetails getBuildResultDetails(@NotNull String planKey, int buildNumber) throws RemoteApiException {
        try {
            return this.delegate.getBuildResultDetails(planKey, buildNumber);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getBuildResultDetails(planKey, buildNumber);
        }
    }

    @Override
    @NotNull
    public List<String> getFavouriteUserPlans() throws RemoteApiException {
        try {
            return this.delegate.getFavouriteUserPlans();
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getFavouriteUserPlans();
        }
    }

    @Override
    @NotNull
    public BambooBuild getLatestBuildForPlan(@NotNull String planKey, int timezoneOffset) throws RemoteApiException {
        try {
            return this.delegate.getLatestBuildForPlan(planKey, timezoneOffset);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getLatestBuildForPlan(planKey, timezoneOffset);
        }
    }

    @Override
    @NotNull
    public BambooBuild getBuildForPlanAndNumber(@NotNull String planKey, int buildNumber, int timezoneOffset) throws RemoteApiException {
        try {
            return this.delegate.getBuildForPlanAndNumber(planKey, buildNumber, timezoneOffset);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getBuildForPlanAndNumber(planKey, buildNumber, timezoneOffset);
        }
    }

    @Override
    public boolean isLoggedIn() throws RemoteApiLoginException {
        return this.delegate.isLoggedIn();
    }

    @Override
    public String getBuildLogs(@NotNull String planKey, int buildNumber) throws RemoteApiException {
        try {
            return this.delegate.getBuildLogs(planKey, buildNumber);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getBuildLogs(planKey, buildNumber);
        }
    }

    @Override
    public Collection<BambooBuild> getRecentBuildsForPlan(@NotNull String planKey, int timezoneOffset) throws RemoteApiException {
        try {
            return this.delegate.getRecentBuildsForPlan(planKey, timezoneOffset);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getRecentBuildsForPlan(planKey, timezoneOffset);
        }
    }

    @Override
    public Collection<BambooBuild> getRecentBuildsForUser(int timezoneOffset) throws RemoteApiException {
        try {
            return this.delegate.getRecentBuildsForUser(timezoneOffset);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getRecentBuildsForUser(timezoneOffset);
        }
    }

    @Override
    @NotNull
    public Collection<BuildIssue> getIssuesForBuild(@NotNull String planKey, int buildNumber) throws RemoteApiException {
        try {
            return this.delegate.getIssuesForBuild(planKey, buildNumber);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getIssuesForBuild(planKey, buildNumber);
        }
    }

    @Override
    @NotNull
    public BambooPlan getPlanDetails(@NotNull String planKey) throws RemoteApiException {
        try {
            return this.delegate.getPlanDetails(planKey);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getPlanDetails(planKey);
        }
    }

    @Override
    @NotNull
    public BambooBuild getLatestBuildForPlanNew(@NotNull String planKey, @Nullable String masterPlanKey, boolean isPlanEnabled, int timezoneOffset) throws RemoteApiException {
        try {
            return this.delegate.getLatestBuildForPlanNew(planKey, masterPlanKey, isPlanEnabled, timezoneOffset);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getLatestBuildForPlanNew(planKey, masterPlanKey, isPlanEnabled, timezoneOffset);
        }
    }

    @Override
    @NotNull
    public Collection<BambooPlan> getPlanList() throws ServerPasswordNotProvidedException, RemoteApiException {
        try {
            return this.delegate.getPlanList();
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getPlanList();
        }
    }

    @Override
    @NotNull
    public List<BambooProject> listProjectNames() throws RemoteApiException {
        try {
            return this.delegate.listProjectNames();
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.listProjectNames();
        }
    }

    @Override
    public void login(String name, char[] aPassword) throws RemoteApiLoginException {
        this.userName = name;
        this.password = new char[aPassword.length];
        System.arraycopy(aPassword, 0, this.password, 0, aPassword.length);
        this.delegate.login(name, aPassword);
    }

    @Override
    public void logout() {
        this.delegate.logout();
    }

    @Override
    public int getBamboBuildNumber() throws RemoteApiException {
        try {
            return this.delegate.getBamboBuildNumber();
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getBamboBuildNumber();
        }
    }

    @Override
    @NotNull
    public Collection<BambooBuild> getSubscribedPlansResults(Collection<SubscribedPlan> plans, boolean isUseFavourities, int timezoneOffset) throws RemoteApiException {
        try {
            return this.delegate.getSubscribedPlansResults(plans, isUseFavourities, timezoneOffset);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getSubscribedPlansResults(plans, isUseFavourities, timezoneOffset);
        }
    }

    @Override
    public List<BambooJobImpl> getJobsForPlan(String planKey) throws RemoteApiException {
        try {
            return this.delegate.getJobsForPlan(planKey);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getJobsForPlan(planKey);
        }
    }

    @Override
    @NotNull
    public Collection<String> getBranchKeys(String planKey, boolean useFavourites, boolean myBranchesOnly) throws RemoteApiException {
        try {
            return this.delegate.getBranchKeys(planKey, useFavourites, myBranchesOnly);
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {
            this.delegate.login(this.userName, this.password);
            return this.delegate.getBranchKeys(planKey, useFavourites, myBranchesOnly);
        }
    }
}

