/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.cfg;

import com.atlassian.theplugin.commons.ServerType;
import com.atlassian.theplugin.commons.cfg.FishEyeServer;
import com.atlassian.theplugin.commons.cfg.ServerCfg;
import com.atlassian.theplugin.commons.cfg.ServerIdImpl;
import com.atlassian.theplugin.commons.cfg.UserCfg;

public class CrucibleServerCfg
extends ServerCfg {
    private boolean isFisheyeInstance;
    private static final int HASHCODE_MAGIC = 31;
    private FishEyeServer fishEyeView;

    public CrucibleServerCfg(boolean enabled, String name, ServerIdImpl serverId) {
        super(enabled, name, serverId);
    }

    private FishEyeServer getFishEyeView() {
        if (this.fishEyeView == null) {
            this.fishEyeView = new FishEyeServer(){

                public ServerIdImpl getServerId() {
                    return CrucibleServerCfg.this.getServerId();
                }

                public String getPassword() {
                    return CrucibleServerCfg.this.getPassword();
                }

                public String getName() {
                    return CrucibleServerCfg.this.getName();
                }

                public String getUsername() {
                    return CrucibleServerCfg.this.getUsername();
                }

                public String getUrl() {
                    return CrucibleServerCfg.this.getUrl();
                }

                public boolean isEnabled() {
                    return CrucibleServerCfg.this.isEnabled();
                }

                public boolean isUseDefaultCredentials() {
                    return CrucibleServerCfg.this.isUseDefaultCredentials();
                }

                public ServerType getServerType() {
                    return ServerType.FISHEYE_SERVER;
                }

                public boolean isDontUseBasicAuth() {
                    return false;
                }

                public boolean isUseSessionCookies() {
                    return false;
                }

                public UserCfg getBasicHttpUser() {
                    return null;
                }

                public boolean isShared() {
                    return false;
                }

                public void setShared(boolean shared) {
                }
            };
        }
        return this.fishEyeView;
    }

    public CrucibleServerCfg(String name, ServerIdImpl serverId) {
        super(true, name, serverId);
    }

    public CrucibleServerCfg(CrucibleServerCfg other) {
        super(other);
        this.isFisheyeInstance = other.isFisheyeInstance();
    }

    public ServerType getServerType() {
        return ServerType.CRUCIBLE_SERVER;
    }

    public boolean isDontUseBasicAuth() {
        return false;
    }

    public boolean isUseSessionCookies() {
        return false;
    }

    public UserCfg getBasicHttpUser() {
        return null;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof CrucibleServerCfg)) {
            return false;
        }
        CrucibleServerCfg that = (CrucibleServerCfg)o;
        return this.isFisheyeInstance == that.isFisheyeInstance;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isFisheyeInstance ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Crucible Server [");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

    public CrucibleServerCfg getClone() {
        return new CrucibleServerCfg(this);
    }

    public boolean isFisheyeInstance() {
        return this.isFisheyeInstance;
    }

    public void setFisheyeInstance(boolean fisheyeInstance) {
        this.isFisheyeInstance = fisheyeInstance;
    }

    public FishEyeServer asFishEyeServer() {
        if (this.isFisheyeInstance) {
            return this.getFishEyeView();
        }
        return null;
    }
}

