/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.cfg;

import com.atlassian.theplugin.commons.ServerType;
import com.atlassian.theplugin.commons.cfg.FishEyeServer;
import com.atlassian.theplugin.commons.cfg.PrivateServerCfgInfo;
import com.atlassian.theplugin.commons.cfg.Server;
import com.atlassian.theplugin.commons.cfg.ServerIdImpl;

public abstract class ServerCfg
implements Server {
    private static final int HASHCODE_MAGIC = 31;
    private ServerIdImpl serverId;
    private boolean isEnabled;
    private boolean deleted;
    private String name;
    private String url = "";
    private String username = "";
    private String password = "";
    private boolean isPasswordStored;
    private boolean useDefaultCredentials;
    private boolean shared = false;

    public ServerCfg(boolean enabled, String name, ServerIdImpl serverId) {
        this(enabled, name, "", serverId);
    }

    public ServerCfg(boolean enabled, String name, String url, ServerIdImpl serverId) {
        this.isEnabled = enabled;
        this.name = name;
        this.serverId = serverId;
        this.url = url;
    }

    protected ServerCfg(ServerCfg other) {
        this.serverId = other.getServerId();
        this.isEnabled = other.isEnabled();
        this.name = other.getName();
        this.url = other.getUrl();
        this.username = other.getUsername();
        this.password = other.getPassword();
        this.isPasswordStored = other.isPasswordStored();
        this.useDefaultCredentials = other.useDefaultCredentials;
        this.shared = other.shared;
        this.deleted = other.deleted;
    }

    public boolean isUseDefaultCredentials() {
        return this.useDefaultCredentials;
    }

    public void setUseDefaultCredentials(boolean useDefaultCredentials) {
        this.useDefaultCredentials = useDefaultCredentials;
    }

    protected Object readResolve() {
        if (this.username == null) {
            this.username = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public abstract ServerType getServerType();

    public String getUsername() {
        return this.username;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled && !this.deleted;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setServerId(ServerIdImpl serverId) {
        this.serverId = serverId;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordStored(boolean passwordStored) {
        this.isPasswordStored = passwordStored;
    }

    public boolean isEnabled() {
        return this.isEnabled && !this.deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getName() {
        return this.name;
    }

    public ServerIdImpl getServerId() {
        return this.serverId;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isPasswordStored() {
        return this.isPasswordStored;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerCfg)) {
            return false;
        }
        ServerCfg serverCfg = (ServerCfg)o;
        if (this.isEnabled != serverCfg.isEnabled) {
            return false;
        }
        if (this.deleted != serverCfg.deleted) {
            return false;
        }
        if (this.isPasswordStored != serverCfg.isPasswordStored) {
            return false;
        }
        if (this.shared != serverCfg.shared) {
            return false;
        }
        if (this.useDefaultCredentials != serverCfg.useDefaultCredentials) {
            return false;
        }
        if (this.name != null ? !this.name.equals(serverCfg.name) : serverCfg.name != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(serverCfg.password) : serverCfg.password != null) {
            return false;
        }
        if (this.serverId != null ? !this.serverId.equals(serverCfg.serverId) : serverCfg.serverId != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(serverCfg.url) : serverCfg.url != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(serverCfg.username) : serverCfg.username != null);
    }

    public int hashCode() {
        int result = this.isEnabled ? 1 : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.serverId != null ? this.serverId.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.isPasswordStored ? 1 : 0);
        result = 31 * result + (this.shared ? 1 : 0);
        result = 31 * result + (this.deleted ? 1 : 0);
        result = 31 * result + (this.useDefaultCredentials ? 1 : 0);
        return result;
    }

    public abstract ServerCfg getClone();

    public boolean isComplete() {
        return this.getPassword() != null && this.getPassword().length() != 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("name = ");
        builder.append(this.getName());
        builder.append(", url = ");
        builder.append(this.getUrl());
        return builder.toString();
    }

    public PrivateServerCfgInfo createPrivateProjectConfiguration() {
        return new PrivateServerCfgInfo(this.getServerId(), this.isEnabled(), this.isUseDefaultCredentials(), this.getUsername(), this.isPasswordStored() ? this.getPassword() : null, this.isUseSessionCookies(), false, null, null, this.shared);
    }

    public void mergePrivateConfiguration(PrivateServerCfgInfo psci) {
        if (psci != null) {
            this.setUsername(psci.getUsername());
            this.setEnabled(psci.isEnabled());
            this.setUseDefaultCredentials(psci.isUseDefaultCredentials());
            this.setShared(psci.isShared());
            String pwd = psci.getPassword();
            if (pwd != null) {
                this.setPassword(pwd);
                this.setPasswordStored(true);
            } else {
                this.setPasswordStored(false);
            }
        } else {
            this.setPasswordStored(false);
            this.setEnabled(true);
        }
    }

    public FishEyeServer asFishEyeServer() {
        return null;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }
}

