/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.connector.commons.crucible.CrucibleServerFacade2;
import com.atlassian.theplugin.commons.ServerType;
import com.atlassian.theplugin.commons.crucible.api.CrucibleLoginException;
import com.atlassian.theplugin.commons.crucible.api.CrucibleSession;
import com.atlassian.theplugin.commons.crucible.api.PathAndRevision;
import com.atlassian.theplugin.commons.crucible.api.UploadItem;
import com.atlassian.theplugin.commons.crucible.api.model.BasicProject;
import com.atlassian.theplugin.commons.crucible.api.model.BasicReview;
import com.atlassian.theplugin.commons.crucible.api.model.Comment;
import com.atlassian.theplugin.commons.crucible.api.model.CrucibleFileInfo;
import com.atlassian.theplugin.commons.crucible.api.model.CrucibleUserCache;
import com.atlassian.theplugin.commons.crucible.api.model.CrucibleVersionInfo;
import com.atlassian.theplugin.commons.crucible.api.model.CustomFieldDef;
import com.atlassian.theplugin.commons.crucible.api.model.CustomFilter;
import com.atlassian.theplugin.commons.crucible.api.model.GeneralComment;
import com.atlassian.theplugin.commons.crucible.api.model.NewReviewItem;
import com.atlassian.theplugin.commons.crucible.api.model.PatchAnchorData;
import com.atlassian.theplugin.commons.crucible.api.model.PermId;
import com.atlassian.theplugin.commons.crucible.api.model.PredefinedFilter;
import com.atlassian.theplugin.commons.crucible.api.model.Repository;
import com.atlassian.theplugin.commons.crucible.api.model.Review;
import com.atlassian.theplugin.commons.crucible.api.model.Reviewer;
import com.atlassian.theplugin.commons.crucible.api.model.User;
import com.atlassian.theplugin.commons.crucible.api.model.VersionedComment;
import com.atlassian.theplugin.commons.crucible.api.rest.CrucibleSessionImpl;
import com.atlassian.theplugin.commons.exception.ServerPasswordNotProvidedException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiMalformedUrlException;
import com.atlassian.theplugin.commons.remoteapi.rest.HttpSessionCallback;
import com.atlassian.theplugin.commons.util.Logger;
import com.atlassian.theplugin.commons.util.MiscUtil;
import com.atlassian.theplugin.commons.util.UrlUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrucibleServerFacadeImpl
implements CrucibleServerFacade2 {
    private final Map<String, CrucibleSession> sessions = new HashMap<String, CrucibleSession>();
    private CrucibleUserCache userCache;
    private HttpSessionCallback callback;
    private final Logger logger;

    public CrucibleServerFacadeImpl(@NotNull Logger logger, CrucibleUserCache userCache, @NotNull HttpSessionCallback callback) {
        this.logger = logger;
        this.userCache = userCache;
        this.callback = callback;
    }

    public void setUserCache(CrucibleUserCache newCache) {
        this.userCache = newCache;
    }

    @Override
    public ServerType getServerType() {
        return ServerType.CRUCIBLE_SERVER;
    }

    @Override
    public synchronized CrucibleSession getSession(ConnectionCfg server) throws RemoteApiException, ServerPasswordNotProvidedException {
        String key = String.valueOf(server.getUrl()) + server.getUsername() + server.getPassword();
        CrucibleSession session = this.sessions.get(key);
        if (session == null) {
            try {
                session = new CrucibleSessionImpl(server, this.callback, this.logger);
                if (!session.isLoggedIn()) {
                    session.login();
                }
                this.sessions.put(key, session);
            }
            catch (RemoteApiMalformedUrlException e) {
                if (server.getPassword().length() > 0 || !UrlUtil.isUrlValid(server.getUrl())) {
                    throw e;
                }
                throw new ServerPasswordNotProvidedException(e);
            }
        }
        return session;
    }

    private void fixUserName(ConnectionCfg server, Comment comment) {
        User newU;
        User u = comment.getAuthor();
        if ((u.getDisplayName() == null || u.getDisplayName().length() == 0) && (newU = this.userCache.getUser(this, server, u.getUsername(), true)) != null) {
            comment.setAuthor(newU);
        }
    }

    @Override
    @Nullable
    public String getDisplayName(@NotNull ConnectionCfg server, @NotNull String username) {
        User user = this.userCache.getUser(this, server, username, true);
        return user != null ? user.getDisplayName() : null;
    }

    @Nullable
    public User getUser(@NotNull ConnectionCfg server, String username) {
        return this.userCache.getUser(this, server, username, true);
    }

    public BasicProject getProject(@NotNull ConnectionCfg server, @NotNull String projectKey) throws RemoteApiException, ServerPasswordNotProvidedException {
        List<BasicProject> projects = this.getProjects(server);
        for (BasicProject project : projects) {
            if (!project.getKey().equals(projectKey)) continue;
            return project;
        }
        return null;
    }

    @Override
    public boolean checkContentUrlAvailable(ConnectionCfg server) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.checkContentUrlAvailable();
    }

    @Override
    public Review createReviewFromUpload(@NotNull ConnectionCfg server, @NotNull Review review, @NotNull Collection<UploadItem> uploadItems) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return this.getFullReview(session.createReviewFromUpload(review, uploadItems), session);
    }

    @Override
    public void testServerConnection(ConnectionCfg connectionCfg) throws RemoteApiException {
        CrucibleSessionImpl session = new CrucibleSessionImpl(connectionCfg, this.callback, this.logger);
        session.login();
        session.isLoggedIn();
        try {
            session.getServerVersion();
        }
        catch (RemoteApiException e) {
            if (e.getCause() != null && e.getCause().getMessage() != null && e.getCause().getMessage().startsWith("HTTP 500")) {
                throw new CrucibleLoginException("Atlassian Connector for IntelliJ IDEA detected a Crucible version older\nthan 1.6. Unfortunately, the plugin will not\nwork with this version of Crucible.\nDetailed error message is\n" + e.getCause().getMessage() + "\n");
            }
            throw e;
        }
        session.logout();
    }

    @Nullable
    private Review getFullReview(@Nullable BasicReview basicReview, CrucibleSession session) throws RemoteApiException {
        if (basicReview == null) {
            return null;
        }
        return session.getReview(basicReview.getPermId());
    }

    @Override
    public Review createReview(ConnectionCfg server, Review review) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return this.getFullReview(session.createReview(review), session);
    }

    @Override
    public Review createReviewFromRevision(ConnectionCfg server, Review review, List<String> revisions) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return this.getFullReview(session.createReviewFromRevision(review, revisions), session);
    }

    @Override
    public Review addRevisionsToReview(ConnectionCfg server, PermId permId, String repository, Collection<String> revisions) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        Review review = null;
        if (!revisions.isEmpty()) {
            review = this.getFullReview(session.addRevisionsToReview(permId, repository, revisions), session);
        }
        return review;
    }

    @Override
    public Review addFileRevisionsToReview(ConnectionCfg server, PermId permId, String repository, List<PathAndRevision> revisions) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        Review review = null;
        if (!revisions.isEmpty()) {
            review = this.getFullReview(session.addFileRevisionsToReview(permId, repository, revisions), session);
        }
        return review;
    }

    @Override
    public void addFileToReview(ConnectionCfg server, PermId permId, NewReviewItem newReviewItem) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        session.addFileToReview(permId, newReviewItem);
    }

    @Override
    public CrucibleVersionInfo getServerVersion(ConnectionCfg server) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.getServerVersion();
    }

    @Override
    public List<BasicReview> getAllReviewsForFile(ConnectionCfg server, String repoName, String filePath) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.getAllReviewsForFile(repoName, filePath);
    }

    @Override
    public List<BasicReview> getReviewsForIssue(ConnectionCfg server, String jiraIssueKey, int maxReturn) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.getReviewsForIssue(jiraIssueKey, maxReturn);
    }

    @Override
    public Review addPatchToReview(ConnectionCfg server, PermId permId, String repository, String patch) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return this.getFullReview(session.addPatchToReview(permId, repository, patch), session);
    }

    @Override
    public Review addItemsToReview(ConnectionCfg server, PermId permId, Collection<UploadItem> items) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        session.addItemsToReview(permId, items);
        return session.getReview(permId);
    }

    @Override
    public void addReviewers(ConnectionCfg server, PermId permId, Set<String> userNames) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        session.addReviewers(permId, userNames);
    }

    @Override
    public void removeReviewer(ConnectionCfg server, PermId permId, String userName) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        session.removeReviewer(permId, userName);
    }

    private boolean contains(Set<Reviewer> reviewers, String username) {
        for (Reviewer reviewer : reviewers) {
            if (!reviewer.getUsername().equals(username)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setReviewers(@NotNull ConnectionCfg server, @NotNull PermId permId, @NotNull Collection<String> aUsernames) throws RemoteApiException, ServerPasswordNotProvidedException {
        Set<String> reviewersForAdd = MiscUtil.buildHashSet();
        Set<Object> reviewersForRemove = MiscUtil.buildHashSet();
        Review review = this.getReview(server, permId);
        Set<String> usernames = MiscUtil.buildHashSet(aUsernames);
        for (String string : usernames) {
            if (this.contains(review.getReviewers(), string)) continue;
            reviewersForAdd.add(string);
        }
        for (Reviewer reviewer : review.getReviewers()) {
            if (usernames.contains(reviewer.getUsername())) continue;
            reviewersForRemove.add(reviewer.getUsername());
        }
        if (!reviewersForAdd.isEmpty()) {
            this.addReviewers(server, permId, reviewersForAdd);
        }
        if (!reviewersForRemove.isEmpty()) {
            for (String string : reviewersForRemove) {
                this.removeReviewer(server, permId, string);
            }
        }
    }

    @Override
    public Review closeReview(ConnectionCfg server, PermId permId, String summary) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return this.getFullReview(session.closeReview(permId, summary), session);
    }

    @Override
    public void completeReview(ConnectionCfg server, PermId permId, boolean complete) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        session.completeReview(permId, complete);
    }

    @Override
    public Review createReviewFromPatch(ConnectionCfg server, Review review, String patch) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return this.getFullReview(session.createReviewFromPatch(review, patch), session);
    }

    public Review createReviewFromPatch(ConnectionCfg server, Review review, String patch, PatchAnchorData anchorData) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return this.getFullReview(session.createReviewFromPatch(review, patch, anchorData), session);
    }

    @Override
    public Set<CrucibleFileInfo> getFiles(ConnectionCfg server, PermId permId) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.getFiles(permId);
    }

    @Override
    public List<VersionedComment> getVersionedComments(ConnectionCfg server, Review review, CrucibleFileInfo reviewItem) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.getVersionedComments(review, reviewItem);
    }

    @Override
    public Comment addGeneralComment(ConnectionCfg server, Review review, Comment comment) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        GeneralComment newComment = (GeneralComment)session.addGeneralComment(review, comment);
        if (newComment != null) {
            this.fixUserName(server, newComment);
        }
        return newComment;
    }

    @Override
    public VersionedComment addVersionedComment(ConnectionCfg server, Review review, PermId riId, VersionedComment comment) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        VersionedComment newComment = session.addVersionedComment(review, riId, comment);
        if (newComment != null) {
            this.fixUserName(server, newComment);
        }
        return newComment;
    }

    @Override
    public void updateComment(ConnectionCfg server, PermId id, Comment comment) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        session.updateComment(id, comment);
    }

    @Override
    public void publishComment(ConnectionCfg server, PermId reviewId, PermId commentId) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        session.publishComment(reviewId, commentId);
    }

    @Override
    public void publishAllCommentsForReview(ConnectionCfg server, PermId reviewId) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        session.publishComment(reviewId, null);
    }

    @Override
    public Comment addReply(ConnectionCfg server, Comment reply) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        GeneralComment newReply = (GeneralComment)session.addReply(reply.getReview(), reply);
        if (newReply != null) {
            this.fixUserName(server, newReply);
        }
        return newReply;
    }

    @Override
    public void removeComment(ConnectionCfg server, PermId id, Comment comment) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        session.removeComment(id, comment);
    }

    @Override
    public List<User> getUsers(ConnectionCfg server) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.getUsers();
    }

    @Override
    public List<BasicProject> getProjects(ConnectionCfg server) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.getProjects();
    }

    @Override
    public List<Repository> getRepositories(ConnectionCfg server) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.getRepositories();
    }

    @Override
    public Repository getRepository(ConnectionCfg server, String repoName) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.getRepository(repoName);
    }

    @Override
    public List<CustomFieldDef> getMetrics(ConnectionCfg server, int version) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.getMetrics(version);
    }

    @Override
    public List<BasicReview> getReviewsForFilter(ConnectionCfg server, PredefinedFilter filter) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.getReviewsForFilter(filter);
    }

    @Override
    public List<BasicReview> getReviewsForCustomFilter(ConnectionCfg server, CustomFilter filter) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.getReviewsForCustomFilter(filter);
    }

    @Override
    public Review getReview(ConnectionCfg server, PermId permId) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.getReview(permId);
    }

    @Override
    public List<Reviewer> getReviewers(ConnectionCfg server, PermId permId) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        return session.getReviewers(permId);
    }

    public void setCallback(HttpSessionCallback callback) {
        this.callback = callback;
    }

    @Override
    public void markCommentRead(@NotNull ConnectionCfg server, PermId reviewId, PermId commentId) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        session.markCommentRead(reviewId, commentId);
    }

    @Override
    public void markCommentLeaveUnread(@NotNull ConnectionCfg server, PermId reviewId, PermId commentId) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        session.markCommentLeaveRead(reviewId, commentId);
    }

    @Override
    public void markAllCommentsRead(@NotNull ConnectionCfg server, PermId reviewId) throws RemoteApiException, ServerPasswordNotProvidedException {
        CrucibleSession session = this.getSession(server);
        session.markAllCommentsRead(reviewId);
    }
}

