/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.util;

import com.atlassian.theplugin.commons.util.Logger;

public abstract class LoggerImpl
implements Logger {
    private static Logger singleton;
    public static final String LOGGER_CATEGORY = "com.atlassian.theplugin";
    private static boolean debug;
    private static boolean verbose;
    public static final int LOG_ERR = 0;
    public static final int LOG_WARN = 1;
    public static final int LOG_INFO = 2;
    public static final int LOG_VERBOSE = 3;
    public static final int LOG_DEBUG = 4;

    public boolean isDebugEnabled() {
        return debug;
    }

    public static Logger getInstance() {
        if (singleton != null) {
            return singleton;
        }
        System.out.println("Logger not initialized");
        return new NullLogger();
    }

    public static void setInstance(Logger instance) {
        singleton = instance;
    }

    protected LoggerImpl() {
    }

    public static void setDebug(boolean debug) {
        LoggerImpl.debug = debug;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean verbose) {
        LoggerImpl.verbose = verbose;
    }

    public void error(String msg) {
        this.log(0, msg, null);
    }

    public void error(String msg, Throwable t) {
        this.log(0, msg, t);
    }

    public void error(Throwable t) {
        this.log(0, t != null ? t.getMessage() : "Exception", t);
    }

    public void warn(String msg) {
        this.log(1, msg, null);
    }

    public void warn(String msg, Throwable t) {
        this.log(1, msg, t);
    }

    public void warn(Throwable t) {
        this.log(1, t != null ? t.getMessage() : "Exception", t);
    }

    public void info(String msg) {
        this.log(2, msg, null);
    }

    public void info(String msg, Throwable t) {
        this.log(2, msg, t);
    }

    public void info(Throwable t) {
        this.log(2, t != null ? t.getMessage() : "Exception", t);
    }

    public void verbose(String msg) {
        this.log(3, msg, null);
    }

    public void verbose(String msg, Throwable t) {
        this.log(3, msg, t);
    }

    public void verbose(Throwable t) {
        this.log(3, t != null ? t.getMessage() : "Exception", t);
    }

    public void debug(String msg) {
        this.log(4, msg, null);
    }

    public void debug(String msg, Throwable t) {
        this.log(4, msg, t);
    }

    public void debug(Throwable t) {
        this.log(4, t != null ? t.getMessage() : "Exception", t);
    }

    public static boolean canIgnore(int level) {
        if (!debug && level == 4) {
            return true;
        }
        return !verbose && !debug && level == 3;
    }

    static class NullLogger
    extends LoggerImpl {
        NullLogger() {
        }

        public void log(int level, String msg, Throwable t) {
        }
    }
}

