/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.legacyconversion;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.springsource.ide.eclipse.commons.frameworks.core.legacyconversion.IConversionConstants;
import org.springsource.ide.eclipse.commons.frameworks.core.legacyconversion.LegacyProjectConverter;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.legacyconversion.LegacySTSChecker;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.legacyconversion.ListMessageDialog;

public class LegacyProjectsJob
extends UIJob
implements IConversionConstants {
    private final boolean warnIfNone;
    private List<IProject> legacyProjects;

    public LegacyProjectsJob(boolean warnIfNone) {
        super("Legacy STS Project Checker");
        this.warnIfNone = warnIfNone;
    }

    public LegacyProjectsJob(List<IProject> legacyProjects, boolean warnIfNone) {
        this(warnIfNone);
        this.legacyProjects = legacyProjects;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        monitor.beginTask("Checking for legacy STS projects", 100);
        IStatus status = this.doCheck(monitor, this.getDisplay().getActiveShell());
        monitor.done();
        return status;
    }

    private IStatus doCheck(IProgressMonitor monitor, Shell shell) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.legacyProjects == null) {
            this.legacyProjects = this.findLegacyProjects();
        }
        sub.worked(30);
        if (this.legacyProjects.size() > 0) {
            LegacyProjectConverter converter = new LegacyProjectConverter(this.legacyProjects);
            if (this.askToConvert(shell, converter)) {
                return converter.convert((IProgressMonitor)sub.newChild(70));
            }
        } else if (this.warnIfNone && !LegacySTSChecker.NON_BLOCKING) {
            MessageDialog.openInformation((Shell)shell, (String)"No legacy projects found", (String)"No legacy projects found.");
        }
        return Status.OK_STATUS;
    }

    private List<IProject> findLegacyProjects() {
        IProject[] allProjects;
        ArrayList<IProject> legacyProjectsList = new ArrayList<IProject>();
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (LegacyProjectsJob.isLegacyProject(project, true)) {
                    legacyProjectsList.add(project);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return legacyProjectsList;
    }

    public boolean askToConvert(Shell shell, LegacyProjectConverter converter) {
        if (LegacySTSChecker.NON_BLOCKING) {
            return false;
        }
        converter.setSelectedLegacyProjects(ListMessageDialog.openViewer(shell, converter.getAllLegacyProjects().toArray(new IProject[0])));
        return converter.getSelectedLegacyProjects() != null;
    }

    public static boolean isLegacyProject(IProject project, boolean isWorkspaceMigration) throws CoreException {
        return project.isAccessible() && (project.hasNature("com.springsource.sts.grails.core.nature") && isWorkspaceMigration || project.hasNature("com.springsource.sts.roo.core.nature") && LegacyProjectsJob.needsRooPrefMigration(project) || project.hasNature("com.springsource.sts.gradle.core.nature") && isWorkspaceMigration);
    }

    private static boolean needsRooPrefMigration(IProject project) {
        IFolder preferencesFolder = project.getFolder(".settings/");
        File settingsFile = preferencesFolder.getFile("org.springframework.ide.eclipse.roo.core.prefs").getLocation().toFile();
        return !settingsFile.exists();
    }
}

