/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.internal.model.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidatorDefinition;

public class ValidatorDefinitionFactory {
    public static final String VALIDATORS_EXTENSION_POINT = "org.springframework.ide.eclipse.core.validators";
    public static final String VALIDATOR_ELEMENT = "validator";

    public static List<ValidatorDefinition> getValidatorDefinitions() {
        ArrayList<ValidatorDefinition> validatorDefinitions = new ArrayList<ValidatorDefinition>();
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint(VALIDATORS_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (VALIDATOR_ELEMENT.equals(element.getName())) {
                    try {
                        ValidatorDefinition validatorDefinition = new ValidatorDefinition(element);
                        validatorDefinitions.add(validatorDefinition);
                    }
                    catch (CoreException e) {
                        SpringCore.log(e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        Collections.sort(validatorDefinitions, new Comparator<ValidatorDefinition>(){

            @Override
            public int compare(ValidatorDefinition v1, ValidatorDefinition v2) {
                if (v1.getOrder() == v2.getOrder()) {
                    return v1.getName().compareTo(v2.getName());
                }
                return Integer.valueOf(v1.getOrder()).compareTo(v2.getOrder());
            }
        });
        return validatorDefinitions;
    }

    public static ValidatorDefinition getValidatorDefinition(String validatorId) {
        for (ValidatorDefinition validator : ValidatorDefinitionFactory.getValidatorDefinitions()) {
            if (!validator.getID().equals(validatorId)) continue;
            return validator;
        }
        return null;
    }
}

