/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.typehierarchy;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.typehierarchy.ClasspathElement;
import org.springframework.ide.eclipse.core.java.typehierarchy.ClasspathElementDirectory;
import org.springframework.ide.eclipse.core.java.typehierarchy.ClasspathElementJar;
import org.springframework.ide.eclipse.core.java.typehierarchy.ClasspathLookup;

public class ClasspathLookupDirect
implements ClasspathLookup {
    private ClasspathElement[] cpElements;

    public ClasspathLookupDirect(URL[] urls) {
        ArrayList<ClasspathElement> locations = new ArrayList<ClasspathElement>();
        HashSet<URL> usedURLs = new HashSet<URL>();
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            if (!usedURLs.contains(url)) {
                if (url.toString().endsWith(".jar")) {
                    try {
                        String path = url.toURI().getPath();
                        locations.add(new ClasspathElementJar(path));
                        usedURLs.add(url);
                    }
                    catch (Exception e) {
                        SpringCore.log(e);
                    }
                } else {
                    try {
                        File file = new File(url.toURI());
                        locations.add(new ClasspathElementDirectory(file));
                        usedURLs.add(url);
                    }
                    catch (Exception e) {
                        SpringCore.log(e);
                    }
                }
            }
            ++n2;
        }
        this.cpElements = locations.toArray(new ClasspathElement[0]);
    }

    public ClasspathLookupDirect(ClasspathElement[] cpElements) {
        this.cpElements = cpElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getStream(String fullyQualifiedClassFileName, String packageName, String className) {
        int i = 0;
        while (i < this.cpElements.length) {
            InputStream stream = null;
            ClasspathElement classpathElement = this.cpElements[i];
            synchronized (classpathElement) {
                try {
                    stream = this.cpElements[i].getStream(fullyQualifiedClassFileName, packageName, className);
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        int i = 0;
        while (i < this.cpElements.length) {
            ClasspathElement classpathElement = this.cpElements[i];
            synchronized (classpathElement) {
                this.cpElements[i].cleanup();
            }
            ++i;
        }
    }
}

