/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.model.validation;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;

public final class ValidationUtils {
    public static void createProblemMarkers(IResource resource, Set<ValidationProblem> problems, String markerId) {
        if (problems != null) {
            for (ValidationProblem problem : problems) {
                if (problem.getSeverity() < 0) continue;
                ValidationUtils.createProblemMarker(resource, problem, markerId);
            }
        }
    }

    public static void createProblemMarker(IResource resource, ValidationProblem problem, String markerId) {
        IResource originatingResource = resource;
        if (problem.getResource() != null) {
            resource = problem.getResource();
        }
        if (resource != null && resource.isAccessible()) {
            try {
                IMarker marker;
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = resource.findMarkers(markerId, false, 0);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    String msg;
                    marker = iMarkerArray[n2];
                    int line = marker.getAttribute("lineNumber", -1);
                    if (line == problem.getLine() && (msg = marker.getAttribute("message", "")).equals(problem.getMessage())) {
                        return;
                    }
                    ++n2;
                }
                marker = resource.createMarker(markerId);
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("message", problem.getMessage());
                attributes.put("severity", new Integer(problem.getSeverity()));
                attributes.put("originatingResource", originatingResource.getFullPath().toString());
                if (problem.getLine() > 0) {
                    attributes.put("lineNumber", new Integer(problem.getLine()));
                }
                if (problem.getErrorId() != null) {
                    attributes.put("errorId", problem.getErrorId());
                }
                if (problem.getRuleId() != null) {
                    attributes.put("ruleId", problem.getRuleId());
                }
                ValidationProblemAttribute[] validationProblemAttributeArray = problem.getAttributes();
                int n3 = validationProblemAttributeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ValidationProblemAttribute attribute = validationProblemAttributeArray[n4];
                    Object value = attribute.getValue();
                    if (value instanceof String || value instanceof Integer || value instanceof Boolean) {
                        attributes.put(attribute.getKey(), value);
                    } else if (value instanceof List) {
                        int counter = 1;
                        for (Object v : (List)value) {
                            if (!(v instanceof String) && !(value instanceof Integer) && !(value instanceof Boolean)) continue;
                            attributes.put(String.valueOf(attribute.getKey()) + counter, v);
                            ++counter;
                        }
                    }
                    ++n4;
                }
                marker.setAttributes(attributes);
            }
            catch (CoreException e) {
                SpringCore.log(e);
            }
        }
    }
}

