/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.tree;

import java.text.MessageFormat;
import org.eclipse.swt.widgets.Tree;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.ui.tree.BaseTreeItem;
import org.testng.eclipse.ui.tree.ITreeItem;

public class SuiteTreeItem
extends BaseTreeItem
implements ITreeItem {
    private static final String FORMATTED_MESSAGE = "{0} ( {1}/{2}/{3}/{4} ) ({5} s)";
    private int m_passed;
    private int m_failed;
    private int m_skipped;
    private int m_percentage;

    public SuiteTreeItem(Tree parent, RunInfo runInfo) {
        super(parent, runInfo);
        this.updateView(runInfo);
    }

    @Override
    public void update(RunInfo runInfo) {
        int status = runInfo.getStatus();
        if (status == 1) {
            ++this.m_passed;
        } else if (status == 2) {
            ++this.m_failed;
        } else if (status == 3) {
            ++this.m_skipped;
        } else {
            ++this.m_percentage;
        }
        this.updateView(runInfo);
    }

    private void updateView(RunInfo runInfo) {
        this.getTreeItem().setText(MessageFormat.format(FORMATTED_MESSAGE, this.getRunInfo().getSuiteName(), new Integer(this.m_passed), new Integer(this.m_failed), new Integer(this.m_skipped), new Integer(this.m_percentage), Float.valueOf(this.getTime() / 1000.0f)));
        this.maybeUpdateImage(runInfo);
    }
}

