/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.namespaces;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.ToolingAwareNamespacePlugins;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinition;

class NamespaceDefinition
implements INamespaceDefinition {
    private Pattern versionPattern = Pattern.compile(".*-([0-9,.]*)\\.xsd");
    private Bundle bundle;
    private String iconPath;
    private String name;
    private String namespaceUri;
    private String prefix;
    private Set<String> schemaLocations = new CopyOnWriteArraySet<String>();
    private Set<String> uris = new CopyOnWriteArraySet<String>();
    private Properties uriMapping = new Properties();
    private String defaultSchemaLocation = null;

    public NamespaceDefinition(Properties uriMapping) {
        this.uriMapping = uriMapping;
    }

    public void addSchemaLocation(String schemaLocation) {
        this.schemaLocations.add(schemaLocation);
    }

    public void addUri(String uri) {
        this.uris.add(uri);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public synchronized String getDefaultSchemaLocation() {
        if (this.defaultSchemaLocation == null) {
            for (String schemaLocation : this.schemaLocations) {
                if (this.versionPattern.matcher(schemaLocation).matches()) continue;
                this.defaultSchemaLocation = schemaLocation;
            }
            if (this.defaultSchemaLocation == null && this.schemaLocations.size() > 0) {
                ArrayList<String> locations = new ArrayList<String>(this.schemaLocations);
                Collections.sort(locations);
                this.defaultSchemaLocation = (String)locations.get(0);
            }
        }
        return this.defaultSchemaLocation;
    }

    protected String getDefaultUri() {
        String defaultUri = null;
        ToolingAwareNamespacePlugins.Version version = ToolingAwareNamespacePlugins.Version.MINIMUM_VERSION;
        for (String uri : this.uris) {
            ToolingAwareNamespacePlugins.Version tempVersion = ToolingAwareNamespacePlugins.Version.MINIMUM_VERSION;
            Matcher matcher = this.versionPattern.matcher(uri);
            if (matcher.matches()) {
                tempVersion = new ToolingAwareNamespacePlugins.Version(matcher.group(1));
            }
            if (tempVersion.compareTo(version) < 0) continue;
            version = tempVersion;
            defaultUri = uri;
        }
        return defaultUri;
    }

    @Override
    public InputStream getIconStream() {
        if (this.bundle == null || this.iconPath == null) {
            return null;
        }
        int bundleState = this.bundle.getState();
        if ((bundleState & 0x3C) == 0) {
            return null;
        }
        URL fullPathString = FileLocator.find((Bundle)this.bundle, (IPath)new Path(this.iconPath), null);
        if (fullPathString == null) {
            try {
                fullPathString = new URL(this.iconPath);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (fullPathString != null) {
            try {
                return fullPathString.openStream();
            }
            catch (IOException e) {
                BeansCorePlugin.log(e);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public String getPrefix() {
        if (this.prefix != null) {
            return this.prefix;
        }
        int ix = this.namespaceUri.lastIndexOf(47);
        if (ix > 0) {
            return this.namespaceUri.substring(ix + 1);
        }
        return null;
    }

    @Override
    public Set<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Properties getUriMapping() {
        return this.uriMapping;
    }

    @Override
    public String getIconPath() {
        return this.iconPath;
    }

    public String toString() {
        return this.namespaceUri;
    }
}

