/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.angularjs.core.BaseModel;
import org.eclipse.angularjs.core.CustomAngularModulesRegistry;
import org.eclipse.angularjs.core.ModulesFolder;
import org.eclipse.angularjs.core.ScriptsFolder;
import org.eclipse.angularjs.internal.core.Trace;
import org.eclipse.angularjs.internal.core.preferences.AngularCorePreferencesSupport;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import tern.angular.modules.AngularModulesManager;
import tern.angular.modules.Directive;
import tern.angular.modules.IAngularModulesRegistry;
import tern.angular.modules.IDirectiveCollector;
import tern.angular.modules.IDirectiveSyntax;
import tern.angular.modules.Restriction;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.ITernProjectLifecycleListener;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.scriptpath.ITernScriptPath;
import tern.server.ITernPlugin;
import tern.server.ITernServer;
import tern.server.ITernServerListener;
import tern.server.TernPlugin;
import tern.server.TernServerAdapter;

public class AngularProject
implements IDirectiveSyntax,
ITernProjectLifecycleListener {
    private static final String ANGULAR_PROJECT = AngularProject.class.getName();
    public static final String DEFAULT_START_SYMBOL = "{{";
    public static final String DEFAULT_END_SYMBOL = "}}";
    private final IIDETernProject ternProject;
    private String startSymbol;
    private String endSymbol;
    private final Map<ITernScriptPath, List<BaseModel>> folders;
    private final CustomAngularModulesRegistry customDirectives;

    AngularProject(IIDETernProject ternProject) throws CoreException {
        this.ternProject = ternProject;
        this.folders = new HashMap<ITernScriptPath, List<BaseModel>>();
        this.customDirectives = new CustomAngularModulesRegistry(ternProject.getProject());
        AngularModulesManager.getInstance().addRegistry((Object)this, (IAngularModulesRegistry)this.customDirectives);
        ternProject.setData(ANGULAR_PROJECT, (Object)this);
        ternProject.addServerListener((ITernServerListener)new TernServerAdapter(){

            public void onStop(ITernServer server) {
                AngularProject.this.customDirectives.clear();
            }
        });
        this.initializeSymbols();
        AngularCorePreferencesSupport.getInstance().getEclipsePreferences(ternProject.getProject()).addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if ("startSymbol".equals(event.getKey())) {
                    AngularProject.this.startSymbol = event.getNewValue().toString();
                } else if ("endSymbol".equals(event.getKey())) {
                    AngularProject.this.endSymbol = event.getNewValue().toString();
                }
            }
        });
    }

    private void initializeSymbols() {
        this.startSymbol = AngularCorePreferencesSupport.getInstance().getStartSymbol(this.getProject());
        this.endSymbol = AngularCorePreferencesSupport.getInstance().getEndSymbol(this.getProject());
    }

    public static AngularProject getAngularProject(IProject project) throws CoreException {
        if (!AngularProject.hasAngularNature(project)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.angularjs.core", "The project " + project.getName() + " is not an angular project."));
        }
        IIDETernProject ternProject = TernCorePlugin.getTernProject((IProject)project);
        AngularProject angularProject = (AngularProject)ternProject.getData(ANGULAR_PROJECT);
        if (angularProject == null) {
            angularProject = new AngularProject(ternProject);
        }
        return angularProject;
    }

    public IProject getProject() {
        return this.ternProject.getProject();
    }

    public static IIDETernProject getTernProject(IProject project) throws CoreException {
        return TernCorePlugin.getTernProject((IProject)project);
    }

    public static boolean hasAngularNature(IProject project) {
        if (project.isAccessible()) {
            try {
                if (TernCorePlugin.hasTernNature((IProject)project) && TernCorePlugin.getTernProject((IProject)project).hasPlugin((ITernPlugin)TernPlugin.angular)) {
                    return true;
                }
            }
            catch (CoreException e) {
                Trace.trace((byte)3, "Error angular nature", e);
            }
        }
        return false;
    }

    public Collection<BaseModel> getFolders(ITernScriptPath scriptPath) {
        List<BaseModel> folders = this.folders.get(scriptPath);
        if (folders == null) {
            folders = new ArrayList<BaseModel>();
            this.folders.put(scriptPath, folders);
            folders.add(new ScriptsFolder(scriptPath));
            folders.add(new ModulesFolder(scriptPath));
        }
        return folders;
    }

    public void cleanModel() {
        this.folders.clear();
    }

    public Directive getDirective(String tagName, String name, Restriction restriction) {
        return AngularModulesManager.getInstance().getDirective((Object)this, tagName, name, restriction);
    }

    public void collectDirectives(String tagName, String directiveName, List<Directive> existingDirectives, Restriction restriction, IDirectiveCollector collector) {
        AngularModulesManager.getInstance().collectDirectives((Object)this, tagName, directiveName, (IDirectiveSyntax)this, existingDirectives, restriction, collector);
    }

    public boolean isUseOriginalName() {
        return AngularCorePreferencesSupport.getInstance().isDirectiveUseOriginalName(this.getProject());
    }

    public boolean isStartsWithNothing() {
        return AngularCorePreferencesSupport.getInstance().isDirectiveStartsWithNothing(this.getProject());
    }

    public boolean isStartsWithX() {
        return AngularCorePreferencesSupport.getInstance().isDirectiveStartsWithX(this.getProject());
    }

    public boolean isStartsWithData() {
        return AngularCorePreferencesSupport.getInstance().isDirectiveStartsWithData(this.getProject());
    }

    public boolean isColonDelimiter() {
        return AngularCorePreferencesSupport.getInstance().isDirectiveColonDelimiter(this.getProject());
    }

    public boolean isMinusDelimiter() {
        return AngularCorePreferencesSupport.getInstance().isDirectiveMinusDelimiter(this.getProject());
    }

    public boolean isUnderscoreDelimiter() {
        return AngularCorePreferencesSupport.getInstance().isDirectiveUnderscoreDelimiter(this.getProject());
    }

    public String getStartSymbol() {
        return this.startSymbol;
    }

    public String getEndSymbol() {
        return this.endSymbol;
    }

    public void handleEvent(IIDETernProject project, ITernProjectLifecycleListener.LifecycleEventType state) {
        switch (state) {
            case onDisposeAfter: {
                this.dispose();
            }
        }
    }

    private void dispose() {
        this.customDirectives.dispose();
    }
}

