/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.core.utils;

import java.util.Collections;
import java.util.List;
import org.eclipse.angularjs.core.AngularProject;
import org.eclipse.angularjs.core.utils.DOMUtils;
import org.eclipse.angularjs.internal.core.Trace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tern.angular.modules.DOMDirectiveProvider;
import tern.angular.modules.Directive;
import tern.angular.modules.DirectiveParameter;

public class AngularDOMUtils {
    public static boolean isAngularDirective(Node node) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case 2: {
                return AngularDOMUtils.isAngularDirective((IDOMAttr)node);
            }
            case 1: {
                return AngularDOMUtils.isAngularDirective((IDOMElement)node);
            }
        }
        return false;
    }

    public static boolean isAngularDirective(IDOMAttr attr) {
        if (attr == null) {
            return false;
        }
        IProject project = DOMUtils.getFile((IDOMNode)attr).getProject();
        return AngularDOMUtils.getAngularDirective(project, (Attr)attr) != null;
    }

    public static Directive getAngularDirective(IProject project, Attr attr) {
        try {
            AngularProject angularProject = AngularProject.getAngularProject(project);
            return DOMDirectiveProvider.getInstance().getAngularDirective((Object)angularProject, attr);
        }
        catch (CoreException e) {
            Trace.trace((byte)2, "Error while getting angular project", e);
            return null;
        }
    }

    public static Directive getAngularDirectiveByRegion(IDOMNode element, ITextRegion region) {
        IDOMAttr attr = DOMUtils.getAttrByRegion(element, region);
        IProject project = DOMUtils.getFile(element).getProject();
        return AngularDOMUtils.getAngularDirective(project, (Attr)attr);
    }

    public static boolean isAngularDirective(IDOMElement element) {
        if (element == null) {
            return false;
        }
        IProject project = DOMUtils.getFile((IDOMNode)element).getProject();
        return AngularDOMUtils.getAngularDirective(project, (Element)element) != null;
    }

    public static Directive getAngularDirective(IProject project, Element element) {
        try {
            AngularProject angularProject = project != null ? AngularProject.getAngularProject(project) : null;
            return DOMDirectiveProvider.getInstance().getAngularDirective((Object)angularProject, element);
        }
        catch (CoreException e) {
            Trace.trace((byte)2, "Error while getting angular project", e);
            return null;
        }
    }

    public static boolean isAngularDirectiveParameter(IDOMAttr attr) {
        if (attr == null) {
            return false;
        }
        IProject project = DOMUtils.getFile((IDOMNode)attr).getProject();
        return AngularDOMUtils.getAngularDirectiveParameter(project, (Attr)attr) != null;
    }

    public static DirectiveParameter getAngularDirectiveParameter(IProject project, Attr attr) {
        try {
            AngularProject angularProject = project != null ? AngularProject.getAngularProject(project) : null;
            return DOMDirectiveProvider.getInstance().getAngularDirectiveParameter((Object)angularProject, attr);
        }
        catch (CoreException e) {
            Trace.trace((byte)2, "Error while getting angular project", e);
            return null;
        }
    }

    public static boolean hasAngularNature(IDOMNode element) {
        IFile file = DOMUtils.getFile(element);
        if (file == null) {
            return false;
        }
        return AngularProject.hasAngularNature(file.getProject());
    }

    public static Directive getAngularDirective(IProject project, Node node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 2: {
                return AngularDOMUtils.getAngularDirective(project, (Attr)((IDOMAttr)node));
            }
            case 1: {
                return AngularDOMUtils.getAngularDirective(project, (Element)((IDOMElement)node));
            }
        }
        return null;
    }

    public static List<Directive> getAngularDirectives(IProject project, Element element, Attr attr) {
        try {
            AngularProject angularProject = AngularProject.getAngularProject(project);
            return DOMDirectiveProvider.getInstance().getAngularDirectives((Object)angularProject, element, attr);
        }
        catch (CoreException e) {
            Trace.trace((byte)2, "Error while getting angular project", e);
            return Collections.emptyList();
        }
    }
}

