/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.core.utils;

import org.eclipse.angularjs.core.utils.StringUtils;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class HyperlinkUtils {
    public static IRegion getNameRegion(IDOMAttr attr) {
        int regOffset = attr.getNameRegionStartOffset();
        int regLength = attr.getNameRegionText().length();
        return new Region(regOffset, regLength);
    }

    public static IRegion getValueRegion(IDOMAttr attr) {
        int regOffset = attr.getValueRegionStartOffset();
        int regLength = attr.getValueRegionText().length();
        String attValue = attr.getValueRegionText();
        if (StringUtils.isQuoted(attValue)) {
            ++regOffset;
            regLength -= 2;
        }
        return new Region(regOffset, regLength);
    }

    public static IRegion getElementRegion(IDOMElement element) {
        int endOffset = element.hasEndTag() && element.isClosed() ? element.getStartEndOffset() : element.getEndOffset();
        return new Region(element.getStartOffset(), endOffset - element.getStartOffset());
    }

    public static String getExpressionContent(String expr) {
        String expression = expr;
        if (expression.startsWith("{{")) {
            expression = expression.substring("{{".length(), expression.length());
        }
        if (expression.endsWith("}}")) {
            expression = expression.substring(0, expression.length() - "}}".length());
        }
        return expression;
    }
}

