/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class AngularELWordFinder {
    public static IRegion findWord(IDocument document, int offset, String startSymbol, String endSymbol) {
        int start = -2;
        int end = -1;
        char[] ss = startSymbol.toCharArray();
        char[] es = endSymbol.toCharArray();
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c) || AngularELWordFinder.isMatchStartSymbol(ss, c, pos, document)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c) || AngularELWordFinder.isMatchEndSymbol(es, c, pos, document)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    private static boolean isMatchStartSymbol(char[] startSymbol, char c, int pos, IDocument document) throws BadLocationException {
        if (c != startSymbol[startSymbol.length - 1]) {
            return false;
        }
        if (pos >= startSymbol.length) {
            --pos;
            int i = startSymbol.length - 2;
            while (i >= 0) {
                if (startSymbol[i] != document.getChar(pos--)) {
                    return false;
                }
                --i;
            }
            return true;
        }
        return false;
    }

    private static boolean isMatchEndSymbol(char[] endSymbol, char c, int pos, IDocument document) throws BadLocationException {
        if (c != endSymbol[0]) {
            return false;
        }
        int length = document.getLength();
        if (pos + endSymbol.length <= length) {
            ++pos;
            int i = 1;
            while (i < endSymbol.length) {
                if (endSymbol[i] != document.getChar(pos++)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

