/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui.properties;

import java.util.List;
import org.eclipse.angularjs.core.AngularCoreConstants;
import org.eclipse.angularjs.internal.ui.AngularUIMessages;
import org.eclipse.angularjs.internal.ui.ImageResource;
import org.eclipse.angularjs.internal.ui.properties.AbstractAngularFieldEditorPropertyPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import tern.angular.modules.DirectiveHelper;
import tern.angular.modules.IDirectiveSyntax;

public class DirectivesPropertyPage
extends AbstractAngularFieldEditorPropertyPage
implements IDirectiveSyntax {
    public static final String PROP_ID = "org.eclipse.angularjs.internal.ui.properties.DirectivesPropertyPage";
    private Text directiveName;
    private StyledText directives;
    private BooleanFieldEditor useOriginalName;
    private BooleanFieldEditor startsWithNothing;
    private BooleanFieldEditor startsWithX;
    private BooleanFieldEditor startsWithData;
    private BooleanFieldEditor colonDelimiter;
    private BooleanFieldEditor minusDelimiter;
    private BooleanFieldEditor underscoreDelimiter;

    public DirectivesPropertyPage() {
        super(1);
        this.setDescription(AngularUIMessages.DirectivesPropertyPage_desc);
        this.setImageDescriptor(ImageResource.getImageDescriptor("directive"));
    }

    protected void createFieldEditors() {
        Composite parent = super.getFieldEditorParent();
        this.useOriginalName = this.createBooleanFieldEditor("directiveUseOriginalName", AngularUIMessages.DirectivesPropertyPage_useOriginalName_label, parent);
        this.addSeparator(parent);
        this.createStartsWithPanel(parent);
        this.addSeparator(parent);
        this.createDelimitersPanel(parent);
        this.addSeparator(parent);
        this.createTestPanel(parent);
    }

    protected void initialize() {
        super.initialize();
        this.updateTestResult();
    }

    public void createStartsWithPanel(Composite parent) {
        Label startsWithLabel = new Label(parent, 0);
        startsWithLabel.setText(AngularUIMessages.DirectivesPropertyPage_startsWithLabel_text);
        this.startsWithNothing = this.createBooleanFieldEditor(AngularCoreConstants.DIRECTIVE_STARTS_WITH_NOTHING, AngularUIMessages.DirectivesPropertyPage_startsWithNothing_label, parent);
        this.startsWithX = this.createBooleanFieldEditor(AngularCoreConstants.DIRECTIVE_STARTS_WITH_X, AngularUIMessages.DirectivesPropertyPage_startsWithX_label, parent);
        this.startsWithData = this.createBooleanFieldEditor(AngularCoreConstants.DIRECTIVE_STARTS_WITH_DATA, AngularUIMessages.DirectivesPropertyPage_startsWithData_label, parent);
    }

    public void createDelimitersPanel(Composite parent) {
        Label delimitersLabel = new Label(parent, 0);
        delimitersLabel.setText(AngularUIMessages.DirectivesPropertyPage_delimiterLabel_text);
        this.colonDelimiter = this.createBooleanFieldEditor(AngularCoreConstants.DIRECTIVE_COLON_DELIMITER, AngularUIMessages.DirectivesPropertyPage_colonDelimiter_label, parent);
        this.minusDelimiter = this.createBooleanFieldEditor("directiveMinusDelimiter", AngularUIMessages.DirectivesPropertyPage_minusDelimiter_label, parent);
        this.underscoreDelimiter = this.createBooleanFieldEditor("directiveUnderscoreDelimiter", AngularUIMessages.DirectivesPropertyPage_underscoreDelimiter_label, parent);
    }

    private void createTestPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(768));
        panel.setLayout((Layout)new GridLayout(3, false));
        Label directiveTestLabel = new Label(panel, 0);
        directiveTestLabel.setText(AngularUIMessages.DirectivesPropertyPage_directiveTestLabel_text);
        this.directiveName = new Text(panel, 2048);
        this.directiveName.setText("ngBind");
        this.directiveName.setLayoutData((Object)new GridData(768));
        this.directiveName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DirectivesPropertyPage.this.updateTestResult();
            }
        });
        this.directives = new StyledText(parent, 2568);
        this.directives.setLayoutData((Object)new GridData(1808));
        this.directives.setText("");
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
    }

    private BooleanFieldEditor createBooleanFieldEditor(String name, String label, Composite parent) {
        BooleanFieldEditor fieldEditor = new BooleanFieldEditor(name, label, parent){

            protected void valueChanged(boolean oldValue, boolean newValue) {
                super.valueChanged(oldValue, newValue);
                DirectivesPropertyPage.this.updateTestResult();
            }
        };
        this.addField((FieldEditor)fieldEditor);
        return fieldEditor;
    }

    private void updateTestResult() {
        this.directives.setText("");
        StringBuilder s = new StringBuilder();
        List names = DirectiveHelper.getDirectiveNames((String)this.directiveName.getText());
        String name = null;
        int i = 0;
        while (i < names.size()) {
            if (DirectiveHelper.isSupport((IDirectiveSyntax)this, (int)i)) {
                name = (String)names.get(i);
                if (s.length() > 0) {
                    s.append("\n");
                }
                s.append(name);
            }
            ++i;
        }
        this.directives.setText(s.toString());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateTestResult();
    }

    public boolean isUseOriginalName() {
        return this.useOriginalName.getBooleanValue();
    }

    public boolean isStartsWithNothing() {
        return this.startsWithNothing.getBooleanValue();
    }

    public boolean isStartsWithX() {
        return this.startsWithX.getBooleanValue();
    }

    public boolean isStartsWithData() {
        return this.startsWithData.getBooleanValue();
    }

    public boolean isColonDelimiter() {
        return this.colonDelimiter.getBooleanValue();
    }

    public boolean isMinusDelimiter() {
        return this.minusDelimiter.getBooleanValue();
    }

    public boolean isUnderscoreDelimiter() {
        return this.underscoreDelimiter.getBooleanValue();
    }
}

