/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.editor.internal.services;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.jboss.tools.arquillian.editor.internal.model.Arquillian;
import org.jboss.tools.arquillian.editor.internal.model.Container;
import org.jboss.tools.arquillian.editor.internal.model.Group;

public class UniqueQualifierBetweenContainerAndGroupService
extends ValidationService {
    @Text(value="@qualifier must be unique between containers and groups.")
    private static LocalizableText message;
    private Listener listener;

    static {
        LocalizableText.init(UniqueQualifierBetweenContainerAndGroupService.class);
    }

    protected void initValidationService() {
        this.listener = new Listener(){

            public void handle(Event event) {
                UniqueQualifierBetweenContainerAndGroupService.this.refresh();
            }
        };
        Arquillian arquillian = (Arquillian)this.context(Arquillian.class);
        arquillian.attach(this.listener, "Group/Qualifier");
        arquillian.attach(this.listener, "Container/Qualifier");
    }

    public void dispose() {
        super.dispose();
        Arquillian arquillian = (Arquillian)this.context(Arquillian.class);
        arquillian.detach(this.listener, "Group/Qualifier");
        arquillian.detach(this.listener, "Container/Qualifier");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status compute() {
        UniqueQualifierBetweenContainerAndGroupService uniqueQualifierBetweenContainerAndGroupService = this;
        synchronized (uniqueQualifierBetweenContainerAndGroupService) {
            Arquillian arquillian = (Arquillian)this.context(Arquillian.class);
            if (arquillian != null) {
                Set<String> containerQualifiers = this.getContainerQualifiers(arquillian);
                Set<String> groupQualifiers = this.getGroupQualifiers(arquillian);
                for (String qualifier : groupQualifiers) {
                    if (!containerQualifiers.contains(qualifier)) continue;
                    return Status.createErrorStatus((String)message.text());
                }
            }
        }
        return Status.createOkStatus();
    }

    private Set<String> getGroupQualifiers(Arquillian arquillian) {
        HashSet<String> qualifiers = new HashSet<String>();
        Property containerProperty = arquillian.property("Group");
        if (containerProperty instanceof ElementList) {
            ElementList elements = (ElementList)containerProperty;
            for (Element element : elements) {
                SortedSet properties = element.content();
                for (Property property : properties) {
                    String qualifer;
                    Group g;
                    Value<String> qualifierValue;
                    if (!(property.element() instanceof Group) || (qualifierValue = (g = (Group)property.element()).getQualifier()) == null || (qualifer = (String)qualifierValue.content()) == null || qualifer.isEmpty()) continue;
                    qualifiers.add(qualifer);
                }
            }
        }
        return qualifiers;
    }

    private Set<String> getContainerQualifiers(Arquillian arquillian) {
        HashSet<String> qualifiers = new HashSet<String>();
        Property containerProperty = arquillian.property("Container");
        if (containerProperty instanceof ElementList) {
            ElementList elements = (ElementList)containerProperty;
            for (Element element : elements) {
                SortedSet properties = element.content();
                for (Property property : properties) {
                    String qualifer;
                    Container c;
                    Value<String> qualifierValue;
                    if (!(property.element() instanceof Container) || (qualifierValue = (c = (Container)property.element()).getQualifier()) == null || (qualifer = (String)qualifierValue.content()) == null || qualifer.isEmpty()) continue;
                    qualifiers.add(qualifer);
                }
            }
        }
        return qualifiers;
    }
}

