/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.commands;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.arquillian.core.internal.archives.Archive;

public class ExportArchiveCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object object;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof Archive) {
            MessageDialog overwriteDialog;
            String path;
            Archive archive = (Archive)object;
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            dialog.setFileName(archive.getInternalName());
            String name = archive.getInternalName();
            int index = name.indexOf(46);
            if (index >= 0) {
                String extension = "*" + name.substring(index);
                String[] extensions = new String[]{extension};
                dialog.setFilterExtensions(extensions);
            }
            if ((path = dialog.open()) == null) {
                return null;
            }
            File localFile = new File(path);
            if (localFile.exists() && (overwriteDialog = new MessageDialog(this.getShell(), "Export Archive", null, String.valueOf(path) + " already exists. Do you want to replace it?", 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0) {
                return null;
            }
            ExportArchiveCommandHandler.createArchive(archive, localFile);
        }
        return null;
    }

    private Shell getShell() {
        if (Display.getCurrent() != null) {
            return PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static Archive createArchive(Archive archive, File file) {
        block11: {
            javaProject = archive.getJavaProject();
            className = archive.getLocation().getFullyQualifiedName();
            methodName = archive.getLocation().getMethodName();
            loader = ArquillianCoreActivator.getDefault().getClassLoader(javaProject);
            oldLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(loader);
                    clazz = Class.forName(className, true, loader);
                    object = clazz.newInstance();
                    method = clazz.getMethod(methodName, new Class[0]);
                    archiveObject = method.invoke(object, new Object[0]);
                    archiveClass = archiveObject.getClass();
                    exporterClass = Class.forName("org.jboss.shrinkwrap.api.exporter.ZipExporter", true, loader);
                    asMethod = archiveClass.getMethod("as", new Class[]{Class.class});
                    asObject = asMethod.invoke(archiveObject, new Object[]{exporterClass});
                    asClass = asObject.getClass();
                    exportToMethod = asClass.getMethod("exportTo", new Class[]{File.class, Boolean.TYPE});
                    exportToMethod.invoke(asObject, new Object[]{file, Boolean.TRUE});
                    break block11;
                }
                catch (OutOfMemoryError e) {
                    throw new OutOfMemoryError(e.getLocalizedMessage());
                }
                catch (InternalError e) {
                    throw new InternalError(e.getLocalizedMessage());
                }
                catch (StackOverflowError e) {
                    throw new StackOverflowError(e.getLocalizedMessage());
                }
                catch (UnknownError e) {
                    throw new UnknownError(e.getLocalizedMessage());
                }
                catch (Throwable e) {
                    message = String.valueOf(ExportArchiveCommandHandler.getText(e)) + "(project=" + javaProject.getProject().getName() + ")";
                    cause = e.getCause();
                    i = 0;
                    ** while (cause != null && i++ < 5)
                }
lbl-1000:
                // 1 sources

                {
                    message = String.valueOf(ExportArchiveCommandHandler.getText(cause)) + "(project=" + javaProject.getProject().getName() + ")";
                    cause = cause.getCause();
                    continue;
                }
lbl38:
                // 1 sources

                ArquillianCoreActivator.logWarning((String)message);
                if (Platform.inDebugMode()) {
                    ArquillianCoreActivator.log((Throwable)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
        return null;
    }

    private static String getText(Throwable e) {
        String text = e.getLocalizedMessage() == null || e.getLocalizedMessage().isEmpty() ? String.valueOf(e.getClass().getName()) + ": " : e.getLocalizedMessage();
        return text;
    }
}

