/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;

public class RefactoringUtil {
    public static Shell getShell() {
        if (Display.getCurrent() != null) {
            return PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        }
        return null;
    }

    public static String getMissingClassName(IMarker marker) throws CoreException {
        boolean validMarker = "org.jboss.tools.arquillian.core.problem.class".equals(marker.getType());
        if (validMarker) {
            return marker.getAttribute("markerClassName", null);
        }
        return null;
    }

    public static String getQuickFixName(IMarker marker) {
        String name;
        try {
            name = "Add " + RefactoringUtil.getMissingClassName(marker) + " to deployment";
        }
        catch (CoreException e) {
            ArquillianUIActivator.log(e);
            return null;
        }
        return name;
    }

    public static boolean isMissingClassMarker(IMarker marker) {
        try {
            IResource resource;
            String className = RefactoringUtil.getMissingClassName(marker);
            if (className != null && (resource = marker.getResource()) != null && resource.exists()) {
                IProject project = resource.getProject();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType type = javaProject.findType(className);
                return type != null;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

