/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.preferences;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.arquillian.ui.internal.preferences.ArquillianValidatorConfigurationBlock;

public class ArquillianValidatorPreferencePage
extends PropertyAndPreferencePage {
    public static final String PREF_ID = "org.jboss.tools.arquillian.ui.preferences.arquillianValidatorPreferencePage";
    public static final String PROP_ID = "org.jboss.tools.arquillian.ui.propertyPages.arquillianValidatorPreferencePage";
    public static final String DATA_SELECT_OPTION_KEY = "select_option_key";
    public static final String DATA_SELECT_OPTION_QUALIFIER = "select_option_qualifier";
    public static final String USE_PROJECT_SPECIFIC_OPTIONS = "use_project_specific_key";
    private ArquillianValidatorConfigurationBlock fConfigurationBlock;

    public ArquillianValidatorPreferencePage() {
        this.setPreferenceStore(ArquillianCoreActivator.getDefault().getPreferenceStore());
        this.setTitle("Arquillian Validator");
    }

    public void createControl(Composite parent) {
        IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
        this.fConfigurationBlock = new ArquillianValidatorConfigurationBlock(this.getNewStatusChangedListener(), this.getProject(), container);
        super.createControl(parent);
    }

    protected Control createPreferenceContent(Composite composite) {
        return this.fConfigurationBlock.createContents(composite);
    }

    public Point computeSize() {
        Point size = super.computeSize();
        size.y = 10;
        return size;
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        return this.fConfigurationBlock.hasProjectSpecificOptions(project);
    }

    protected String getPreferencePageID() {
        return PREF_ID;
    }

    protected String getPropertyPageID() {
        return PROP_ID;
    }

    public void dispose() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.dispose();
        }
        super.dispose();
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.useProjectSpecificSettings(useProjectSpecificSettings);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performDefaults();
        }
    }

    public boolean performOk() {
        if (this.fConfigurationBlock != null && !this.fConfigurationBlock.performOk()) {
            return false;
        }
        return super.performOk();
    }

    public void performApply() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performApply();
        }
    }

    public void applyData(Object data) {
        super.applyData(data);
        if (data instanceof Map && this.fConfigurationBlock != null) {
            Boolean useProjectOptions;
            Map map = (Map)data;
            if (this.isProjectPreferencePage() && (useProjectOptions = (Boolean)map.get(USE_PROJECT_SPECIFIC_OPTIONS)) != null) {
                this.enableProjectSpecificSettings(useProjectOptions);
            }
            Object key = map.get(DATA_SELECT_OPTION_KEY);
            Object qualifier = map.get(DATA_SELECT_OPTION_QUALIFIER);
            if (key instanceof String && qualifier instanceof String) {
                this.fConfigurationBlock.selectOption((String)key, (String)qualifier);
            }
        }
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.setDescription(null);
    }
}

