/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.forge.arquillian.container.Container;
import org.jboss.forge.arquillian.container.Dependency;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;
import org.jboss.tools.arquillian.core.internal.container.ContainerParser;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.refactoring.AddDependencies;
import org.jboss.tools.arquillian.ui.internal.refactoring.RangeComparator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddArquillianSupportRefactoring
extends Refactoring {
    private IProject project;
    private String version;
    private boolean updatePom;
    private boolean addProfiles;
    private boolean updateBuild;
    private boolean updateDependencies;

    public AddArquillianSupportRefactoring(IProject project) {
        this.project = project;
    }

    public String getName() {
        return "Add Arquillian support";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        boolean isMavenProject;
        boolean bl = isMavenProject = this.project != null && this.project.hasNature("org.eclipse.m2e.core.maven2Nature");
        if (!isMavenProject) {
            Status status = new Status(4, "org.jboss.tools.arquillian.ui", "The project is not a valid maven project");
            return RefactoringStatus.create((IStatus)status);
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = this.checkInitialConditions(pm);
        if (!status.isOK()) {
            return status;
        }
        if (this.isUpdatePom()) {
            IFile file = this.getFile();
            if (file == null || !file.exists()) {
                Status s = new Status(4, "org.jboss.tools.arquillian.ui", "The pom.xml file does not exist");
                return RefactoringStatus.create((IStatus)s);
            }
            IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(this.project, (IProgressMonitor)new NullProgressMonitor());
            if (facade == null) {
                Status s = new Status(4, "org.jboss.tools.arquillian.ui", "The project is not a valid maven project");
                return RefactoringStatus.create((IStatus)s);
            }
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.isUpdatePom()) {
            return new NullChange();
        }
        IFile file = this.getFile();
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(this.project, (IProgressMonitor)new NullProgressMonitor());
        MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
        String version = ArquillianUtility.getArquillianVersion((MavenProject)mavenProject);
        if (version == null) {
            ArrayList<Object> operations = new ArrayList<Object>();
            Model model = ArquillianUtility.getArquilianModel((boolean)true);
            if (this.isUpdateDependencies()) {
                operations.add(new AddProperties("version.arquillian_core", this.getVersion()));
                List dependencies = model.getDependencies();
                operations.add(new AddDependencies(dependencies, mavenProject));
                DependencyManagement dependencyMgmt = model.getDependencyManagement();
                if (dependencyMgmt != null && ((dependencies = dependencyMgmt.getDependencies()) != null || dependencies.size() > 0)) {
                    operations.add(new AddDependencyManagement(dependencies, mavenProject));
                }
            }
            if (this.isUpdateBuild()) {
                Build build = model.getBuild();
                operations.add(new AddPlugins(build, file));
            }
            if (this.isAddProfiles()) {
                operations.add(new AddProfiles(mavenProject));
            }
            PomEdits.CompoundOperation compound = new PomEdits.CompoundOperation(operations.toArray(new PomEdits.Operation[0]));
            return this.createChange(file, (PomEdits.Operation)compound, this.getName());
        }
        return new NullChange();
    }

    private Change createChange(IFile file, PomEdits.Operation operation, String label) throws CoreException {
        IStructuredModel model = null;
        try {
            TextChange change;
            model = StructuredModelManager.getModelManager().getModelForRead(file);
            IStructuredDocument document = model.getStructuredDocument();
            boolean existing = AddArquillianSupportRefactoring.isOpened((IDocument)document);
            IStructuredModel tempModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor("org.eclipse.m2e.core.pomFile");
            tempModel.getStructuredDocument().setText((Object)StructuredModelManager.getModelManager(), document.get());
            IStructuredDocument tempDocument = tempModel.getStructuredDocument();
            PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple((IDOMModel)tempModel, operation)});
            TextChange textChange = change = this.createChange(existing ? null : file, (IDocument)document, (IDocument)tempDocument, label);
            return textChange;
        }
        catch (Exception e) {
            ArquillianUIActivator.log(e);
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.arquillian.ui", "An error occurred creating change", (Throwable)e));
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private TextChange createChange(IFile oldFile, IDocument oldDocument, IDocument newDocument, String label) {
        DocumentChange change = oldFile == null ? new DocumentChange(label, oldDocument) : new TextFileChange(label, oldFile);
        MultiTextEdit textEdit = new MultiTextEdit();
        change.setEdit((TextEdit)textEdit);
        String newText = newDocument.get();
        String oldText = oldDocument.get();
        if (!newText.equals(oldText)) {
            RangeDifference[] differences;
            RangeComparator right = new RangeComparator(oldText);
            RangeComparator left = new RangeComparator(newText);
            RangeDifference[] rangeDifferenceArray = differences = RangeDifferencer.findDifferences((IRangeComparator)right, (IRangeComparator)left);
            int n = differences.length;
            int n2 = 0;
            while (n2 < n) {
                RangeDifference difference = rangeDifferenceArray[n2];
                int rightStart = difference.rightStart();
                int rightEnd = difference.rightEnd();
                String text = newText.substring(rightStart, rightEnd);
                int leftStart = difference.leftStart();
                int leftLength = difference.leftLength();
                textEdit.addChild((TextEdit)new ReplaceEdit(leftStart, leftLength, text));
                ++n2;
            }
        }
        return change;
    }

    private static boolean isOpened(IDocument document) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IDocument doc;
                    IEditorReference ref = iEditorReferenceArray[n6];
                    IEditorPart editor = ref.getEditor(false);
                    if (editor != null && (doc = (IDocument)editor.getAdapter(IDocument.class)) != null && doc.equals(document)) {
                        return true;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private IFile getFile() throws CoreException {
        if (this.project == null || !this.project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
            return null;
        }
        return this.project.getFile("pom.xml");
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isUpdatePom() {
        return this.updatePom;
    }

    public void setUpdatePom(boolean updatePom) {
        this.updatePom = updatePom;
    }

    public boolean isAddProfiles() {
        return this.addProfiles;
    }

    public void setAddProfiles(boolean addProfiles) {
        this.addProfiles = addProfiles;
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean isUpdateBuild() {
        return this.updateBuild;
    }

    public void setUpdateBuild(boolean updateBuild) {
        this.updateBuild = updateBuild;
    }

    public boolean isUpdateDependencies() {
        return this.updateDependencies;
    }

    public void setUpdateDependencies(boolean updateDependencies) {
        this.updateDependencies = updateDependencies;
    }

    private static class AddDependencyManagement
    implements PomEdits.Operation {
        private List<org.apache.maven.model.Dependency> dependencies;
        private MavenProject mavenProject;

        public AddDependencyManagement(List<org.apache.maven.model.Dependency> dependencies, MavenProject mavenProject) {
            this.dependencies = dependencies;
            this.mavenProject = mavenProject;
        }

        public void process(Document document) {
            Parent parent;
            List pmd;
            if (this.dependencies == null || this.dependencies.size() <= 0) {
                return;
            }
            ArrayList allDependencies = new ArrayList();
            DependencyManagement pdMgmt = this.mavenProject.getDependencyManagement();
            if (pdMgmt != null && (pmd = pdMgmt.getDependencies()) != null) {
                allDependencies.addAll(pmd);
            }
            if ((parent = this.mavenProject.getModel().getParent()) != null) {
                try {
                    ArquillianUtility.addManagedDependencies(allDependencies, (String)parent.getGroupId(), (String)parent.getArtifactId(), (String)parent.getVersion());
                }
                catch (CoreException e) {
                    ArquillianUIActivator.log(e);
                }
            }
            Element root = document.getDocumentElement();
            Element dependencyMgmtEl = PomEdits.getChild((Element)root, (String[])new String[]{"dependencyManagement"});
            Element dependenciesEl = PomEdits.getChild((Element)dependencyMgmtEl, (String[])new String[]{"dependencies"});
            for (org.apache.maven.model.Dependency dependency : this.dependencies) {
                if (ArquillianUtility.managedDependencyExists((org.apache.maven.model.Dependency)dependency, allDependencies)) continue;
                PomHelper.addOrUpdateDependency((Element)dependenciesEl, (String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getVersion(), (String)dependency.getType(), (String)dependency.getScope(), (String)dependency.getClassifier());
            }
        }
    }

    private static class AddPlugins
    implements PomEdits.Operation {
        private Build build;
        private IFile file;

        public AddPlugins(Build build, IFile file) {
            this.build = build;
            this.file = file;
        }

        public void process(Document document) {
            Element buildEl;
            block12: {
                if (this.build == null) {
                    return;
                }
                List plugins = this.build.getPlugins();
                Element root = document.getDocumentElement();
                buildEl = PomEdits.getChild((Element)root, (String[])new String[]{"build"});
                Element pluginsEl = PomEdits.getChild((Element)buildEl, (String[])new String[]{"plugins"});
                IDOMModel model = null;
                try {
                    try {
                        model = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(this.file);
                        if (model == null) {
                            model = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(this.file);
                        }
                        for (Plugin plugin : plugins) {
                            if (ArquillianUtility.pluginExists((IDOMModel)model, (Plugin)plugin)) continue;
                            PomHelper.createPlugin((Element)pluginsEl, (String)plugin.getGroupId(), (String)plugin.getArtifactId(), (String)plugin.getVersion());
                        }
                        Element compiler = null;
                        List elements = PomEdits.findChilds((Element)pluginsEl, (String)"plugin");
                        for (Element element : elements) {
                            String gid;
                            Element pluginArtifactId = PomEdits.findChild((Element)element, (String)"artifactId");
                            String aid = PomEdits.getTextValue((Node)pluginArtifactId);
                            Element pluginGroupId = PomEdits.findChild((Element)element, (String)"groupId");
                            String string = gid = pluginGroupId == null ? "org.apache.maven.plugins" : PomEdits.getTextValue((Node)pluginGroupId);
                            if (!"maven-compiler-plugin".equals(aid) || !"org.apache.maven.plugins".equals(gid)) continue;
                            compiler = element;
                            break;
                        }
                        ArquillianUtility.fixCompilerPlugin(compiler);
                    }
                    catch (Exception e) {
                        ArquillianCoreActivator.log((Throwable)e);
                        if (model != null) {
                            model.releaseFromRead();
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (model != null) {
                        model.releaseFromRead();
                    }
                    throw throwable;
                }
                if (model != null) {
                    model.releaseFromRead();
                }
            }
            PomEdits.format((Node)buildEl);
        }
    }

    private static class AddProfiles
    implements PomEdits.Operation {
        private MavenProject mavenProject;

        public AddProfiles(MavenProject mavenProject) {
            this.mavenProject = mavenProject;
        }

        public void process(Document document) {
            List allProfiles;
            List selectedProfiles = ArquillianUtility.getProfilesFromPreferences((String)"selectedArquillianProfiles");
            if (selectedProfiles == null || selectedProfiles.size() <= 0) {
                return;
            }
            ArrayList<Container> selectedContainers = new ArrayList<Container>();
            Model projectModel = this.mavenProject.getModel();
            try {
                allProfiles = ArquillianUtility.getProfiles((Model)projectModel);
            }
            catch (CoreException e) {
                ArquillianUIActivator.log(e);
                return;
            }
            for (Container container : ContainerParser.getContainers()) {
                if (!selectedProfiles.contains(container.getId()) || allProfiles.contains(container.getId())) continue;
                selectedContainers.add(container);
            }
            if (selectedContainers.size() <= 0) {
                return;
            }
            Element root = document.getDocumentElement();
            Element profiles = PomEdits.getChild((Element)root, (String[])new String[]{"profiles"});
            for (Container container : selectedContainers) {
                this.generateProfile(profiles, container);
            }
        }

        private void generateProfile(Element profiles, Container container) {
            if (container == null) {
                return;
            }
            String id = container.getId();
            Element profile = PomEdits.createElement((Element)profiles, (String)"profile");
            Element idEl = PomEdits.getChild((Element)profile, (String[])new String[]{"id"});
            PomEdits.setText((Element)idEl, (String)id);
            Element dependencies = PomEdits.getChild((Element)profile, (String[])new String[]{"dependencies"});
            String version = this.getVersion(container.getGroup_id(), container.getArtifact_id());
            PomHelper.addOrUpdateDependency((Element)dependencies, (String)container.getGroup_id(), (String)container.getArtifact_id(), (String)version, null, null, null);
            List deps = container.getDependencies();
            if (deps != null) {
                for (Dependency fd : deps) {
                    version = this.getVersion(fd.getGroup_id(), fd.getArtifact_id());
                    PomHelper.addOrUpdateDependency((Element)dependencies, (String)fd.getGroup_id(), (String)fd.getArtifact_id(), (String)version, null, null, null);
                }
            }
            PomEdits.format((Node)profile);
        }

        private String getVersion(String gid, String aid) {
            String coords = String.valueOf(gid) + ":" + aid + ":[0,)";
            return ArquillianUtility.getHighestVersion((String)coords);
        }
    }

    private static class AddProperties
    implements PomEdits.Operation {
        private final String name;
        private final String value;

        public AddProperties(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public void process(Document document) {
            Element props = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"properties"});
            Element existing = PomEdits.findChild((Element)props, (String)this.name);
            if (existing == null) {
                existing = document.createElement(this.name);
                existing.appendChild(document.createTextNode(this.value));
                props.appendChild(existing);
                PomEdits.format((Node)existing);
            } else {
                PomEdits.setText((Element)existing, (String)this.value);
            }
        }
    }
}

