/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.refactoring;

import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.refactoring.AddArquillianSupportRefactoring;

public class AddArquillianSupportWizardPage
extends UserInputWizardPage {
    private static final String[] defaultVersions = new String[]{"1.1.2.Final"};
    private AddArquillianSupportRefactoring refactoring;
    private Combo versionCombo;
    private Button updatePomButton;
    private Button addProfilesButton;
    private static final String UPDATE_POM = "updatePom";
    private static final String ADD_PROFILES = "addProfiles";
    private static final String UPDATE_BUILD = "updateBuild";
    private static final String UPDATE_DEPENDENCIES = "updateDependencies";
    private static final String ADD_ARQUILLIAN_SUPPORT_SECTION = "addArquillianSupportSection";
    private IDialogSettings dialogSettings;
    private IDialogSettings addArquillianSupportSection;
    private Button updateBuildButton;
    private Button updateDependenciesButton;

    public AddArquillianSupportWizardPage(AddArquillianSupportRefactoring refactoring) {
        super(refactoring.getName());
        this.refactoring = refactoring;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        composite.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        Link link = new Link(composite, 0);
        link.setText("<a>Arquillian Settings</a>");
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        link.setLayoutData((Object)gd);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)AddArquillianSupportWizardPage.this.getShell(), (String)"org.jboss.tools.arquillian.ui.preferences.arquillianPreferencePage", null, null);
                preferenceDialog.open();
            }
        });
        Label label = new Label(composite, 0);
        gd = new GridData(4, 4, true, false);
        label.setLayoutData((Object)gd);
        label.setText("Arquillian version:");
        this.versionCombo = new Combo(composite, 8);
        gd = new GridData(4, 4, false, false);
        this.versionCombo.setLayoutData((Object)gd);
        this.versionCombo.setItems(ArquillianUtility.getVersions((String[])defaultVersions));
        String value = ArquillianUtility.getPreference((String)"arquillianVersion", (String)"1.1.2.Final");
        this.versionCombo.setText(value);
        this.refactoring.setVersion(value);
        this.versionCombo.setLayoutData((Object)new GridData(768));
        this.versionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddArquillianSupportWizardPage.this.refactoring.setVersion(AddArquillianSupportWizardPage.this.versionCombo.getText());
                AddArquillianSupportWizardPage.this.validate();
            }
        });
        this.updatePomButton = new Button(composite, 32);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.updatePomButton.setText("Update the pom.xml file");
        this.updatePomButton.setLayoutData((Object)gd);
        this.dialogSettings = ArquillianUIActivator.getDefault().getDialogSettings();
        this.addArquillianSupportSection = this.dialogSettings.getSection(ADD_ARQUILLIAN_SUPPORT_SECTION);
        if (this.addArquillianSupportSection == null) {
            this.addArquillianSupportSection = this.dialogSettings.addNewSection(ADD_ARQUILLIAN_SUPPORT_SECTION);
        }
        boolean updatePom = (value = this.addArquillianSupportSection.get(UPDATE_POM)) == null ? true : this.addArquillianSupportSection.getBoolean(UPDATE_POM);
        this.updatePomButton.setSelection(updatePom);
        this.updateDependenciesButton = new Button(composite, 32);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.updateDependenciesButton.setText("Update the dependencies section");
        this.updateDependenciesButton.setLayoutData((Object)gd);
        value = this.addArquillianSupportSection.get(UPDATE_DEPENDENCIES);
        boolean updateDependencies = value == null ? true : this.addArquillianSupportSection.getBoolean(UPDATE_DEPENDENCIES);
        this.updateDependenciesButton.setSelection(updateDependencies);
        this.updateDependenciesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddArquillianSupportWizardPage.this.refactoring.setUpdateDependencies(AddArquillianSupportWizardPage.this.updateDependenciesButton.getSelection());
                AddArquillianSupportWizardPage.this.validate();
            }
        });
        this.updateBuildButton = new Button(composite, 32);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.updateBuildButton.setText("Update the build section");
        this.updateBuildButton.setLayoutData((Object)gd);
        value = this.addArquillianSupportSection.get(UPDATE_BUILD);
        boolean updateBuild = value == null ? true : this.addArquillianSupportSection.getBoolean(UPDATE_BUILD);
        this.updateBuildButton.setSelection(updateBuild);
        this.updateBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddArquillianSupportWizardPage.this.refactoring.setUpdateBuild(AddArquillianSupportWizardPage.this.updateBuildButton.getSelection());
                AddArquillianSupportWizardPage.this.validate();
            }
        });
        this.addProfilesButton = new Button(composite, 32);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.addProfilesButton.setText("Add Profiles");
        this.addProfilesButton.setLayoutData((Object)gd);
        value = this.addArquillianSupportSection.get(ADD_PROFILES);
        boolean addProfiles = value == null ? true : this.addArquillianSupportSection.getBoolean(ADD_PROFILES);
        this.addProfilesButton.setSelection(addProfiles);
        this.addProfilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddArquillianSupportWizardPage.this.refactoring.setAddProfiles(AddArquillianSupportWizardPage.this.addProfilesButton.getSelection());
                AddArquillianSupportWizardPage.this.validate();
            }
        });
        this.updatePomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddArquillianSupportWizardPage.this.updatePomChanged();
            }
        });
        String message = null;
        try {
            IProject project = this.refactoring.getProject();
            IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project, (IProgressMonitor)new NullProgressMonitor());
            if (facade != null) {
                MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                String version = ArquillianUtility.getArquillianVersion((MavenProject)mavenProject);
                if (version != null) {
                    this.updatePomButton.setSelection(false);
                    this.updatePomButton.setEnabled(false);
                    message = "The project already includes Arquillian settings";
                }
            } else {
                this.updatePomButton.setSelection(false);
                this.updatePomButton.setEnabled(false);
                message = "The project is not a valid maven project";
            }
        }
        catch (CoreException e1) {
            this.updatePomButton.setSelection(false);
            this.updatePomButton.setEnabled(false);
            message = "Some issues encountered.\nCaused by: " + e1.getLocalizedMessage();
        }
        if (message != null) {
            Composite warningComposite = new Composite(composite, 0);
            gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            warningComposite.setLayoutData((Object)gd);
            warningComposite.setLayout((Layout)new GridLayout(2, false));
            Label emptyLabel = new Label(warningComposite, 0);
            gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 2;
            emptyLabel.setLayoutData((Object)gd);
            Label warningImage = new Label(warningComposite, 0);
            gd = new GridData(4, 16384, false, false);
            warningImage.setLayoutData((Object)gd);
            warningImage.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
            Label warningText = new Label(warningComposite, 0);
            gd = new GridData(4, 4, true, false);
            warningText.setLayoutData((Object)gd);
            warningText.setText(message);
        }
        this.updatePomChanged();
        this.setControl((Control)composite);
        this.validate();
    }

    private void updatePomChanged() {
        boolean enabled = this.updatePomButton.getSelection();
        this.versionCombo.setEnabled(enabled);
        this.addProfilesButton.setEnabled(enabled);
        this.updateBuildButton.setEnabled(enabled);
        this.updateDependenciesButton.setEnabled(enabled);
        this.refactoring.setUpdatePom(enabled);
        this.refactoring.setVersion(this.versionCombo.getText());
        this.refactoring.setAddProfiles(enabled && this.addProfilesButton.getSelection());
        this.refactoring.setUpdateBuild(this.updateBuildButton.getSelection());
        this.refactoring.setUpdateDependencies(this.updateDependenciesButton.getSelection());
    }

    private void validate() {
    }

    protected boolean performFinish() {
        this.addArquillianSupportSection.put(UPDATE_POM, this.updatePomButton.getSelection());
        this.addArquillianSupportSection.put(ADD_PROFILES, this.addProfilesButton.getSelection());
        this.addArquillianSupportSection.put(UPDATE_BUILD, this.updateBuildButton.getSelection());
        this.addArquillianSupportSection.put(UPDATE_DEPENDENCIES, this.updateDependenciesButton.getSelection());
        return super.performFinish();
    }
}

