/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class FixArchiveNameRefactoring
extends Refactoring {
    private IMarker marker;
    private String newArchiveName;
    private String oldArchiveName;
    private String extension;
    private int offset;
    private int len;

    public FixArchiveNameRefactoring(IMarker marker) {
        this.marker = marker;
    }

    public String getName() {
        return "Fix Archive Name";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        boolean invalidMarker = false;
        if (this.marker == null || !(this.marker.getResource() instanceof IFile) || !"org.jboss.tools.arquillian.core.problem.invalidArchiveName".equals(this.marker.getType())) {
            invalidMarker = true;
        } else {
            this.offset = this.marker.getAttribute("charStart", 0);
            int end = this.marker.getAttribute("charEnd", 0);
            this.len = end - this.offset;
            this.oldArchiveName = this.marker.getAttribute("oldArchiveName", null);
            this.extension = this.marker.getAttribute("archiveExtension", null);
            if (this.offset <= 0 || end <= 0 || this.len <= 0 || this.oldArchiveName == null || this.oldArchiveName.isEmpty() || this.extension == null || this.extension.isEmpty()) {
                invalidMarker = true;
            } else {
                int index = this.oldArchiveName.lastIndexOf(".");
                this.newArchiveName = index == -1 ? String.valueOf(this.oldArchiveName) + this.extension : String.valueOf(this.oldArchiveName.substring(0, index)) + this.extension;
            }
        }
        if (invalidMarker) {
            Status status = new Status(4, "org.jboss.tools.arquillian.ui", "Invalid marker");
            return RefactoringStatus.create((IStatus)status);
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public String getExtension() {
        return this.extension;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IFile file = this.getFile();
        TextFileChange result = new TextFileChange(file.getName(), file);
        MultiTextEdit rootEdit = new MultiTextEdit();
        result.setEdit((TextEdit)rootEdit);
        ReplaceEdit edit = new ReplaceEdit(this.offset, this.len, this.newArchiveName);
        rootEdit.addChild((TextEdit)edit);
        return result;
    }

    private IFile getFile() {
        IFile file = (IFile)this.marker.getResource();
        return file;
    }

    public String getNewArchiveName() {
        return this.newArchiveName;
    }

    public void setNewArchiveName(String newArchiveName) {
        this.newArchiveName = newArchiveName;
    }

    public String getOldArchiveName() {
        return this.oldArchiveName;
    }
}

