/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.util.ModelVisitor;

public class ClearEObjectReferences
implements ModelVisitor {
    private final EObject refdObject;
    private final Set affectedObjects;

    public ClearEObjectReferences(EObject refdObject) {
        CoreArgCheck.isNotNull((Object)refdObject);
        this.refdObject = refdObject;
        this.affectedObjects = new HashSet();
    }

    @Override
    public boolean visit(EObject object) {
        EClass eclass = object.eClass();
        EList allRefs = eclass.getEAllReferences();
        for (EReference reference : allRefs) {
            if (reference.isContainment() || reference.isContainer() || reference.isVolatile()) continue;
            Object value = object.eGet((EStructuralFeature)reference, false);
            if (reference.isMany()) {
                boolean removeRefdValue = false;
                for (Object valueInList : (List)value) {
                    if (!(valueInList instanceof EObject) || valueInList != this.refdObject) continue;
                    removeRefdValue = true;
                }
                if (!removeRefdValue || !reference.isChangeable()) continue;
                ((List)value).remove(this.refdObject);
                this.affectedObjects.add(object);
                continue;
            }
            if (!(value instanceof EObject) || value != this.refdObject || !reference.isChangeable()) continue;
            object.eUnset((EStructuralFeature)reference);
            this.affectedObjects.add(object);
        }
        return true;
    }

    @Override
    public boolean visit(Resource resource) {
        return resource != null;
    }

    public Collection getAffectedObjects() {
        return this.affectedObjects;
    }
}

