/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core;

import java.util.ArrayList;
import org.osgi.framework.Bundle;
import org.teiid.designer.core.ExtensionDescriptor;
import org.teiid.designer.core.ExtensionDescriptorImpl;

public class ExtensionMultiDescriptorImpl
extends ExtensionDescriptorImpl {
    private ArrayList children = new ArrayList();

    public ExtensionMultiDescriptorImpl(Object id, String className, Bundle bundle) {
        super(id, className, bundle);
    }

    @Override
    public ExtensionDescriptor[] getChildren() {
        if (this.children == null || this.children.size() == 0) {
            return EMPTY_ARRAY;
        }
        ExtensionDescriptor[] result = new ExtensionDescriptor[this.children.size()];
        this.children.toArray(result);
        return result;
    }

    @Override
    public boolean isMultiDescriptor() {
        return true;
    }

    @Override
    public ExtensionDescriptor getChildDescriptor(Object id) {
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        int i = 0;
        int n = this.children.size();
        while (i < n) {
            ExtensionDescriptor descriptor = (ExtensionDescriptor)this.children.get(i);
            Object descriptorId = descriptor.getId();
            if (descriptorId != null && descriptorId.equals(id)) {
                return descriptor;
            }
            ++i;
        }
        return null;
    }

    public void addDescriptor(ExtensionDescriptor descriptor) {
        Object descriptorId;
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if ((descriptorId = descriptor.getId()) != null && this.getChildDescriptor(descriptorId) != null) {
            this.children.remove(this.getChildDescriptor(descriptorId));
        }
        this.children.add(descriptor);
    }
}

