/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassSet;

public class FindRelatedObjectsToBeCopied
implements ModelVisitor {
    private final Set objectsToBeCopied = new HashSet();
    private final Map modelContentsByResource = new HashMap();

    public void addModelContents(ModelContents contents, Resource emfResource) {
        CoreArgCheck.isNotNull((Object)contents);
        CoreArgCheck.isNotNull((Object)emfResource);
        this.modelContentsByResource.put(emfResource, contents);
    }

    public ModelContents getModelContents(Resource emfResource) {
        ModelContents result = (ModelContents)this.modelContentsByResource.get(emfResource);
        if (result == null && emfResource instanceof EmfResource && (result = ((EmfResource)emfResource).getModelContents()) != null) {
            this.addModelContents(result, emfResource);
        }
        return result;
    }

    @Override
    public boolean visit(EObject object) {
        ModelContents modelContents;
        if (object instanceof Annotation) {
            return true;
        }
        Resource emfResource = object.eResource();
        if (emfResource != null && (modelContents = this.getModelContents(emfResource)) != null) {
            this.addAnnotation(object, modelContents);
            this.addTransformations(object, modelContents);
            this.addMappings(object, modelContents);
        }
        return true;
    }

    protected void addMappings(EObject object, ModelContents modelContents) {
        List mappingClassSets = modelContents.getMappingClassSets(object);
        if (mappingClassSets != null && mappingClassSets.size() != 0) {
            this.objectsToBeCopied.addAll(mappingClassSets);
            for (MappingClassSet mcSet : mappingClassSets) {
                EList mappingClasses = mcSet.getMappingClasses();
                for (MappingClass mc : mappingClasses) {
                    this.addAnnotation((EObject)mc, modelContents);
                    this.addTransformations((EObject)mc, modelContents);
                }
            }
        }
    }

    protected void addTransformations(EObject object, ModelContents modelContents) {
        List transformations = modelContents.getTransformationsForOutput(object);
        if (transformations != null && transformations.size() != 0) {
            this.objectsToBeCopied.addAll(transformations);
        }
    }

    protected void addAnnotation(EObject object, ModelContents modelContents) {
        Annotation existingAnnotation = modelContents.getAnnotation(object);
        if (existingAnnotation != null) {
            this.objectsToBeCopied.add(existingAnnotation);
        }
    }

    @Override
    public boolean visit(Resource resource) {
        return resource != null;
    }

    public Collection getAdditionalObjects() {
        return this.objectsToBeCopied;
    }
}

