/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.TransformationPreferences;

public class TransformationPreferencesImpl
implements TransformationPreferences {
    public static boolean HEADLESS = false;
    private static int DEFAULT_LENGTH = 0;
    private static int UPPER_RECURSION_LIMIT = 10;
    private static boolean DEFAULT_REMOVE_ATTRIBUTES_VALUE = false;
    private boolean hasInitialized = false;

    private void initializeDefaultsIfNeeded() {
        boolean bol;
        if (HEADLESS) {
            return;
        }
        IEclipsePreferences defaultPrefs = ModelerCore.getDefaultPreferences("org.teiid.designer.core");
        int val = defaultPrefs.getInt("transformationPreferences.defaultStringLength", 0);
        if (val == 0) {
            defaultPrefs.putInt("transformationPreferences.defaultStringLength", DEFAULT_LENGTH);
        }
        if ((val = defaultPrefs.getInt("transformationPreferences.upperRecursionLimit", 0)) == 0) {
            defaultPrefs.putInt("transformationPreferences.upperRecursionLimit", UPPER_RECURSION_LIMIT);
        }
        if (!(bol = defaultPrefs.getBoolean("transformationPreferences.removeDuplicateAttributes", false))) {
            defaultPrefs.putBoolean("transformationPreferences.removeDuplicateAttributes", DEFAULT_REMOVE_ATTRIBUTES_VALUE);
        }
        this.save();
    }

    @Override
    public int getDefaultStringLength() {
        if (HEADLESS) {
            return DEFAULT_LENGTH;
        }
        if (!this.hasInitialized) {
            this.initializeDefaultsIfNeeded();
            this.hasInitialized = true;
        }
        return this.getPreferences().getInt("transformationPreferences.defaultStringLength", DEFAULT_LENGTH);
    }

    @Override
    public int getDefaultStringLengthDefault() {
        return DEFAULT_LENGTH;
    }

    @Override
    public void setDefaultStringLength(int val) {
        if (HEADLESS) {
            return;
        }
        this.getPreferences().putInt("transformationPreferences.defaultStringLength", val);
        this.save();
    }

    @Override
    public void setUpperRecursionLimit(int val) {
        if (HEADLESS) {
            return;
        }
        this.getPreferences().putInt("transformationPreferences.upperRecursionLimit", val);
        this.save();
    }

    @Override
    public int getUpperRecursionLimit() {
        if (HEADLESS) {
            return UPPER_RECURSION_LIMIT;
        }
        if (!this.hasInitialized) {
            this.initializeDefaultsIfNeeded();
            this.hasInitialized = true;
        }
        return this.getPreferences().getInt("transformationPreferences.upperRecursionLimit", UPPER_RECURSION_LIMIT);
    }

    @Override
    public int getUpperRecursionLimitDefault() {
        return UPPER_RECURSION_LIMIT;
    }

    @Override
    public boolean getRemoveDuplicateAttibutes() {
        if (HEADLESS) {
            return DEFAULT_REMOVE_ATTRIBUTES_VALUE;
        }
        if (!this.hasInitialized) {
            this.initializeDefaultsIfNeeded();
            this.hasInitialized = true;
        }
        return this.getPreferences().getBoolean("transformationPreferences.removeDuplicateAttributes", DEFAULT_REMOVE_ATTRIBUTES_VALUE);
    }

    @Override
    public boolean getRemoveDuplicateAttibutesDefault() {
        return DEFAULT_REMOVE_ATTRIBUTES_VALUE;
    }

    @Override
    public void setRemoveDuplicateAttibutes(boolean val) {
        if (HEADLESS) {
            return;
        }
        this.getPreferences().putBoolean("transformationPreferences.removeDuplicateAttributes", val);
        this.save();
    }

    private IEclipsePreferences getPreferences() {
        return ModelerCore.getPreferences("org.teiid.designer.core");
    }

    private void save() {
        try {
            ModelerCore.savePreferences("org.teiid.designer.core");
        }
        catch (BackingStoreException e) {
            ModelerCore.Util.log((Throwable)e);
        }
    }
}

