/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.EclipseConfigurationBuilder;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.ValidationDescriptor;
import org.teiid.designer.core.ValidationPreferences;

public class ValidationPreferencesImpl
implements ValidationPreferences {
    public static boolean HEADLESS = false;
    private static char DELIMITER = (char)46;
    private static final List validationDescriptors = EclipseConfigurationBuilder.readValidationDescriptors();
    private static final Set optionNames = ValidationPreferencesImpl.getOptionNames(validationDescriptors);

    private static Set getOptionNames(List descriptors) {
        HashSet<String> rv = new HashSet<String>();
        for (ValidationDescriptor vdesc : descriptors) {
            String name = ValidationPreferencesImpl.getFullName(vdesc);
            rv.add(name);
        }
        return rv;
    }

    private static String getFullName(ValidationDescriptor vdesc) {
        String descID = vdesc.getExtensionID();
        String descName = vdesc.getPreferenceName();
        return String.valueOf(descID) + DELIMITER + descName;
    }

    public ValidationPreferencesImpl() {
        List descriptors = this.getValidationDescriptors();
        if (descriptors != null && !descriptors.isEmpty()) {
            int size = descriptors.size();
            HashMap<ValidationDescriptor, String> changeMap = new HashMap<ValidationDescriptor, String>(size);
            int i = 0;
            while (i < size) {
                ValidationDescriptor descriptor = (ValidationDescriptor)descriptors.get(i);
                String value = this.getCurrentPreferenceValue(descriptor);
                if (CoreStringUtil.isEmpty((String)value)) {
                    value = descriptor.getDefaultOption();
                }
                changeMap.put(descriptor, value);
                ++i;
            }
            this.setOptions(changeMap);
        }
    }

    private String getCurrentPreferenceValue(ValidationDescriptor theDescriptor) {
        IEclipsePreferences prefs = ModelerCore.getPreferences("org.teiid.designer.core");
        return prefs.get(ValidationPreferencesImpl.getFullName(theDescriptor), "");
    }

    @Override
    public List getValidationDescriptors() {
        return validationDescriptors;
    }

    @Override
    public void setOptions(Map newOptions) {
        IEclipsePreferences preferences = ModelerCore.getPreferences("org.teiid.designer.core");
        for (ValidationDescriptor key : newOptions.keySet()) {
            Object value;
            String name = ValidationPreferencesImpl.getFullName(key);
            if (!optionNames.contains(name) || (value = newOptions.get(key)) == null) continue;
            preferences.put(name, this.getValidOption((String)value));
        }
        try {
            ModelerCore.savePreferences("org.teiid.designer.core");
        }
        catch (BackingStoreException e) {
            ModelerCore.Util.log((Throwable)e);
        }
    }

    @Override
    public Map getOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        if (ModelerCore.getPlugin() != null) {
            IEclipsePreferences preferences = ModelerCore.getPreferences("org.teiid.designer.core");
            IEclipsePreferences defaultPrefs = ModelerCore.getDefaultPreferences("org.teiid.designer.core");
            try {
                String[] propertyNames = preferences.keys();
                int i = 0;
                while (i < propertyNames.length) {
                    String propertyName = propertyNames[i];
                    if (optionNames.contains(propertyName)) {
                        String value = preferences.get(propertyName, defaultPrefs.get(propertyName, ValidationPreferencesImpl.getDefaultValue(propertyName)));
                        options.put(propertyName, value.trim());
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                ModelerCore.Util.log((Throwable)e);
            }
        }
        return options;
    }

    private static String getDefaultValue(String propertyName) {
        int size = validationDescriptors.size();
        int i = 0;
        while (i < size) {
            ValidationDescriptor desc = (ValidationDescriptor)validationDescriptors.get(i);
            if (desc.getPreferenceName().equals(propertyName)) {
                return desc.getDefaultOption();
            }
            ++i;
        }
        return null;
    }

    private String getValidOption(String value) {
        if (value.equalsIgnoreCase("error") || value.equalsIgnoreCase("ignore") || value.equalsIgnoreCase("info") || value.equalsIgnoreCase("warning")) {
            return value;
        }
        return "ignore";
    }
}

