/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.builder;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.runtime.spi.ITeiidServerManager;

public abstract class AbstractTeiidProjectBuilder
extends IncrementalProjectBuilder {
    protected abstract IProject[] buildInternal(int var1, Map<String, String> var2, IProgressMonitor var3) throws CoreException;

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (ModelerCore.getTeiidServerManager().isStarted()) {
            return this.buildInternal(kind, args, monitor);
        }
        BuildingThread thread = new BuildingThread(kind, args, monitor);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException ex) {
            ModelerCore.Util.log((Throwable)ex);
        }
        if (thread.getBuildException() != null) {
            throw thread.getBuildException();
        }
        return thread.getBuildResult();
    }

    private class BuildingThread
    extends Thread {
        private final int kind;
        private final Map<String, String> args;
        private final IProgressMonitor monitor;
        private IProject[] buildResult;
        private CoreException buildException;

        public BuildingThread(int kind, Map<String, String> args, IProgressMonitor monitor) {
            super(String.valueOf(AbstractTeiidProjectBuilder.class.getSimpleName()) + "." + BuildingThread.class.getSimpleName());
            this.kind = kind;
            this.args = args;
            this.monitor = monitor;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            ITeiidServerManager serverManager = ModelerCore.getTeiidServerManager();
            while (!serverManager.isStarted()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    ModelerCore.Util.log((Throwable)ex);
                }
            }
            try {
                this.buildResult = AbstractTeiidProjectBuilder.this.buildInternal(this.kind, this.args, this.monitor);
            }
            catch (CoreException ex) {
                this.buildException = ex;
            }
        }

        IProject[] getBuildResult() {
            return this.buildResult;
        }

        CoreException getBuildException() {
            return this.buildException;
        }
    }
}

