/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.builder;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.ResourceValidator;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.Validator;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspace;

public class XmiResourceValidator
implements ResourceValidator {
    @Override
    public boolean isValidatorForObject(Object obj) {
        if (obj instanceof IResource) {
            return this.isValidatorForResource((IResource)obj);
        }
        return obj instanceof EmfResource;
    }

    @Override
    public void validate(IProgressMonitor monitor, Object obj, ValidationContext context) throws ModelerCoreException {
        EmfResource eResource;
        IProgressMonitor progressMonitor;
        if (!this.isValidatorForObject(obj)) {
            Object[] params = new Object[]{this.getClass().getName(), obj != null ? obj.getClass().getName() : null};
            String msg = ModelerCore.Util.getString("XmiResourceValidator.validator_cannot_be_used_to_validate_the_object", params);
            throw new ModelerCoreException(msg);
        }
        Object object = progressMonitor = monitor != null ? monitor : new NullProgressMonitor();
        if (obj instanceof IResource) {
            IResource iResource = (IResource)obj;
            ModelWorkspace workspace = ModelerCore.getModelWorkspace();
            ModelResource mResource = workspace.findModelResource(iResource);
            if (mResource != null) {
                Resource eResource2 = mResource.getEmfResource();
                this.validate(progressMonitor, eResource2, iResource, context);
            }
        } else if (obj instanceof EmfResource && (eResource = (EmfResource)obj).isLoaded()) {
            try {
                Validator.validate(monitor, eResource, context);
            }
            catch (Throwable e) {
                String msg = ModelerCore.Util.getString("ModelBuilder.Error_validating_model_resource_2", (Object)eResource);
                ModelerCore.Util.log(4, e, msg);
            }
        }
    }

    @Override
    public void addMarkers(ValidationContext context, IResource iResource) throws ModelerCoreException {
        if (context != null && context.hasResults()) {
            List results = context.getValidationResults();
            try {
                for (ValidationResult result : results) {
                    if (result == null || !result.hasProblems()) continue;
                    ValidationProblem[] problems = result.getProblems();
                    String rsltLocationPath = result.getLocationPath();
                    String rsltLocationUri = result.getLocationUri();
                    String targetUri = result.getTargetUri();
                    int probCnt = 0;
                    while (probCnt < problems.length) {
                        String probURI;
                        String probLocPath = problems[probCnt].getLocation();
                        if (probLocPath == null) {
                            probLocPath = rsltLocationPath;
                        }
                        if ((probURI = problems[probCnt].getURI()) == null) {
                            probURI = rsltLocationUri;
                        }
                        this.createProblemMarker(probLocPath, probURI, targetUri, problems[probCnt], iResource);
                        ++probCnt;
                    }
                    if (!result.isFatalResource()) continue;
                    return;
                }
            }
            catch (CoreException err) {
                throw new ModelerCoreException(err);
            }
        }
    }

    @Override
    public boolean isValidatorForResource(IResource iResource) {
        return ModelUtil.isModelFile(iResource) && !ModelUtil.isXsdFile(iResource);
    }

    @Override
    public void validate(IProgressMonitor progressMonitor, Resource resource, IResource iResource, ValidationContext context) throws ModelerCoreException {
        IProgressMonitor monitor;
        Object object = monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        if (!(resource instanceof EmfResource)) {
            String msg = ModelerCore.Util.getString("XmiResourceValidator.XmiResourceValidator_may_only_be_used_to_validate_instances_of_EmfResource_1", new Object[0]);
            throw new ModelerCoreException(msg);
        }
        if (iResource == null) {
            String msg = ModelerCore.Util.getString("XmiResourceValidator.IResource_may_not_be_null_during_validation_2", new Object[0]);
            throw new ModelerCoreException(msg);
        }
        if (!this.isValidatorForResource(iResource)) {
            String msg = ModelerCore.Util.getString("XmiResourceValidator.Unexpected_IResource_type_encountered_during_EMF_Resource_Validation_1", new Object[0]);
            throw new ModelerCoreException(msg);
        }
        EmfResource emfResource = (EmfResource)resource;
        if (emfResource.isLoaded()) {
            try {
                Validator.validate(monitor, emfResource, context);
            }
            catch (Throwable e) {
                String msg = ModelerCore.Util.getString("ModelBuilder.Error_validating_model_resource_2", (Object)emfResource);
                ModelerCore.Util.log(4, e, msg);
            }
        }
    }

    @Override
    public void validationStarted(Collection resources, ValidationContext context) {
    }

    @Override
    public void validationEnded(ValidationContext context) {
    }

    private void createProblemMarker(String locationPath, String locationUri, String targetUri, ValidationProblem problem, IResource resource) throws CoreException {
        IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttribute("location", (Object)locationPath);
        marker.setAttribute("org.teiid.designer.core.markerURI", (Object)locationUri);
        marker.setAttribute("org.teiid.designer.core.targetMarkerURI", (Object)targetUri);
        marker.setAttribute("message", (Object)problem.getMessage());
        this.setMarkerSeverity(marker, problem);
    }

    private void setMarkerSeverity(IMarker marker, ValidationProblem problem) throws CoreException {
        switch (problem.getSeverity()) {
            case 4: {
                marker.setAttribute("severity", 2);
                break;
            }
            case 2: {
                marker.setAttribute("severity", 1);
                break;
            }
            case 1: {
                marker.setAttribute("severity", 0);
                break;
            }
            default: {
                return;
            }
        }
    }
}

