/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.container;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.FindRelatedObjectsToBeCopied;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.ContainerEditingDomain;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;

public class CloneCommand
extends CompoundCommand {
    private final EditingDomain domain;
    private final Collection objectsToBeCloned;
    private final CopyCommand.Helper helper;
    private final Collection results;

    public static Command create(EditingDomain domain, EObject objectToBeCloned) {
        if (domain == null) {
            CloneCommand command = new CloneCommand(domain, objectToBeCloned);
            return command;
        }
        Command command = domain.createCommand(CloneCommand.class, new CommandParameter(null, null, (Object)objectToBeCloned));
        return command;
    }

    public static Command create(EditingDomain domain, Collection objectsToBeCloned) {
        if (domain == null) {
            CloneCommand command = new CloneCommand(domain, objectsToBeCloned);
            return command;
        }
        Command command = domain.createCommand(CloneCommand.class, new CommandParameter(null, null, objectsToBeCloned));
        return command;
    }

    public CloneCommand(EditingDomain domain, EObject objectToBeCloned) {
        this(domain, Collections.singletonList(objectToBeCloned));
    }

    public CloneCommand(EditingDomain domain, Collection objectsToBeCloned) {
        this.domain = domain;
        this.objectsToBeCloned = objectsToBeCloned;
        this.helper = new CopyCommand.Helper();
        this.results = new HashSet();
    }

    public CopyCommand.Helper getHelper() {
        return this.helper;
    }

    protected boolean prepare() {
        return this.objectsToBeCloned != null && !this.objectsToBeCloned.isEmpty();
    }

    public void execute() {
        this.commandList.clear();
        this.addCommandsToClone(this.objectsToBeCloned, true);
        if (this.domain instanceof ContainerEditingDomain) {
            FindRelatedObjectsToBeCopied visitor = new FindRelatedObjectsToBeCopied();
            ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
            try {
                processor.walk(this.objectsToBeCloned, 2);
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
            Collection additionalObjs = visitor.getAdditionalObjects();
            if (additionalObjs.size() != 0) {
                this.addCommandsToClone(additionalObjs, false);
            }
        }
    }

    public Collection getResult() {
        return this.results;
    }

    protected void addCommandsToClone(Collection objectsToClone, boolean addToResults) {
        if (!objectsToClone.isEmpty()) {
            HashSet annotations = new HashSet();
            HashSet transformations = new HashSet();
            HashSet mappingClassSets = new HashSet();
            LinkedList remaining = new LinkedList();
            for (Object additionalObj : objectsToClone) {
                if (additionalObj instanceof Annotation) {
                    annotations.add(additionalObj);
                    continue;
                }
                if (additionalObj instanceof TransformationMappingRoot) {
                    transformations.add(additionalObj);
                    continue;
                }
                if (additionalObj instanceof MappingClassSet) {
                    mappingClassSets.add(additionalObj);
                    continue;
                }
                remaining.add(additionalObj);
            }
            if (annotations.size() != 0) {
                this.cloneAndAdd(annotations, addToResults);
            }
            if (mappingClassSets.size() != 0) {
                this.cloneAndAdd(mappingClassSets, addToResults);
            }
            if (transformations.size() != 0) {
                this.cloneAndAdd(transformations, addToResults);
            }
            if (remaining.size() != 0) {
                this.cloneAndAdd(remaining, addToResults);
            }
        }
    }

    protected void cloneAndAdd(Collection objectsToClone, boolean addToResults) {
        for (Object obj : objectsToClone) {
            Command addCommand;
            int index;
            EObject parent;
            EObject eObject;
            Command copyCommand;
            boolean copied;
            if (!(obj instanceof EObject) || !(copied = this.appendAndExecute(copyCommand = this.domain.createCommand(CopyCommand.class, new CommandParameter((Object)(eObject = (EObject)obj), null, (Object)this.helper))))) continue;
            Collection copiedObjects = copyCommand.getResult();
            if (addToResults) {
                this.results.addAll(copiedObjects);
            }
            if ((parent = eObject.eContainer()) != null) {
                List values;
                EReference reference = eObject.eContainmentFeature();
                if (reference == null || !reference.isMany() || !((values = (List)parent.eGet((EStructuralFeature)reference)) instanceof EList)) continue;
                index = values.indexOf(eObject) + 1;
                addCommand = AddCommand.create((EditingDomain)this.domain, (Object)parent, (Object)reference, (Collection)copiedObjects, (int)index);
                this.appendAndExecute(addCommand);
                continue;
            }
            Resource resource = eObject.eResource();
            if (resource == null) continue;
            EList roots = resource.getContents();
            index = roots.indexOf(eObject) + 1;
            addCommand = AddCommand.create((EditingDomain)this.domain, (Object)resource, null, (Collection)copiedObjects, (int)index);
            this.appendAndExecute(addCommand);
        }
    }
}

