/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyToClipboardCommand;
import org.eclipse.emf.edit.command.CutToClipboardCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.domain.MappingDomain;
import org.teiid.designer.core.container.CopyWithRelatedToClipboardCommand;
import org.teiid.designer.core.container.CutWithRelatedToClipboardCommand;
import org.teiid.designer.core.container.PasteWithRelatedFromClipboardCommand;
import org.teiid.designer.core.util.ModelContents;

public class ContainerEditingDomain
extends AdapterFactoryEditingDomain
implements MappingDomain {
    private Map clipboardContentsKeyedByOriginals;
    private ModelContents clipboardModelContents;

    public ContainerEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack) {
        super(adapterFactory, commandStack);
    }

    public ContainerEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack, ResourceSet resourceSet) {
        super(adapterFactory, commandStack, resourceSet);
    }

    public Command createCommand(Class commandClass, CommandParameter commandParameter) {
        if (commandClass == AddCommand.class && commandParameter.owner instanceof Resource) {
            Resource resource = (Resource)commandParameter.owner;
            return new AddCommand((EditingDomain)this, resource.getContents(), commandParameter.getCollection(), commandParameter.getIndex());
        }
        if (commandClass == RemoveCommand.class && commandParameter.owner instanceof Resource) {
            Resource resource = (Resource)commandParameter.owner;
            return new RemoveCommand((EditingDomain)this, resource.getContents(), commandParameter.getCollection());
        }
        if (commandClass == MoveCommand.class && commandParameter.owner instanceof Resource) {
            Resource resource = (Resource)commandParameter.owner;
            int index = commandParameter.getIndex();
            Object value = commandParameter.getCollection();
            if (value == null) {
                value = commandParameter.getValue();
            }
            return new MoveCommand((EditingDomain)this, resource.getContents(), value, index);
        }
        if (commandClass == CutToClipboardCommand.class) {
            Command actualCommand = super.createCommand(commandClass, commandParameter);
            return new CutWithRelatedToClipboardCommand(actualCommand, (EditingDomain)this, commandParameter.getCollection());
        }
        if (commandClass == CopyToClipboardCommand.class) {
            return new CopyWithRelatedToClipboardCommand((EditingDomain)this, commandParameter.getCollection());
        }
        if (commandClass == PasteFromClipboardCommand.class) {
            return new PasteWithRelatedFromClipboardCommand((EditingDomain)this, commandParameter.owner, commandParameter.feature, commandParameter.index);
        }
        return super.createCommand(commandClass, commandParameter);
    }

    public void setClipboard(Collection clipboard) {
        super.setClipboard(clipboard);
        this.clipboardContentsKeyedByOriginals = null;
        this.clipboardModelContents = null;
    }

    public void setClipboardMapping(Map clipboardContentsKeyedByOriginals) {
        this.clipboardContentsKeyedByOriginals = clipboardContentsKeyedByOriginals;
    }

    public Map getClipboardContentsOriginalToCopyMapping() {
        return this.clipboardContentsKeyedByOriginals;
    }

    public Map getClipboardContentsCopyToOriginalMapping() {
        HashMap result = new HashMap();
        for (Map.Entry element : this.clipboardContentsKeyedByOriginals.entrySet()) {
            result.put(element.getValue(), element.getKey());
        }
        return result;
    }

    public ModelContents getClipboardModelContents(boolean forceCreate) {
        if (this.clipboardModelContents == null && forceCreate) {
            this.clipboardModelContents = new ClipboardModelContents();
        }
        return this.clipboardModelContents;
    }

    public ModelContents createClipboardModelContents() {
        return new ClipboardModelContents();
    }

    public void setClipboardModelContents(ModelContents contents) {
        this.clipboardModelContents = contents;
    }

    public int getMappingEnablementFlags() {
        return 0;
    }

    public MappingRoot getMappingRoot() {
        return null;
    }

    public String getName(Object object) {
        return null;
    }

    public EObject getOutputMetaObject(EObject inputMetaObject) {
        return null;
    }

    public String getOutputName(String inputName) {
        return null;
    }

    public Object getOutputTypeClassifier(Object inputTypeClassifier) {
        return null;
    }

    public Object getTypeClassifier(Object mappedObject) {
        return null;
    }

    public List parseInputName(String inputName) {
        return null;
    }

    public List parseOutputName(String outputName) {
        return null;
    }

    public void setMappingRoot(MappingRoot root) {
    }

    public void setName(Object object, String name) {
    }

    public void setTypeClassifier(Object mappedObject, Object typeClassifier) {
    }

    protected class ClipboardModelContents
    extends ModelContents {
        private final List rootObjects = new ArrayList();

        @Override
        public List getAllRootEObjects() {
            return this.rootObjects;
        }

        @Override
        protected URI getUri() {
            return URI.createURI((String)"Clipboard contents");
        }

        @Override
        protected void setModified(boolean modified) {
        }
    }
}

