/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.container;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.FindRelatedObjectsToBeCopied;
import org.teiid.designer.core.ModelEditorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.ContainerEditingDomain;
import org.teiid.designer.core.container.CopyToClipboardCommandWithMapping;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.CoreFactory;
import org.teiid.designer.metamodels.core.CorePackage;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.metamodels.transformation.TransformationFactory;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TransformationPackage;

public class CopyWithRelatedToClipboardCommand
extends CompoundCommand {
    private final Collection originals;
    private final CopyToClipboardCommandWithMapping mainCopyCommand;
    private final EditingDomain domain;

    public CopyWithRelatedToClipboardCommand(EditingDomain domain, Collection collection) {
        this.originals = collection;
        this.domain = domain;
        this.mainCopyCommand = new CopyToClipboardCommandWithMapping(domain, collection);
        this.append((Command)this.mainCopyCommand);
    }

    public void execute() {
        super.execute();
        if (this.originals != null && this.originals.size() != 0) {
            this.doCopyRelatedObjects();
        }
    }

    protected void doCopyRelatedObjects() {
        if (this.domain instanceof ContainerEditingDomain) {
            FindRelatedObjectsToBeCopied visitor = new FindRelatedObjectsToBeCopied();
            ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
            try {
                processor.walk(this.originals, 2);
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
            Collection additionalObjs = visitor.getAdditionalObjects();
            if (additionalObjs.size() != 0) {
                ModelContents modelContents = ((ContainerEditingDomain)this.domain).getClipboardModelContents(true);
                this.doCreateAdditionalCommands(additionalObjs, modelContents);
            }
        }
    }

    protected Collection doCreateAdditionalCommands(Collection additionalObjs, ModelContents targetContents) {
        EReference feature;
        AnnotationContainer container;
        if (additionalObjs.isEmpty()) {
            return additionalObjs;
        }
        HashSet annotations = new HashSet();
        HashSet transformations = new HashSet();
        HashSet mappingClassSets = new HashSet();
        LinkedList remaining = new LinkedList();
        for (Object additionalObj : additionalObjs) {
            if (additionalObj instanceof Annotation) {
                annotations.add(additionalObj);
                continue;
            }
            if (additionalObj instanceof TransformationMappingRoot) {
                transformations.add(additionalObj);
                continue;
            }
            if (additionalObj instanceof MappingClassSet) {
                mappingClassSets.add(additionalObj);
                continue;
            }
            remaining.add(additionalObj);
        }
        if (annotations.size() != 0) {
            container = targetContents.getAnnotationContainer(true);
            if (container == null) {
                container = CoreFactory.eINSTANCE.createAnnotationContainer();
                targetContents.getAllRootEObjects().add(container);
            }
            feature = CorePackage.eINSTANCE.getAnnotationContainer_Annotations();
            this.copyAndAdd(annotations, (EObject)container, (EStructuralFeature)feature);
        }
        if (mappingClassSets.size() != 0) {
            container = targetContents.getMappingClassSetContainer(true);
            if (container == null) {
                container = TransformationFactory.eINSTANCE.createMappingClassSetContainer();
                targetContents.getAllRootEObjects().add(container);
            }
            feature = TransformationPackage.eINSTANCE.getMappingClassSetContainer_MappingClassSets();
            this.copyAndAdd(mappingClassSets, (EObject)container, (EStructuralFeature)feature);
        }
        if (transformations.size() != 0) {
            container = targetContents.getTransformationContainer(true);
            if (container == null) {
                container = TransformationFactory.eINSTANCE.createTransformationContainer();
                targetContents.getAllRootEObjects().add(container);
            }
            feature = TransformationPackage.eINSTANCE.getTransformationContainer_TransformationMappings();
            this.copyAndAdd(transformations, (EObject)container, (EStructuralFeature)feature);
        }
        return null;
    }

    protected void copyAndAdd(Set additionalObjects, EObject container, EStructuralFeature feature) {
        Collection copiedAnnotations;
        Command addCommand;
        boolean added;
        CopyCommand.Helper helper = this.mainCopyCommand.getCopyKeyedByOriginalMap();
        Command copyCommand = ModelEditorImpl.createCopyCommand(this.domain, additionalObjects, helper);
        boolean copied = this.appendAndExecute(copyCommand);
        if (copied && !(added = this.appendAndExecute(addCommand = AddCommand.create((EditingDomain)this.domain, (Object)container, (Object)feature, (Collection)(copiedAnnotations = copyCommand.getResult()))))) {
            Object[] params = new Object[]{new Integer(copiedAnnotations.size()), feature.getName()};
            String msg = ModelerCore.Util.getString("CopyWithRelatedToClipboardCommand.Failed_to_add_{0}_copied_{1}_to_clipboard", params);
            ModelerCore.Util.log((Object)msg);
        }
    }
}

