/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.container;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.resource.EmfResourceSet;

public class CrossContainerFinder {
    private final Container sourceContainer;
    private final Container targetContainer;

    public CrossContainerFinder(Container container1, Container container2) {
        this.sourceContainer = container1;
        this.targetContainer = container2;
    }

    public EObject find(EObject object) {
        Resource sourceRes;
        Resource targetRes;
        if (object != null && (targetRes = this.find(sourceRes = object.eResource())) != null) {
            if (!targetRes.isLoaded()) {
                try {
                    targetRes.load(targetRes.getResourceSet().getLoadOptions());
                }
                catch (IOException e) {
                    ModelerCore.Util.log((Throwable)e);
                }
            }
            return targetRes.getEObject(sourceRes.getURIFragment(object));
        }
        return null;
    }

    public Resource find(Resource resource) {
        Resource rv;
        Container srcCont;
        ResourceSet sourceResourceSet = resource.getResourceSet();
        if (sourceResourceSet instanceof Container) {
            srcCont = (Container)sourceResourceSet;
        } else if (sourceResourceSet instanceof EmfResourceSet) {
            srcCont = ((EmfResourceSet)sourceResourceSet).getContainer();
        } else {
            return null;
        }
        Container tgtCont = srcCont == this.sourceContainer ? this.targetContainer : this.sourceContainer;
        if (resource instanceof EmfResource) {
            EmfResource eRes = (EmfResource)resource;
            ObjectID uuid = eRes.getUuid();
            rv = tgtCont.getResourceFinder().findByUUID(uuid, false);
        } else {
            String xsdName = resource.getURI().lastSegment();
            Resource[] wsRes = tgtCont.getResourceFinder().findByName(xsdName, true, false);
            rv = wsRes[0];
        }
        return rv;
    }

    public static CrossContainerFinder createWorkspaceFinder(Container source) {
        try {
            return new CrossContainerFinder(source, ModelerCore.getModelContainer());
        }
        catch (CoreException e) {
            ModelerCore.Util.log((Throwable)e);
            return null;
        }
    }
}

