/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelEditorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.ContainerEditingDomain;
import org.teiid.designer.core.search.ModelWorkspaceSearch;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.CoreFactory;
import org.teiid.designer.metamodels.core.CorePackage;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.metamodels.transformation.TransformationFactory;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TransformationPackage;

public class CutWithRelatedToClipboardCommand
extends CompoundCommand {
    private final Collection originals;
    private final Command mainCommand;
    private final EditingDomain domain;
    private final List additionalObjs;
    private ModelContents clipboardModelContents = null;

    public CutWithRelatedToClipboardCommand(Command command, EditingDomain domain, Collection collection) {
        this.originals = collection;
        this.domain = domain;
        this.mainCommand = command;
        this.additionalObjs = ((ModelEditorImpl)ModelerCore.getModelEditor()).findRelatedObjects(this.originals, this.domain);
        try {
            this.handleReferencingObjects();
        }
        catch (ModelerCoreException modelerCoreException) {}
        if (this.originals != null && this.originals.size() != 0) {
            this.clipboardModelContents = this.createAddCommandsForRelatedObjects();
        }
        this.append(this.mainCommand);
    }

    protected void handleReferencingObjects() throws ModelerCoreException {
        ModelEditor modelEditor = ModelerCore.getModelEditor();
        ArrayList<EObject> originalsToProcess = new ArrayList<EObject>(this.originals.size());
        ArrayList additionalCommands = new ArrayList();
        ModelWorkspaceSearch workspaceSearch = new ModelWorkspaceSearch();
        for (EObject eObj : this.originals) {
            if (eObj.eResource() == null) continue;
            originalsToProcess.add(eObj);
        }
        Collection allDeleted = modelEditor.findOtherObjectsToBeDeleted(originalsToProcess, this.domain, additionalCommands, workspaceSearch);
        modelEditor.findReferencesToObjectsBeingDeleted(allDeleted, this.domain, additionalCommands, workspaceSearch);
        Iterator cmdIter = additionalCommands.iterator();
        while (cmdIter.hasNext()) {
            this.append((Command)cmdIter.next());
        }
    }

    protected ModelContents createAddCommandsForRelatedObjects() {
        if (this.additionalObjs.size() != 0) {
            ContainerEditingDomain containerEdDomain = (ContainerEditingDomain)this.domain;
            ModelContents modelContents = containerEdDomain.createClipboardModelContents();
            this.doCreateAdditionalCommands(modelContents);
            containerEdDomain.setClipboardMapping((Map)((Object)new SelfKnowledgableCopyHelper()));
            return modelContents;
        }
        return null;
    }

    protected Collection doCreateAdditionalCommands(ModelContents targetContents) {
        EReference feature;
        AnnotationContainer container;
        if (this.additionalObjs.isEmpty()) {
            return this.additionalObjs;
        }
        HashSet annotations = new HashSet();
        HashSet mappingClassSets = new HashSet();
        HashSet transformations = new HashSet();
        ArrayList remaining = new ArrayList();
        for (Object additionalObj : this.additionalObjs) {
            if (additionalObj instanceof Annotation) {
                annotations.add(additionalObj);
                continue;
            }
            if (additionalObj instanceof MappingClassSet) {
                mappingClassSets.add(additionalObj);
                continue;
            }
            if (additionalObj instanceof TransformationMappingRoot) {
                transformations.add(additionalObj);
                continue;
            }
            remaining.add(additionalObj);
        }
        if (annotations.size() != 0) {
            container = targetContents.getAnnotationContainer(true);
            if (container == null) {
                container = CoreFactory.eINSTANCE.createAnnotationContainer();
                targetContents.getAllRootEObjects().add(container);
            }
            feature = CorePackage.eINSTANCE.getAnnotationContainer_Annotations();
            this.createAndAppendAddCommand(annotations, (EObject)container, (EStructuralFeature)feature);
        }
        if (mappingClassSets.size() != 0) {
            container = targetContents.getMappingClassSetContainer(true);
            if (container == null) {
                container = TransformationFactory.eINSTANCE.createMappingClassSetContainer();
                targetContents.getAllRootEObjects().add(container);
            }
            feature = TransformationPackage.eINSTANCE.getMappingClassSetContainer_MappingClassSets();
            this.createAndAppendAddCommand(mappingClassSets, (EObject)container, (EStructuralFeature)feature);
        }
        if (transformations.size() != 0) {
            container = targetContents.getTransformationContainer(true);
            if (container == null) {
                container = TransformationFactory.eINSTANCE.createTransformationContainer();
                targetContents.getAllRootEObjects().add(container);
            }
            feature = TransformationPackage.eINSTANCE.getTransformationContainer_TransformationMappings();
            this.createAndAppendAddCommand(transformations, (EObject)container, (EStructuralFeature)feature);
        }
        return null;
    }

    protected void createAndAppendAddCommand(Set objectsToAdd, EObject container, EStructuralFeature feature) {
        Command addCommand = AddCommand.create((EditingDomain)this.domain, (Object)container, (Object)feature, (Collection)objectsToAdd);
        this.append(addCommand);
    }

    public void execute() {
        this.domain.setClipboard(null);
        super.execute();
        if (this.clipboardModelContents != null && this.domain instanceof ContainerEditingDomain) {
            ContainerEditingDomain containerEdDomain = (ContainerEditingDomain)this.domain;
            ModelContents existingContents = containerEdDomain.getClipboardModelContents(false);
            if (existingContents == null) {
                containerEdDomain.setClipboardModelContents(this.clipboardModelContents);
            } else if (existingContents != this.clipboardModelContents) {
                String msg = ModelerCore.Util.getString("CutWithRelatedToClipboardCommand.Unexpected_existing_model_contents_on_clipboard", new Object[0]);
                ModelerCore.Util.log(2, msg);
                containerEdDomain.setClipboardModelContents(this.clipboardModelContents);
            }
        }
    }

    public class SelfKnowledgableCopyHelper
    extends CopyCommand.Helper {
        private static final long serialVersionUID = 1L;

        public EObject get(EObject key) {
            EObject result = (EObject)super.get((Object)key);
            if (result == null) {
                result = key;
            }
            return result;
        }

        public EObject getCopy(EObject object) {
            EObject result = super.getCopy(object);
            if (result == null) {
                result = object;
            }
            return result;
        }
    }
}

