/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ResourceFinder;
import org.teiid.designer.core.resource.MMXmiResource;
import org.teiid.designer.core.util.ModelObjectCollector;
import org.teiid.designer.core.util.UriHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelImport;

public class DefaultResourceFinder
implements ResourceFinder {
    private final Container container;

    public DefaultResourceFinder(Container container) {
        this.container = container;
    }

    @Override
    public Resource findByUUID(ObjectID uuid, boolean searchExternal) {
        Resource result = this.findResourceByUUID(uuid, new ArrayList(this.getContainer().getResources()));
        if (result == null && searchExternal) {
            ResourceSet[] externalSets = this.getContainer().getExternalResourceSets();
            int i = 0;
            while (i != externalSets.length) {
                result = this.findResourceByUUID(uuid, new ArrayList(externalSets[i].getResources()));
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    @Override
    public Resource findByUUID(ObjectID uuid, Resource[] scope) {
        return this.findResourceByUUID(uuid, Arrays.asList(scope));
    }

    @Override
    public Resource findByImport(ModelImport theImport, boolean searchExternal) {
        Resource result = this.findResourceByImport(theImport, new ArrayList(this.getContainer().getResources()));
        if (result == null && searchExternal) {
            ResourceSet[] externalSets = this.getContainer().getExternalResourceSets();
            int i = 0;
            while (i != externalSets.length) {
                result = this.findResourceByImport(theImport, new ArrayList(externalSets[i].getResources()));
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    @Override
    public Resource findByImport(ModelImport theImport, Resource[] scope) {
        return this.findResourceByImport(theImport, Arrays.asList(scope));
    }

    @Override
    public Resource findByImport(XSDSchemaDirective theImport, boolean searchExternal) {
        Resource result = this.findResourceByImport(theImport, new ArrayList(this.getContainer().getResources()));
        if (result == null && searchExternal) {
            ResourceSet[] externalSets = this.getContainer().getExternalResourceSets();
            int i = 0;
            while (i != externalSets.length) {
                result = this.findResourceByImport(theImport, new ArrayList(externalSets[i].getResources()));
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    @Override
    public Resource findByImport(XSDSchemaDirective theImport, Resource[] scope) {
        return this.findResourceByImport(theImport, Arrays.asList(scope));
    }

    @Override
    public Resource[] findByName(String theName, boolean caseSensitive, boolean searchExternal) {
        Collection result = this.findResourcesByName(theName, caseSensitive, new ArrayList(this.getContainer().getResources()));
        if (searchExternal) {
            ResourceSet[] externalSets = this.getContainer().getExternalResourceSets();
            int i = 0;
            while (i != externalSets.length) {
                result.addAll(this.findResourcesByName(theName, caseSensitive, new ArrayList(externalSets[i].getResources())));
                ++i;
            }
        }
        return result.toArray(new Resource[result.size()]);
    }

    @Override
    public Resource findByURI(URI theUri, boolean searchExternal) {
        Resource result = this.getContainer().getResource(theUri, false);
        if (result == null && searchExternal) {
            ResourceSet[] externalSets = this.getContainer().getExternalResourceSets();
            int i = 0;
            while (i != externalSets.length) {
                result = externalSets[i].getResource(theUri, false);
                if (result != null) break;
                ++i;
            }
        }
        if (result != null && !searchExternal && ModelerCore.getContainer(result) != this.getContainer()) {
            result = null;
        }
        return result;
    }

    @Override
    public Resource findByWorkspaceUri(URI theRelativeUri, Resource knownResource) {
        try {
            ModelResource mr = ModelerCore.getModelEditor().findModelResource(knownResource);
            if (mr != null && mr.getCorrespondingResource() != null) {
                ModelResource modelResource;
                IPath thePath = mr.getCorrespondingResource().getFullPath().removeLastSegments(1).append(theRelativeUri.toString());
                IResource iResrc = ModelerCore.getWorkspace().getRoot().findMember(thePath);
                if (iResrc instanceof IFile && (modelResource = ModelerCore.getModelEditor().findModelResource((IResource)((IFile)iResrc))) != null) {
                    return modelResource.getEmfResource();
                }
            }
        }
        catch (ModelWorkspaceException theException) {
            ModelerCore.Util.log((Throwable)((Object)theException));
        }
        return null;
    }

    @Override
    public boolean isExternalResource(URI theUri) {
        if (theUri != null) {
            return this.isExternalResource(this.findByURI(theUri, true));
        }
        return true;
    }

    @Override
    public boolean isExternalResource(Resource theResource) {
        return theResource == null || ModelerCore.getContainer(theResource) != this.getContainer();
    }

    @Override
    public boolean isBuiltInResource(Resource theResource) {
        if (theResource != null) {
            return this.isBuiltInResource(theResource.getURI());
        }
        return false;
    }

    @Override
    public boolean isBuiltInResource(URI theUri) {
        if (theUri == null) {
            return false;
        }
        if (this.findByURI(theUri, false) != null) {
            return false;
        }
        String uriString = URI.decode((String)theUri.toString());
        if (uriString.startsWith("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance") || uriString.endsWith("builtInDataTypes.xsd")) {
            return true;
        }
        if (uriString.startsWith("http://www.metamatrix.com/metamodels/UmlPrimitiveTypes-instance") || uriString.endsWith("primitiveTypes.xmi")) {
            return true;
        }
        if (uriString.startsWith("http://www.metamatrix.com/relationships/BuiltInRelationshipTypes-instance") || uriString.endsWith("builtInRelationshipTypes.xmi")) {
            return true;
        }
        ResourceSet globalResourceSet = XSDSchemaImpl.getGlobalResourceSet();
        if (globalResourceSet != null && globalResourceSet.getResource(theUri, false) != null) {
            return true;
        }
        if (uriString.endsWith("www.w3.org/2001/XMLSchema.xsd") || uriString.endsWith("www.w3.org/2001/MagicXMLSchema.xsd") || uriString.endsWith("www.w3.org/2001/XMLSchema-instance.xsd")) {
            return true;
        }
        if (uriString.startsWith("mtkplugin://")) {
            return true;
        }
        if (uriString.startsWith("pathmap://UML2_METAMODELS/")) {
            return true;
        }
        if (this.isBuiltInSystemResource(theUri)) {
            return true;
        }
        try {
            if (ModelerCore.getMetamodelRegistry().containsURI(theUri)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    @Override
    public boolean isBuiltInSystemResource(URI theUri) {
        if (theUri != null) {
            if (!this.isExternalResource(theUri)) {
                return false;
            }
            String uriString = URI.decode((String)theUri.toString());
            if (uriString.startsWith("http://www.metamatrix.com/models/System.xmi") || uriString.endsWith("System.xmi")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isBuiltInSystemResource(Resource theResource) {
        if (theResource != null) {
            return this.isBuiltInSystemResource(theResource.getURI());
        }
        return false;
    }

    public Resource[] findSystemResources() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource findByEObject(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource result = null;
        if (eObject.eIsProxy()) {
            URI proxyURI = ((InternalEObject)eObject).eProxyURI();
            result = this.findByURI(proxyURI.trimFragment(), true);
        } else {
            result = eObject.eResource();
        }
        return result;
    }

    @Override
    public Resource[] findReferencesFrom(Resource theResource, boolean recurse, boolean includeExternal) {
        List result = this.getExternallyReferencedResources(theResource, recurse, includeExternal);
        if (!includeExternal) {
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                Resource eResource = (Resource)iter.next();
                if (!this.isExternalResource(eResource)) continue;
                iter.remove();
            }
        }
        return result.toArray(new Resource[result.size()]);
    }

    @Override
    public Resource[] findReferencesTo(Resource theResource, boolean recurse) {
        HashSet<Resource> result = new HashSet<Resource>();
        if (theResource != null) {
            ArrayList eResources = new ArrayList(this.getContainer().getResources());
            eResources.remove(theResource);
            block0: for (Resource eResource : eResources) {
                List externalResources = this.getExternallyReferencedResources(eResource, recurse, true);
                for (Resource rsrc : externalResources) {
                    if (rsrc != theResource) continue;
                    result.add(eResource);
                    continue block0;
                }
            }
        }
        return result.toArray(new Resource[result.size()]);
    }

    @Override
    public String[] findUnresolvedResourceLocations(Resource theResource) {
        HashSet<String> result = new HashSet<String>();
        if (theResource != null) {
            ArrayList dummyList = new ArrayList();
            HashSet unresolvedURIs = new HashSet();
            this.addExternallyReferencedResources(theResource, false, true, dummyList, unresolvedURIs);
            for (URI uri : unresolvedURIs) {
                result.add(URI.decode((String)uri.toString()));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] findMissingImportLocations(Resource theResource) {
        HashSet<String> result = new HashSet<String>();
        if (theResource != null && theResource instanceof MMXmiResource) {
            Collection unresolvedResources = this.getResolvedExternalResources(theResource);
            for (Resource nextRes : unresolvedResources) {
                ModelImport existingImport;
                String location = ModelerCore.getModelEditor().createModelLocation((MMXmiResource)theResource, nextRes);
                if (location == null || (existingImport = ModelerCore.getModelEditor().getExistingModelImportForLocation((MMXmiResource)theResource, location)) != null) continue;
                result.add(location);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected Container getContainer() {
        return this.container;
    }

    protected Resource findResourceByUUID(ObjectID uuid, List eResources) {
        Resource result = null;
        if (uuid != null && eResources != null) {
            for (Resource rsrc : eResources) {
                if (!(rsrc instanceof MMXmiResource) || !uuid.equals(((MMXmiResource)rsrc).getUuid())) continue;
                result = rsrc;
                break;
            }
        }
        return result;
    }

    protected Resource findResourceByImport(ModelImport theImport, List eResources) {
        Resource result = null;
        if (theImport != null && eResources != null) {
            String path;
            String modelPath;
            ObjectID uuid;
            String uuidString = theImport.getUuid();
            if (!CoreStringUtil.isEmpty((String)uuidString) && (uuid = this.stringToObjectID(uuidString)) != null && (result = this.findResourceByUUID(uuid, eResources)) != null) {
                return result;
            }
            String modelLocation = theImport.getModelLocation();
            if (!CoreStringUtil.isEmpty((String)modelLocation) && theImport.eResource() != null) {
                URI modelLocationURI = URI.createURI((String)modelLocation);
                result = modelLocationURI.isRelative() ? this.findByWorkspaceUri(modelLocationURI, theImport.eResource()) : this.findByURI(modelLocationURI, true);
                if (result != null && eResources.contains(result)) {
                    return result;
                }
                result = null;
            }
            String string = modelPath = CoreStringUtil.isEmpty((String)(path = theImport.getPath())) ? modelLocation : path;
            if (!CoreStringUtil.isEmpty((String)modelPath)) {
                URI uri = URI.createURI((String)modelPath);
                result = this.findByURI(uri, true);
                if (result != null && eResources.contains(result)) {
                    return result;
                }
                result = null;
                String name = uri.lastSegment();
                Collection results = this.findResourcesByName(name, true, eResources);
                if (results.size() == 1) {
                    result = (Resource)results.iterator().next();
                } else if (results.size() > 1) {
                    for (Resource rsrc : eResources) {
                        String uriString = rsrc.getURI().toString();
                        if (!uriString.endsWith(modelPath)) continue;
                        return rsrc;
                    }
                }
            }
        }
        return result;
    }

    protected Resource findResourceByImport(XSDSchemaDirective theImport, List eResources) {
        String schemaLocation;
        Resource result = null;
        if (theImport != null && eResources != null && !CoreStringUtil.isEmpty((String)(schemaLocation = theImport.getSchemaLocation())) && theImport.eResource() != null) {
            URI uri = URI.createURI((String)schemaLocation);
            result = this.findByURI(uri, true);
            if (result != null && eResources.contains(result)) {
                return result;
            }
            result = null;
            XSDResourceImpl eResource = (XSDResourceImpl)theImport.eResource();
            URI baseLocationURI = eResource.getURI();
            URI schemaLocationURI = UriHelper.makeAbsoluteUri(baseLocationURI, schemaLocation);
            result = this.findByURI(schemaLocationURI, true);
            if (result != null && eResources.contains(result)) {
                return result;
            }
            result = null;
            String name = URI.createURI((String)schemaLocation).lastSegment();
            Collection results = this.findResourcesByName(name, true, eResources);
            if (results.size() == 1) {
                result = (Resource)results.iterator().next();
            } else if (results.size() > 1) {
                this.getExternallyReferencedResources((Resource)eResource, true, false);
                for (EObject eObj : eResource.getSchema().eContents()) {
                    Resource refResource;
                    XSDSchema resolvedSchema;
                    if (!(eObj instanceof XSDSchemaDirective) || theImport != eObj || (resolvedSchema = ((XSDSchemaDirective)eObj).getResolvedSchema()) == null || !eResources.contains(refResource = resolvedSchema.eResource())) continue;
                    return refResource;
                }
            }
        }
        return result;
    }

    protected Collection findResourcesByName(String name, boolean caseSensitive, List eResources) {
        HashSet<Resource> result = new HashSet<Resource>(3);
        if (name != null && eResources != null) {
            for (Resource rsrc : eResources) {
                if (rsrc == null) continue;
                String rsrcName = rsrc.getURI().lastSegment();
                if (caseSensitive && name.equals(rsrcName)) {
                    result.add(rsrc);
                }
                if (caseSensitive || !name.equalsIgnoreCase(rsrcName)) continue;
                result.add(rsrc);
            }
        }
        return result;
    }

    protected List getExternallyReferencedResources(Resource eResource, boolean recurse, boolean includeExternal) {
        ArrayList result = new ArrayList();
        HashSet unresolvedURIs = new HashSet();
        if (eResource != null) {
            this.addExternallyReferencedResources(eResource, recurse, includeExternal, result, unresolvedURIs);
            if (!unresolvedURIs.isEmpty()) {
                for (URI uri : unresolvedURIs) {
                    String msg = ModelerCore.Util.getString("DefaultResourceFinder.Unable_to_resolve_ref_to_resource_with_uri", (Object)uri);
                    ModelerCore.Util.log(4, msg);
                }
            }
        }
        return result;
    }

    protected Collection getResolvedExternalResources(Resource eResource) {
        ArrayList externalResources = new ArrayList();
        if (eResource != null) {
            this.addExternallyReferencedResources(eResource, false, true, externalResources, new HashSet());
        }
        return externalResources;
    }

    protected void addExternallyReferencedResources(Resource eResource, boolean recurse, boolean includeExternal, List result, Set unresolvedResourceURIs) {
        if (eResource != null) {
            if (!eResource.isLoaded()) {
                try {
                    eResource.load(this.getContainer().getLoadOptions());
                }
                catch (IOException iOException) {
                    String msg = ModelerCore.Util.getString("DefaultResourceFinder.Error_loading_resource", (Object)eResource);
                    ModelerCore.Util.log(4, msg);
                }
            }
            if (eResource instanceof XSDResourceImpl) {
                this.addExternallyReferencedResourcesForXsd((XSDResourceImpl)eResource, recurse, includeExternal, result, unresolvedResourceURIs);
            } else if (eResource instanceof MMXmiResource) {
                this.addExternallyReferencedResourcesForXmi((MMXmiResource)eResource, recurse, includeExternal, result, unresolvedResourceURIs);
            }
        }
    }

    protected void addExternallyReferencedResourcesForXmi(MMXmiResource eResource, boolean recurse, boolean includeExternal, List result, Set unresolvedResourceURIs) {
        if (eResource != null) {
            ModelObjectCollector moc = new ModelObjectCollector((Resource)eResource);
            ArrayList partialResult = new ArrayList();
            for (EObject eObject : moc.getEObjects()) {
                for (EReference eReference : eObject.eClass().getEAllReferences()) {
                    this.processReference((Resource)eResource, eObject, eReference, partialResult, unresolvedResourceURIs);
                }
            }
            for (Resource rsrc : partialResult) {
                if (rsrc == null || result.contains(rsrc) || !includeExternal && this.isExternalResource(rsrc)) continue;
                result.add(rsrc);
                if (!recurse) continue;
                this.addExternallyReferencedResources(rsrc, recurse, includeExternal, result, unresolvedResourceURIs);
            }
        }
    }

    protected void addExternallyReferencedResourcesForXsd(XSDResourceImpl eResource, boolean recurse, boolean includeExternal, List result, Set unresolvedResourceURIs) {
        if (eResource != null) {
            Resource rsrc;
            HashSet visitedXsdResources = new HashSet();
            this.resolveSchemaDirectives(eResource, recurse, visitedXsdResources, unresolvedResourceURIs);
            XSDSchema schema = eResource.getSchema();
            for (EObject eObj : schema.eContents()) {
                Resource rsrc2;
                if (!(eObj instanceof XSDSchemaDirective)) continue;
                XSDSchema resolvedSchema = ((XSDSchemaDirective)eObj).getResolvedSchema();
                Resource resource = rsrc2 = resolvedSchema != null ? resolvedSchema.eResource() : null;
                if (rsrc2 == null || result.contains(rsrc2) || !includeExternal && this.isExternalResource(rsrc2)) continue;
                result.add(rsrc2);
                if (!recurse) continue;
                this.addExternallyReferencedResources(rsrc2, recurse, includeExternal, result, unresolvedResourceURIs);
            }
            if (includeExternal && (rsrc = schema.getSchemaForSchema().eResource()) != null && !result.contains(rsrc)) {
                result.add(rsrc);
            }
        }
    }

    protected void resolveSchemaDirectives(XSDResourceImpl eResource, boolean recurse, Set visited, Set unresolvedResourceURIs) {
        if (eResource != null && !visited.contains(eResource)) {
            if (!eResource.isLoaded()) {
                try {
                    eResource.load(this.getContainer().getLoadOptions());
                }
                catch (IOException iOException) {
                    String msg = ModelerCore.Util.getString("DefaultResourceFinder.Error_loading_resource", (Object)eResource);
                    ModelerCore.Util.log(4, msg);
                }
            }
            visited.add(eResource);
            for (EObject eObj : eResource.getSchema().eContents()) {
                if (!(eObj instanceof XSDSchemaDirective)) continue;
                XSDSchema resolvedSchema = this.resolveSchemaDirective((XSDSchemaDirective)eObj);
                if (resolvedSchema == null || resolvedSchema.eResource() == null || resolvedSchema.eResource().getResourceSet() == null) {
                    URI unresolvedURI = URI.createURI((String)((XSDSchemaDirective)eObj).getSchemaLocation());
                    unresolvedResourceURIs.add(unresolvedURI);
                    continue;
                }
                if (!recurse) continue;
                this.resolveSchemaDirectives((XSDResourceImpl)resolvedSchema.eResource(), recurse, visited, unresolvedResourceURIs);
            }
        }
    }

    protected XSDSchema resolveSchemaDirective(XSDSchemaDirective directive) {
        XSDSchema resolvedSchema = null;
        if (directive != null) {
            resolvedSchema = directive.getResolvedSchema();
            if (resolvedSchema == null && directive instanceof XSDImportImpl) {
                resolvedSchema = ((XSDImportImpl)directive).importSchema();
            }
            if (resolvedSchema != null && resolvedSchema.eIsProxy()) {
                resolvedSchema = (XSDSchema)EcoreUtil.resolve((EObject)resolvedSchema, (ResourceSet)this.getContainer());
            }
            String location = directive.getSchemaLocation();
            XSDResourceImpl eResource = (XSDResourceImpl)directive.eResource();
            if (resolvedSchema == null && eResource != null && !CoreStringUtil.isEmpty((String)location)) {
                XSDResourceImpl refdResource = null;
                URI schemaLocationUri = UriHelper.makeAbsoluteUri(eResource.getURI(), location);
                refdResource = (XSDResourceImpl)this.findByURI(schemaLocationUri, false);
                if (refdResource != null) {
                    resolvedSchema = refdResource.getSchema();
                    directive.setResolvedSchema(resolvedSchema);
                    if (directive instanceof XSDImport) {
                        ((XSDSchemaImpl)resolvedSchema).imported((XSDImport)directive);
                    } else if (directive instanceof XSDInclude) {
                        ((XSDSchemaImpl)resolvedSchema).included((XSDInclude)directive);
                    } else if (directive instanceof XSDRedefine) {
                        ((XSDSchemaImpl)resolvedSchema).redefined((XSDRedefine)directive);
                    }
                }
            }
        }
        return resolvedSchema;
    }

    protected void processReference(Resource eResource, EObject eObject, EReference eReference, List externalResources, Set unresolvedResourceURIs) {
        if (!(eReference.isContainment() || eReference.isContainer() || eReference.isVolatile())) {
            Object value = eObject.eGet((EStructuralFeature)eReference, false);
            if (eReference.isMany()) {
                for (Object valueInList : (List)value) {
                    if (!(valueInList instanceof EObject)) continue;
                    this.processReferenceValue(eResource, eObject, eReference, (EObject)valueInList, externalResources, unresolvedResourceURIs);
                }
            } else if (value instanceof EObject) {
                this.processReferenceValue(eResource, eObject, eReference, (EObject)value, externalResources, unresolvedResourceURIs);
            }
        }
    }

    protected void processReferenceValue(Resource eResource, EObject eObject, EReference eReference, EObject value, List externalResources, Set unresolvedResourceURIs) {
        if (value == null) {
            return;
        }
        if (value.eIsProxy()) {
            if (value instanceof InternalEObject) {
                InternalEObject iObject = (InternalEObject)value;
                URI proxyUri = iObject.eProxyURI();
                CoreArgCheck.isNotNull((Object)proxyUri);
                URI resourceUri = proxyUri.trimFragment();
                URI baseLocationUri = eResource.getURI();
                URI proxyLocationUri = UriHelper.makeAbsoluteUri(baseLocationUri, resourceUri);
                Resource rsrc = this.findByURI(proxyLocationUri, true);
                if (rsrc == null && baseLocationUri.isFile() && resourceUri.toString().charAt(0) == '/') {
                    String baseLocation = URI.decode((String)baseLocationUri.toFileString());
                    String projectName = resourceUri.segment(0);
                    String proxyLocation = URI.decode((String)resourceUri.toString());
                    int index = baseLocation.indexOf(projectName);
                    if (index != -1) {
                        proxyLocation = String.valueOf(baseLocation.substring(0, index - 1)) + proxyLocation;
                        rsrc = this.findByURI(URI.createFileURI((String)proxyLocation), true);
                    }
                }
                if (rsrc != null && eResource != rsrc && !externalResources.contains(rsrc)) {
                    externalResources.add(rsrc);
                } else if (rsrc == null) {
                    unresolvedResourceURIs.add(resourceUri);
                }
            }
        } else {
            Resource rsrc = value.eResource();
            if (eResource != rsrc && !externalResources.contains(rsrc)) {
                externalResources.add(rsrc);
            }
        }
    }

    protected ObjectID stringToObjectID(String str) {
        if (str == null || str.length() < 43) {
            return null;
        }
        ObjectID uuid = null;
        String uuidString = this.extractUuidFromString(str);
        if (uuidString == null) {
            uuidString = this.extractUuidFromString(str.toLowerCase());
        }
        if (uuidString != null) {
            try {
                uuid = IDGenerator.getInstance().stringToObject(uuidString, "mmuuid");
            }
            catch (InvalidIDException e) {
                ModelerCore.Util.log(4, e.getMessage());
            }
        }
        return uuid;
    }

    protected String extractUuidFromString(String str) {
        if (str == null || str.length() < 43) {
            return null;
        }
        String uuidString = null;
        int strLength = str.length();
        if (strLength == 43) {
            if (str.startsWith("mmuuid:")) {
                uuidString = str;
            } else if (str.startsWith("mmuuid/")) {
                uuidString = "mmuuid:" + str.substring("mmuuid/".length());
            }
        } else {
            int endIndex;
            int beginIndex = str.indexOf("mmuuid:");
            if (beginIndex != -1) {
                endIndex = Math.min(strLength, beginIndex + 43);
                if (endIndex == strLength) {
                    uuidString = str.substring(beginIndex);
                } else if (endIndex < strLength) {
                    uuidString = str.substring(beginIndex, endIndex);
                }
            }
            if ((beginIndex = str.indexOf("mmuuid/")) != -1) {
                endIndex = Math.min(strLength, beginIndex + 43);
                if (endIndex == strLength) {
                    uuidString = "mmuuid:" + str.substring(beginIndex + "mmuuid/".length());
                } else if (endIndex < strLength) {
                    uuidString = "mmuuid:" + str.substring(beginIndex + "mmuuid/".length(), endIndex);
                }
            }
        }
        return uuidString;
    }
}

